/*
 * JBoss, Home of Professional Open Source
 * Copyright 2010, Red Hat Middleware LLC, and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */

package org.jboss.soa.esb.actions.soap.adapter.wsnative;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

import javax.wsdl.Definition;
import javax.wsdl.WSDLException;

import org.jboss.soa.esb.actions.soap.JBossWSDLLocatorImpl;
import org.jboss.soa.esb.actions.soap.JBossWSDLReader;
import org.jboss.soa.esb.actions.soap.adapter.JBossWSFactory;
import org.jboss.soa.esb.actions.soap.adapter.SOAPProcessorFactory;
import org.jboss.ws.core.utils.JBossWSEntityResolver;
import org.jboss.ws.metadata.umdm.ServerEndpointMetaData;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.xml.sax.EntityResolver;

/**
 * Factory for creating JBossWS native specific details.
 *  
 * @author <a href="mailto:kevin.conner@jboss.com">Kevin Conner</a>
 */
public class NativeFactory extends JBossWSFactory
{
    /**
     * The SOAP Processor factory.
     */
    private final SOAPProcessorFactory soapProcessorFactory = new JBossWSNativeFactory() ;
    
    @Override
    public SOAPProcessorFactory getSOAPProcessorFactory()
    {
        return soapProcessorFactory ;
    }

    @Override
    public String getWsdlLocation(final Endpoint endpoint, final String endpointName)
    {
        final ServerEndpointMetaData serverEndpointMetaData = endpoint.getAttachment(ServerEndpointMetaData.class);
        if (serverEndpointMetaData != null)
        {
            return serverEndpointMetaData.getServiceMetaData().getWsdlLocation().toExternalForm() ;
        }
        else
        {
            return null ;
        }
    }

    @Override
    public InputStream getWsdl(final String uri)
        throws IOException
    {
        throw new UnsupportedOperationException("getWsdl should not be called for native webservices, uri is " + uri) ;
    }

    @Override
    public Definition readWSDL(URL wsdlURL) throws WSDLException
    {
        EntityResolver entityResolver = new JBossWSEntityResolver();
        JBossWSDLReader wsdlReader = new JBossWSDLReader();
        Definition definition = wsdlReader.readWSDL(new JBossWSDLLocatorImpl(entityResolver, wsdlURL));
        return definition;
    }
}
