#!/bin/sh
#
# Run Riftsaw Integration tests.

MAVEN_OPTS="-Xms512M -Xmx1024M"

RIFTSAW_PARENT_DIR="$WORKSPACE"
DOWNLOAD_DIR="$RIFTSAW_PARENT_DIR/downloads"

JBOSS_VERSION="5.1.0.GA"
RIFTSAW_VERSION="2.3.6.Final"
AS_HOME="$RIFTSAW_PARENT_DIR/riftsaw-$RIFTSAW_VERSION/jboss-$JBOSS_VERSION"
REPLACE_QA_JDBC="true"
JBOSS_ESB_VERSION="4.10"
JBOSS_ESB_HOME="$RIFTSAW_PARENT_DIR/riftsaw-$RIFTSAW_VERSION/jbossesb-$JBOSS_ESB_VERSION"
AS_VERSION="5"

STARTUP_TIME="6"
TEST_DELAY="40000"

WS_STACK="native"
WS_VERSION="3.1.2.GA"
WS_STACK_DIR="$RIFTSAW_PARENT_DIR/downloads"

ANT_PROPERTIES="-Driftsaw.parent.dir=$RIFTSAW_PARENT_DIR -Ddatabase=$DATABASE -Dreplace.qa.jdbc=$REPLACE_QA_JDBC -Dorg.jboss.as.home=$AS_HOME -Dorg.jboss.as.config=$AS_CONFIG -Djbossesb.version=$JBOSS_ESB_VERSION -Dws.stack=$WS_STACK -Dws.version=$WS_VERSION -Dws.stack.dir=$WS_STACK_DIR -Dorg.jboss.esb.home=$JBOSS_ESB_HOME -Ddownload.dir=$DOWNLOAD_DIR -Dstartup.time=$STARTUP_TIME -Dtest.delay=$TEST_DELAY -Das.version=$AS_VERSION"
echo ANT_PROPERTIES=${ANT_PROPERTIES}

# build RiftSaw and running unit test
cd ..
mvn clean install -Pdocs -Dmaven.repo.local=${WORKSPACE}/m2-repo

# run integration test
cd qa
ant $ANT_PROPERTIES stop-server
ant $ANT_PROPERTIES clean
ant $ANT_PROPERTIES install.jbossesb

# build the RiftSaw and run integration tests

cd ../integration-tests
mvn $ANT_PROPERTIES clean install -Dmaven.repo.local=${WORKSPACE}/m2-repo
