/*
* JBoss, Home of Professional Open Source
* Copyright 2006, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.soa.esb.server.ftp;

import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;

import javax.management.ObjectName;

import junit.framework.Test;

import org.jboss.soa.esb.common.tests.BaseTest;
import org.jboss.soa.esb.server.StatsMBean;
import org.jboss.test.JBossTestCase;

/**
 * Sample client for the jboss container.
 *
 * @author <a href="mailto:bill@burkecentral.com">Bill Burke</a>
 * @version $Id: BlobUnitTestCase.java 58110 2006-11-04 08:34:21Z scott.stark@jboss.org $
 */

public class FtpUnitTest
        extends JBossTestCase
{
   public FtpUnitTest(String name)
   {
      super(name);
   }

   public void testFtp() throws Exception
   {
      sendFtp();
      Thread.sleep(10000); // wait for message to post.
      String version = (String)getServer().getAttribute(new ObjectName(StatsMBean.objectName), "ExecutedVersion");
      System.out.println("version=" + version);
      assertEquals("scope1", version);
   }

   public void sendFtp() throws Exception
   {

      final String hostname = System.getProperty(BaseTest.FTP_HOSTNAME, "localhost:10021");
      final String username = System.getProperty(BaseTest.FTP_USER, "esb");
      final String password = System.getProperty(BaseTest.FTP_PWD, "esb");
      final String dir = System.getProperty(BaseTest.FTP_DIR, "/") ;
      
      final String filename = "FtpUnitTestCase-" + new Date().getTime() + ".dat";
      final String contents = "Hello World from FTP";

      final URL url;
      final String dirVal;
      final String filenameVal;
      
      if (dir.length() > 0)
      {
          if (dir.charAt(0) == '/')
          {
             dirVal = (dir.length() > 1 ? "%2F" + dir.substring(1) : "%2F");
          }
          else
          {
             dirVal = dir;
          }
      
          if (dir.charAt(dir.length()-1) == '/')
          {
              filenameVal = filename;
          }
          else
          {
             filenameVal = '/' + filename;
          }
      }
      else
      {
          dirVal = dir ;
          filenameVal = filename ;
      }
      
      url = new URL("ftp://" + username + ":" + password + "@" + hostname + "/" + dirVal + filenameVal);
      System.out.println("FTP URL=" + url);

      final URLConnection connection;
      connection = url.openConnection();
      connection.setDoOutput(true);
      final OutputStream os;
      os = connection.getOutputStream();
      try
      {
         final PrintStream ps = new PrintStream(os);
         ps.print(contents);
         ps.close();
      }
      finally

      {
         os.close();
      }
   }

   public static Test suite() throws Exception
   {
       return getDeploySetup(FtpUnitTest.class, "ftp-test.esb");
   }

}
