/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2005-2006, JBoss Inc.
 */
package org.jboss.soa.esb.server.jbpmLocal;

import javax.management.ObjectName;

import junit.framework.Test;

import org.jboss.soa.esb.server.RedeliveryMBean;
import org.jboss.test.JBossTestCase;

/**
 * Test local variables for jBPM processes.
 * 
 * @author <a href='mailto:kevin.conner@jboss.com'>Kevin Conner</a>
 */
public class JbpmLocalUnitTest extends JBossTestCase
{
    /**
     * The name of the deployment archive.
     */
    private static final String ESB_ARCHIVE = "jbpm-local-test.esb" ;
    
    /**
     * Construct the test case with the specified name.
     * @param name The name of the test case.
     */
    public JbpmLocalUnitTest(final String name)
    {
        super(name) ;
    }
    
    /**
     * Test for local variables.
     * @throws Exception For any failures.
     */
    public void testLocalVariables()
        throws Exception
    {
        getServer().invoke(new ObjectName(JbpmServerMBean.OBJECT_NAME), "startProcess", null, null) ;
        
        final String expected = "0" ;
        
        final int numMessages = 4 ;
        final String[] messages = (String[])getServer().invoke(new ObjectName(RedeliveryMBean.objectName), "waitForMessages",
                new Integer[] {Integer.valueOf(numMessages)}, new String[] { Integer.TYPE.getName() });
        assertNotNull("log messages", messages) ;
        assertEquals("Message count", numMessages, messages.length) ;
        for(int count = 0 ; count < numMessages ; count++)
        {
        	assertNotNull("Message: " + count, messages[count]) ;
        }
        assertEquals("Initial message", expected, messages[0]) ;
        assertFalse("First child message", expected.equals(messages[1])) ;
        assertFalse("Second child message", expected.equals(messages[2])) ;
        assertFalse("Children are identical", messages[1].equals(messages[2])) ;
        assertEquals("Last message", expected, messages[3]) ;
    }
    
    /**
     * Create the test suite.
     * @return The suite representing this test case.
     */
    public static Test suite()
        throws Exception
    {
        return getDeploySetup(JbpmLocalUnitTest.class, ESB_ARCHIVE);
    }
}
