<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
>
    <xsl:output method="xml" version="1.0" encoding="ISO-8859-1" indent="yes"/>

    <xsl:template match="uddi/manager[@name='uddi-portlet-manager']/nodes/node[name='default']" >
      <node isHomeJUDDI="true">
        <xsl:apply-templates select="@*|node()" />
      </node>
      <node>
        <name>riftsaw</name> 
        <description>Riftsaw node</description>
        <xsl:comment>In VM Transport Settings </xsl:comment>
        <proxyTransport>org.jboss.internal.soa.esb.registry.client.JuddiInVMTransport</proxyTransport>
        <custodyTransferUrl>org.apache.juddi.api.impl.UDDICustodyTransferImpl</custodyTransferUrl>
        <inquiryUrl>org.apache.juddi.api.impl.UDDIInquiryImpl</inquiryUrl>
        <publishUrl>org.apache.juddi.api.impl.UDDIPublicationImpl</publishUrl>
        <securityUrl>org.apache.juddi.api.impl.UDDISecurityImpl</securityUrl>
        <subscriptionUrl>org.apache.juddi.api.impl.UDDISubscriptionImpl</subscriptionUrl>
        <subscriptionListenerUrl>org.apache.juddi.api.impl.UDDISubscriptionListenerImpl</subscriptionListenerUrl>
        <juddiApiUrl>org.apache.juddi.api.impl.JUDDIApiImpl</juddiApiUrl>
        <properties>
          <property name="keyDomain" value="riftsaw.jboss.org"/>
          <property name="businessKey" value="redhat-jboss"/>
        </properties>
      </node>
    </xsl:template>

    <xsl:template match="uddi/manager[@name='uddi-portlet-manager']" >
        <xsl:copy>
          <xsl:apply-templates select="@*|node()" />
          <clerks registerOnStartup="true">
            <clerk name="BPELClerk" node="riftsaw" password="" publisher="riftsaw"/>
          </clerks>

        </xsl:copy>
    </xsl:template>

    <xsl:template match="*|@*|node()" >
        <xsl:copy>
            <xsl:apply-templates select="@*|node()" />
        </xsl:copy>
    </xsl:template>
</xsl:stylesheet>
