/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.jffi;

import java.nio.ByteBuffer;
import jnr.ffi.Pointer;
import jnr.ffi.Runtime;
import jnr.ffi.provider.BoundedMemoryIO;
import jnr.ffi.provider.IntPointer;
import jnr.ffi.provider.MemoryManager;
import jnr.ffi.provider.jffi.ArrayMemoryIO;
import jnr.ffi.provider.jffi.ByteBufferMemoryIO;
import jnr.ffi.provider.jffi.DirectMemoryIO;
import jnr.ffi.provider.jffi.NativeRuntime;
import jnr.ffi.provider.jffi.TransientNativeMemory;

public class NativeMemoryManager
implements MemoryManager {
    private final NativeRuntime runtime;

    public NativeMemoryManager(NativeRuntime runtime) {
        this.runtime = runtime;
    }

    public Pointer allocate(int size2) {
        return new ArrayMemoryIO((Runtime)this.runtime, size2);
    }

    public Pointer allocateDirect(int size2) {
        return new BoundedMemoryIO(TransientNativeMemory.allocate(this.runtime, size2, Math.min(size2, 16), false), 0L, size2);
    }

    public Pointer allocateDirect(int size2, boolean clear2) {
        return new BoundedMemoryIO(TransientNativeMemory.allocate(this.runtime, size2, Math.min(size2, 16), true), 0L, size2);
    }

    public Pointer allocateTemporary(int size2) {
        return new BoundedMemoryIO(TransientNativeMemory.allocate(this.runtime, size2, Math.min(size2, 16), true), 0L, size2);
    }

    public Pointer allocateTemporary(int size2, boolean clear2) {
        return new BoundedMemoryIO(TransientNativeMemory.allocate(this.runtime, size2, Math.min(size2, 16), true), 0L, size2);
    }

    public Pointer newPointer(ByteBuffer buffer) {
        return new ByteBufferMemoryIO(this.runtime, buffer);
    }

    public Pointer newPointer(long address2) {
        return new DirectMemoryIO((Runtime)this.runtime, address2);
    }

    public Pointer newPointer(long address2, long size2) {
        return new BoundedMemoryIO(new DirectMemoryIO((Runtime)this.runtime, address2), 0L, size2);
    }

    public Pointer newOpaquePointer(long address2) {
        return new IntPointer((Runtime)this.runtime, address2);
    }
}

