/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.internal;

import org.jruby.Ruby;
import org.jruby.RubyNil;
import org.jruby.embed.EmbedRubyInterfaceAdapter;
import org.jruby.embed.InvokeFailedException;
import org.jruby.embed.ScriptingContainer;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmbedRubyInterfaceAdapterImpl
implements EmbedRubyInterfaceAdapter {
    private ScriptingContainer container;

    public EmbedRubyInterfaceAdapterImpl(ScriptingContainer container) {
        this.container = container;
    }

    @Override
    public <T> T getInstance(Object receiver2, Class<T> clazz) {
        Object o;
        if (clazz == null || !clazz.isInterface()) {
            return null;
        }
        Ruby runtime = this.container.getProvider().getRuntime();
        if (receiver2 == null || receiver2 instanceof RubyNil) {
            o = JavaEmbedUtils.rubyToJava(runtime, runtime.getTopSelf(), clazz);
        } else if (receiver2 instanceof IRubyObject) {
            o = JavaEmbedUtils.rubyToJava(runtime, (IRubyObject)receiver2, clazz);
        } else {
            IRubyObject rubyReceiver = JavaUtil.convertJavaToRuby(runtime, receiver2);
            o = JavaEmbedUtils.rubyToJava(runtime, rubyReceiver, clazz);
        }
        String name2 = clazz.getName();
        try {
            Class<?> c = Class.forName(name2, true, o.getClass().getClassLoader());
            return (T)c.cast(o);
        }
        catch (ClassNotFoundException e) {
            throw new InvokeFailedException(e);
        }
    }
}

