/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.io.IOException;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.RubyTime;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.BN;
import org.jruby.ext.openssl.OpenSSLImpl;
import org.jruby.ext.openssl.Utils;
import org.jruby.org.bouncycastle.asn1.ASN1Encodable;
import org.jruby.org.bouncycastle.asn1.ASN1EncodableVector;
import org.jruby.org.bouncycastle.asn1.ASN1InputStream;
import org.jruby.org.bouncycastle.asn1.ASN1Sequence;
import org.jruby.org.bouncycastle.asn1.DERBMPString;
import org.jruby.org.bouncycastle.asn1.DERBitString;
import org.jruby.org.bouncycastle.asn1.DERBoolean;
import org.jruby.org.bouncycastle.asn1.DEREnumerated;
import org.jruby.org.bouncycastle.asn1.DERGeneralString;
import org.jruby.org.bouncycastle.asn1.DERGeneralizedTime;
import org.jruby.org.bouncycastle.asn1.DERIA5String;
import org.jruby.org.bouncycastle.asn1.DERInteger;
import org.jruby.org.bouncycastle.asn1.DERNull;
import org.jruby.org.bouncycastle.asn1.DERNumericString;
import org.jruby.org.bouncycastle.asn1.DERObjectIdentifier;
import org.jruby.org.bouncycastle.asn1.DEROctetString;
import org.jruby.org.bouncycastle.asn1.DERPrintableString;
import org.jruby.org.bouncycastle.asn1.DERSequence;
import org.jruby.org.bouncycastle.asn1.DERSet;
import org.jruby.org.bouncycastle.asn1.DERString;
import org.jruby.org.bouncycastle.asn1.DERT61String;
import org.jruby.org.bouncycastle.asn1.DERTaggedObject;
import org.jruby.org.bouncycastle.asn1.DERUTCTime;
import org.jruby.org.bouncycastle.asn1.DERUTF8String;
import org.jruby.org.bouncycastle.asn1.DERUniversalString;
import org.jruby.org.bouncycastle.asn1.x509.X509Name;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASN1 {
    private static Map<Ruby, Map<String, DERObjectIdentifier>> SYM_TO_OID = new IdentityHashMap<Ruby, Map<String, DERObjectIdentifier>>();
    private static Map<Ruby, Map<DERObjectIdentifier, String>> OID_TO_SYM = new IdentityHashMap<Ruby, Map<DERObjectIdentifier, String>>();
    private static Map<Ruby, Map<DERObjectIdentifier, Integer>> OID_TO_NID = new IdentityHashMap<Ruby, Map<DERObjectIdentifier, Integer>>();
    private static Map<Ruby, Map<Integer, DERObjectIdentifier>> NID_TO_OID = new IdentityHashMap<Ruby, Map<Integer, DERObjectIdentifier>>();
    private static Map<Ruby, Map<Integer, String>> NID_TO_SN = new IdentityHashMap<Ruby, Map<Integer, String>>();
    private static Map<Ruby, Map<Integer, String>> NID_TO_LN = new IdentityHashMap<Ruby, Map<Integer, String>>();
    private static final Object[][] ASN1_INFO = new Object[][]{{"EOC", null, null}, {"BOOLEAN", DERBoolean.class, "Boolean"}, {"INTEGER", DERInteger.class, "Integer"}, {"BIT_STRING", DERBitString.class, "BitString"}, {"OCTET_STRING", DEROctetString.class, "OctetString"}, {"NULL", DERNull.class, "Null"}, {"OBJECT", DERObjectIdentifier.class, "ObjectId"}, {"OBJECT_DESCRIPTOR", null, null}, {"EXTERNAL", null, null}, {"REAL", null, null}, {"ENUMERATED", DEREnumerated.class, "Enumerated"}, {"EMBEDDED_PDV", null, null}, {"UTF8STRING", DERUTF8String.class, "UTF8String"}, {"RELATIVE_OID", null, null}, {"[UNIVERSAL 14]", null, null}, {"[UNIVERSAL 15]", null, null}, {"SEQUENCE", DERSequence.class, "Sequence"}, {"SET", DERSet.class, "Set"}, {"NUMERICSTRING", DERNumericString.class, "NumericString"}, {"PRINTABLESTRING", DERPrintableString.class, "PrintableString"}, {"T61STRING", DERT61String.class, "T61String"}, {"VIDEOTEXSTRING", null, null}, {"IA5STRING", DERIA5String.class, "IA5String"}, {"UTCTIME", DERUTCTime.class, "UTCTime"}, {"GENERALIZEDTIME", DERGeneralizedTime.class, "GeneralizedTime"}, {"GRAPHICSTRING", null, null}, {"ISO64STRING", null, null}, {"GENERALSTRING", DERGeneralString.class, "GeneralString"}, {"UNIVERSALSTRING", DERUniversalString.class, "UniversalString"}, {"CHARACTER_STRING", null, null}, {"BMPSTRING", DERBMPString.class, "BMPString"}};
    private static final Map<Class, Integer> CLASS_TO_ID = new HashMap<Class, Integer>();
    private static final Map<String, Integer> RUBYNAME_TO_ID = new HashMap<String, Integer>();
    private static final DateFormat dateF;

    static void addObject(Ruby runtime, int nid, String sn2, String ln2, String oid2) {
        Map<String, DERObjectIdentifier> s2o = SYM_TO_OID.get(runtime);
        Map<DERObjectIdentifier, String> o2s = OID_TO_SYM.get(runtime);
        Map<DERObjectIdentifier, Integer> o2n = OID_TO_NID.get(runtime);
        Map<Integer, DERObjectIdentifier> n2o = NID_TO_OID.get(runtime);
        Map<Integer, String> n2s = NID_TO_SN.get(runtime);
        Map<Integer, String> n2l = NID_TO_LN.get(runtime);
        if (null != oid2 && (null != sn2 || null != ln2)) {
            DERObjectIdentifier ident = new DERObjectIdentifier(oid2);
            if (sn2 != null) {
                s2o.put(sn2.toLowerCase(), ident);
            }
            if (ln2 != null) {
                s2o.put(ln2.toLowerCase(), ident);
            }
            o2s.put(ident, sn2 == null ? ln2 : sn2);
            o2n.put(ident, nid);
            n2o.put(nid, ident);
            n2s.put(nid, sn2);
            n2l.put(nid, ln2);
        }
    }

    private static synchronized void initMaps(Ruby runtime) {
        HashMap val = new HashMap(X509Name.DefaultLookUp);
        HashMap val2 = new HashMap(X509Name.DefaultSymbols);
        SYM_TO_OID.put(runtime, val);
        OID_TO_SYM.put(runtime, val2);
        OID_TO_NID.put(runtime, new HashMap());
        NID_TO_OID.put(runtime, new HashMap());
        NID_TO_SN.put(runtime, new HashMap());
        NID_TO_LN.put(runtime, new HashMap());
        OpenSSLImpl.defaultObjects(runtime);
    }

    static synchronized Integer obj2nid(Ruby runtime, String oid2) {
        return ASN1.obj2nid(runtime, new DERObjectIdentifier(oid2));
    }

    static synchronized String ln2oid(Ruby runtime, String ln2) {
        Map<String, DERObjectIdentifier> val = SYM_TO_OID.get(runtime);
        if (null == val) {
            ASN1.initMaps(runtime);
            val = SYM_TO_OID.get(runtime);
        }
        return val.get(ln2).getId();
    }

    static synchronized Integer obj2nid(Ruby runtime, DERObjectIdentifier oid2) {
        Map<DERObjectIdentifier, Integer> o2n = OID_TO_NID.get(runtime);
        if (null == o2n) {
            ASN1.initMaps(runtime);
            o2n = OID_TO_NID.get(runtime);
        }
        return o2n.get(oid2);
    }

    static synchronized String o2a(Ruby runtime, DERObjectIdentifier obj) {
        Integer nid = ASN1.obj2nid(runtime, obj);
        Map<Integer, String> n2l = NID_TO_LN.get(runtime);
        Map<Integer, String> n2s = NID_TO_SN.get(runtime);
        String one = n2l.get(nid);
        if (one == null) {
            one = n2s.get(nid);
        }
        return one;
    }

    static synchronized String nid2ln(Ruby runtime, int nid) {
        return ASN1.nid2ln(runtime, new Integer(nid));
    }

    static synchronized String nid2ln(Ruby runtime, Integer nid) {
        Map<Integer, String> n2l = NID_TO_LN.get(runtime);
        if (null == n2l) {
            ASN1.initMaps(runtime);
            n2l = NID_TO_LN.get(runtime);
        }
        return n2l.get(nid);
    }

    static synchronized Map<String, DERObjectIdentifier> getOIDLookup(Ruby runtime) {
        Map<String, DERObjectIdentifier> val = SYM_TO_OID.get(runtime);
        if (null == val) {
            ASN1.initMaps(runtime);
            val = SYM_TO_OID.get(runtime);
        }
        return val;
    }

    static synchronized Map<DERObjectIdentifier, String> getSymLookup(Ruby runtime) {
        Map<DERObjectIdentifier, String> val = OID_TO_SYM.get(runtime);
        if (null == val) {
            ASN1.initMaps(runtime);
            val = OID_TO_SYM.get(runtime);
        }
        return val;
    }

    public static int idForClass(Class type2) {
        Integer v = null;
        while (type2 != Object.class && v == null) {
            v = CLASS_TO_ID.get(type2);
            if (v != null) continue;
            type2 = type2.getSuperclass();
        }
        return null == v ? -1 : v;
    }

    public static int idForRubyName(String name2) {
        Integer v = RUBYNAME_TO_ID.get(name2);
        return null == v ? -1 : v;
    }

    public static Class<? extends ASN1Encodable> classForId(int id2) {
        Class result2 = (Class)ASN1_INFO[id2][1];
        return result2;
    }

    public static void createASN1(Ruby runtime, RubyModule ossl) {
        RubyModule mASN1 = ossl.defineModuleUnder("ASN1");
        RubyClass openSSLError = ossl.getClass("OpenSSLError");
        mASN1.defineClassUnder("ASN1Error", openSSLError, openSSLError.getAllocator());
        mASN1.defineAnnotatedMethods(ASN1.class);
        ArrayList<IRubyObject> ary = new ArrayList<IRubyObject>();
        mASN1.setConstant("UNIVERSAL_TAG_NAME", runtime.newArray(ary));
        for (int i2 = 0; i2 < ASN1_INFO.length; ++i2) {
            if (((String)ASN1_INFO[i2][0]).charAt(0) != '[') {
                ary.add(runtime.newString((String)ASN1_INFO[i2][0]));
                mASN1.setConstant((String)ASN1_INFO[i2][0], runtime.newFixnum(i2));
                continue;
            }
            ary.add(runtime.getNil());
        }
        RubyClass cASN1Data = mASN1.defineClassUnder("ASN1Data", runtime.getObject(), ASN1Data.ALLOCATOR);
        cASN1Data.addReadWriteAttribute(runtime.getCurrentContext(), "value");
        cASN1Data.addReadWriteAttribute(runtime.getCurrentContext(), "tag");
        cASN1Data.addReadWriteAttribute(runtime.getCurrentContext(), "tag_class");
        cASN1Data.defineAnnotatedMethods(ASN1Data.class);
        RubyClass cASN1Primitive = mASN1.defineClassUnder("Primitive", cASN1Data, ASN1Primitive.ALLOCATOR);
        cASN1Primitive.addReadWriteAttribute(runtime.getCurrentContext(), "tagging");
        cASN1Primitive.defineAnnotatedMethods(ASN1Primitive.class);
        RubyClass cASN1Constructive = mASN1.defineClassUnder("Constructive", cASN1Data, ASN1Constructive.ALLOCATOR);
        cASN1Constructive.includeModule(runtime.getModule("Enumerable"));
        cASN1Constructive.addReadWriteAttribute(runtime.getCurrentContext(), "tagging");
        cASN1Constructive.defineAnnotatedMethods(ASN1Constructive.class);
        mASN1.defineClassUnder("Boolean", cASN1Primitive, cASN1Primitive.getAllocator());
        mASN1.defineClassUnder("Integer", cASN1Primitive, cASN1Primitive.getAllocator());
        mASN1.defineClassUnder("Enumerated", cASN1Primitive, cASN1Primitive.getAllocator());
        RubyClass cASN1BitString = mASN1.defineClassUnder("BitString", cASN1Primitive, cASN1Primitive.getAllocator());
        mASN1.defineClassUnder("OctetString", cASN1Primitive, cASN1Primitive.getAllocator());
        mASN1.defineClassUnder("UTF8String", cASN1Primitive, cASN1Primitive.getAllocator());
        mASN1.defineClassUnder("NumericString", cASN1Primitive, cASN1Primitive.getAllocator());
        mASN1.defineClassUnder("PrintableString", cASN1Primitive, cASN1Primitive.getAllocator());
        mASN1.defineClassUnder("T61String", cASN1Primitive, cASN1Primitive.getAllocator());
        mASN1.defineClassUnder("VideotexString", cASN1Primitive, cASN1Primitive.getAllocator());
        mASN1.defineClassUnder("IA5String", cASN1Primitive, cASN1Primitive.getAllocator());
        mASN1.defineClassUnder("GraphicString", cASN1Primitive, cASN1Primitive.getAllocator());
        mASN1.defineClassUnder("ISO64String", cASN1Primitive, cASN1Primitive.getAllocator());
        mASN1.defineClassUnder("GeneralString", cASN1Primitive, cASN1Primitive.getAllocator());
        mASN1.defineClassUnder("UniversalString", cASN1Primitive, cASN1Primitive.getAllocator());
        mASN1.defineClassUnder("BMPString", cASN1Primitive, cASN1Primitive.getAllocator());
        mASN1.defineClassUnder("Null", cASN1Primitive, cASN1Primitive.getAllocator());
        RubyClass cASN1ObjectId = mASN1.defineClassUnder("ObjectId", cASN1Primitive, cASN1Primitive.getAllocator());
        mASN1.defineClassUnder("UTCTime", cASN1Primitive, cASN1Primitive.getAllocator());
        mASN1.defineClassUnder("GeneralizedTime", cASN1Primitive, cASN1Primitive.getAllocator());
        mASN1.defineClassUnder("Sequence", cASN1Constructive, cASN1Constructive.getAllocator());
        mASN1.defineClassUnder("Set", cASN1Constructive, cASN1Constructive.getAllocator());
        cASN1ObjectId.defineAnnotatedMethods(ObjectId.class);
        cASN1BitString.addReadWriteAttribute(runtime.getCurrentContext(), "unused_bits");
    }

    private static String getShortNameFor(Ruby runtime, String nameOrOid) {
        DERObjectIdentifier oid2 = ASN1.getObjectIdentifier(runtime, nameOrOid);
        Map<String, DERObjectIdentifier> em = ASN1.getOIDLookup(runtime);
        String name2 = null;
        for (String key2 : em.keySet()) {
            if (!oid2.equals(em.get(key2)) || name2 != null && key2.length() >= name2.length()) continue;
            name2 = key2;
        }
        return name2;
    }

    private static String getLongNameFor(Ruby runtime, String nameOrOid) {
        DERObjectIdentifier oid2 = ASN1.getObjectIdentifier(runtime, nameOrOid);
        Map<String, DERObjectIdentifier> em = ASN1.getOIDLookup(runtime);
        String name2 = null;
        for (String key2 : em.keySet()) {
            if (!oid2.equals(em.get(key2)) || name2 != null && key2.length() <= name2.length()) continue;
            name2 = key2;
        }
        return name2;
    }

    private static DERObjectIdentifier getObjectIdentifier(Ruby runtime, String nameOrOid) {
        DERObjectIdentifier val1 = ASN1.getOIDLookup(runtime).get(nameOrOid.toLowerCase());
        if (null != val1) {
            return val1;
        }
        DERObjectIdentifier val2 = new DERObjectIdentifier(nameOrOid);
        return val2;
    }

    @JRubyMethod(name={"Boolean"}, module=true, rest=true)
    public static IRubyObject fact_Boolean(IRubyObject recv2, IRubyObject[] args2) {
        return ((RubyModule)recv2).getClass("Boolean").callMethod(recv2.getRuntime().getCurrentContext(), "new", args2);
    }

    @JRubyMethod(name={"Integer"}, module=true, rest=true)
    public static IRubyObject fact_Integer(IRubyObject recv2, IRubyObject[] args2) {
        return ((RubyModule)recv2).getClass("Integer").callMethod(recv2.getRuntime().getCurrentContext(), "new", args2);
    }

    @JRubyMethod(name={"Enumerated"}, module=true, rest=true)
    public static IRubyObject fact_Enumerated(IRubyObject recv2, IRubyObject[] args2) {
        return ((RubyModule)recv2).getClass("Enumerated").callMethod(recv2.getRuntime().getCurrentContext(), "new", args2);
    }

    @JRubyMethod(name={"BitString"}, module=true, rest=true)
    public static IRubyObject fact_BitString(IRubyObject recv2, IRubyObject[] args2) {
        return ((RubyModule)recv2).getClass("BitString").callMethod(recv2.getRuntime().getCurrentContext(), "new", args2);
    }

    @JRubyMethod(name={"OctetString"}, module=true, rest=true)
    public static IRubyObject fact_OctetString(IRubyObject recv2, IRubyObject[] args2) {
        return ((RubyModule)recv2).getClass("OctetString").callMethod(recv2.getRuntime().getCurrentContext(), "new", args2);
    }

    @JRubyMethod(name={"UTF8String"}, module=true, rest=true)
    public static IRubyObject fact_UTF8String(IRubyObject recv2, IRubyObject[] args2) {
        return ((RubyModule)recv2).getClass("UTF8String").callMethod(recv2.getRuntime().getCurrentContext(), "new", args2);
    }

    @JRubyMethod(name={"NumericString"}, module=true, rest=true)
    public static IRubyObject fact_NumericString(IRubyObject recv2, IRubyObject[] args2) {
        return ((RubyModule)recv2).getClass("NumericString").callMethod(recv2.getRuntime().getCurrentContext(), "new", args2);
    }

    @JRubyMethod(name={"PrintableString"}, module=true, rest=true)
    public static IRubyObject fact_PrintableString(IRubyObject recv2, IRubyObject[] args2) {
        return ((RubyModule)recv2).getClass("PrintableString").callMethod(recv2.getRuntime().getCurrentContext(), "new", args2);
    }

    @JRubyMethod(name={"T61String"}, module=true, rest=true)
    public static IRubyObject fact_T61String(IRubyObject recv2, IRubyObject[] args2) {
        return ((RubyModule)recv2).getClass("T61String").callMethod(recv2.getRuntime().getCurrentContext(), "new", args2);
    }

    @JRubyMethod(name={"VideotexString"}, module=true, rest=true)
    public static IRubyObject fact_VideotexString(IRubyObject recv2, IRubyObject[] args2) {
        return ((RubyModule)recv2).getClass("VideotexString").callMethod(recv2.getRuntime().getCurrentContext(), "new", args2);
    }

    @JRubyMethod(name={"IA5String"}, module=true, rest=true)
    public static IRubyObject fact_IA5String(IRubyObject recv2, IRubyObject[] args2) {
        return ((RubyModule)recv2).getClass("IA5String").callMethod(recv2.getRuntime().getCurrentContext(), "new", args2);
    }

    @JRubyMethod(name={"GraphicString"}, module=true, rest=true)
    public static IRubyObject fact_GraphicString(IRubyObject recv2, IRubyObject[] args2) {
        return ((RubyModule)recv2).getClass("GraphicString").callMethod(recv2.getRuntime().getCurrentContext(), "new", args2);
    }

    @JRubyMethod(name={"ISO64String"}, module=true, rest=true)
    public static IRubyObject fact_ISO64String(IRubyObject recv2, IRubyObject[] args2) {
        return ((RubyModule)recv2).getClass("ISO64String").callMethod(recv2.getRuntime().getCurrentContext(), "new", args2);
    }

    @JRubyMethod(name={"GeneralString"}, module=true, rest=true)
    public static IRubyObject fact_GeneralString(IRubyObject recv2, IRubyObject[] args2) {
        return ((RubyModule)recv2).getClass("GeneralString").callMethod(recv2.getRuntime().getCurrentContext(), "new", args2);
    }

    @JRubyMethod(name={"UniversalString"}, module=true, rest=true)
    public static IRubyObject fact_UniversalString(IRubyObject recv2, IRubyObject[] args2) {
        return ((RubyModule)recv2).getClass("UniversalString").callMethod(recv2.getRuntime().getCurrentContext(), "new", args2);
    }

    @JRubyMethod(name={"BMPString"}, module=true, rest=true)
    public static IRubyObject fact_BMPString(IRubyObject recv2, IRubyObject[] args2) {
        return ((RubyModule)recv2).getClass("BMPString").callMethod(recv2.getRuntime().getCurrentContext(), "new", args2);
    }

    @JRubyMethod(name={"Nul"}, module=true, rest=true)
    public static IRubyObject fact_Null(IRubyObject recv2, IRubyObject[] args2) {
        return ((RubyModule)recv2).getClass("Null").callMethod(recv2.getRuntime().getCurrentContext(), "new", args2);
    }

    @JRubyMethod(name={"ObjectId"}, module=true, rest=true)
    public static IRubyObject fact_ObjectId(IRubyObject recv2, IRubyObject[] args2) {
        return ((RubyModule)recv2).getClass("ObjectId").callMethod(recv2.getRuntime().getCurrentContext(), "new", args2);
    }

    @JRubyMethod(name={"UTCTime"}, module=true, rest=true)
    public static IRubyObject fact_UTCTime(IRubyObject recv2, IRubyObject[] args2) {
        return ((RubyModule)recv2).getClass("UTCTime").callMethod(recv2.getRuntime().getCurrentContext(), "new", args2);
    }

    @JRubyMethod(name={"GeneralizedTime"}, module=true, rest=true)
    public static IRubyObject fact_GeneralizedTime(IRubyObject recv2, IRubyObject[] args2) {
        return ((RubyModule)recv2).getClass("GeneralizedTime").callMethod(recv2.getRuntime().getCurrentContext(), "new", args2);
    }

    @JRubyMethod(name={"Sequence"}, module=true, rest=true)
    public static IRubyObject fact_Sequence(IRubyObject recv2, IRubyObject[] args2) {
        return ((RubyModule)recv2).getClass("Sequence").callMethod(recv2.getRuntime().getCurrentContext(), "new", args2);
    }

    @JRubyMethod(name={"Set"}, module=true, rest=true)
    public static IRubyObject fact_Set(IRubyObject recv2, IRubyObject[] args2) {
        return ((RubyModule)recv2).getClass("Set").callMethod(recv2.getRuntime().getCurrentContext(), "new", args2);
    }

    @JRubyMethod(meta=true, required=1)
    public static IRubyObject traverse(IRubyObject recv2, IRubyObject a) {
        System.err.println("WARNING: unimplemented method called: traverse");
        return null;
    }

    private static IRubyObject decodeObj(RubyModule asnM, Object v) throws IOException, ParseException {
        int ix = ASN1.idForClass(v.getClass());
        String v_name = ix == -1 ? null : (String)ASN1_INFO[ix][2];
        ThreadContext tc = asnM.getRuntime().getCurrentContext();
        if (null != v_name) {
            RubyClass c = asnM.getClass(v_name);
            if (v instanceof DERBitString) {
                ByteList bl = new ByteList(((DERBitString)v).getBytes(), false);
                IRubyObject bString = c.callMethod(tc, "new", (IRubyObject)asnM.getRuntime().newString(bl));
                bString.callMethod(tc, "unused_bits=", asnM.getRuntime().newFixnum(((DERBitString)v).getPadBits()));
                return bString;
            }
            if (v instanceof DERString) {
                ByteList val = v instanceof DERUTF8String ? new ByteList(((DERUTF8String)v).getString().getBytes("UTF-8")) : ByteList.create(((DERString)v).getString());
                return c.callMethod(tc, "new", (IRubyObject)asnM.getRuntime().newString(val));
            }
            if (v instanceof ASN1Sequence) {
                ArrayList<IRubyObject> l = new ArrayList<IRubyObject>();
                Enumeration enm = ((ASN1Sequence)v).getObjects();
                while (enm.hasMoreElements()) {
                    l.add(ASN1.decodeObj(asnM, enm.nextElement()));
                }
                return c.callMethod(tc, "new", (IRubyObject)asnM.getRuntime().newArray(l));
            }
            if (v instanceof DERSet) {
                ArrayList<IRubyObject> l = new ArrayList<IRubyObject>();
                Enumeration enm = ((DERSet)v).getObjects();
                while (enm.hasMoreElements()) {
                    l.add(ASN1.decodeObj(asnM, enm.nextElement()));
                }
                return c.callMethod(tc, "new", (IRubyObject)asnM.getRuntime().newArray(l));
            }
            if (v instanceof DERNull) {
                return c.callMethod(tc, "new", asnM.getRuntime().getNil());
            }
            if (v instanceof DERInteger) {
                return c.callMethod(tc, "new", (IRubyObject)BN.newBN(asnM.getRuntime(), ((DERInteger)v).getValue()));
            }
            if (v instanceof DERUTCTime) {
                Date d = dateF.parse(((DERUTCTime)v).getAdjustedTime());
                Calendar cal = Calendar.getInstance();
                cal.setTime(d);
                IRubyObject[] argv = new IRubyObject[]{asnM.getRuntime().newFixnum(cal.get(1)), asnM.getRuntime().newFixnum(cal.get(2) + 1), asnM.getRuntime().newFixnum(cal.get(5)), asnM.getRuntime().newFixnum(cal.get(11)), asnM.getRuntime().newFixnum(cal.get(12)), asnM.getRuntime().newFixnum(cal.get(13))};
                return c.callMethod(tc, "new", asnM.getRuntime().getClass("Time").callMethod(tc, "local", argv));
            }
            if (v instanceof DERObjectIdentifier) {
                String av = ((DERObjectIdentifier)v).getId();
                return c.callMethod(tc, "new", (IRubyObject)asnM.getRuntime().newString(av));
            }
            if (v instanceof DEROctetString) {
                ByteList bl = new ByteList(((DEROctetString)v).getOctets(), false);
                return c.callMethod(tc, "new", (IRubyObject)asnM.getRuntime().newString(bl));
            }
            if (v instanceof DERBoolean) {
                return c.callMethod(tc, "new", (IRubyObject)(((DERBoolean)v).isTrue() ? asnM.getRuntime().getTrue() : asnM.getRuntime().getFalse()));
            }
            System.out.println("Should handle: " + v.getClass().getName());
        } else if (v instanceof DERTaggedObject) {
            RubyClass c = asnM.getClass("ASN1Data");
            IRubyObject val = ASN1.decodeObj(asnM, ((DERTaggedObject)v).getObject());
            RubyFixnum tag2 = asnM.getRuntime().newFixnum(((DERTaggedObject)v).getTagNo());
            RubySymbol tag_class = asnM.getRuntime().newSymbol("CONTEXT_SPECIFIC");
            return c.callMethod(tc, "new", new IRubyObject[]{asnM.getRuntime().newArray(val), tag2, tag_class});
        }
        return null;
    }

    @JRubyMethod(meta=true)
    public static IRubyObject decode(IRubyObject recv2, IRubyObject obj) {
        try {
            IRubyObject obj2 = OpenSSLImpl.to_der_if_possible(obj);
            RubyModule asnM = (RubyModule)recv2;
            ASN1InputStream asis = new ASN1InputStream(obj2.convertToString().getBytes());
            IRubyObject ret = ASN1.decodeObj(asnM, asis.readObject());
            return ret;
        }
        catch (IOException e) {
            throw recv2.getRuntime().newIOErrorFromException(e);
        }
        catch (Exception e) {
            throw recv2.getRuntime().newArgumentError(e.getMessage());
        }
    }

    @JRubyMethod(meta=true, required=1)
    public static IRubyObject decode_all(IRubyObject recv2, IRubyObject a) {
        System.err.println("WARNING: unimplemented method called: decode_all");
        return null;
    }

    static {
        for (int i2 = 0; i2 < ASN1_INFO.length; ++i2) {
            if (ASN1_INFO[i2][1] != null) {
                CLASS_TO_ID.put((Class)ASN1_INFO[i2][1], new Integer(i2));
            }
            if (ASN1_INFO[i2][2] == null) continue;
            RUBYNAME_TO_ID.put((String)ASN1_INFO[i2][2], new Integer(i2));
        }
        dateF = new SimpleDateFormat("yyyyMMddHHmmssz");
    }

    public static class ASN1Constructive
    extends ASN1Data {
        private static final long serialVersionUID = -7166662655104776828L;
        public static ObjectAllocator ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime, RubyClass klass) {
                return new ASN1Constructive(runtime, klass);
            }
        };

        public ASN1Constructive(Ruby runtime, RubyClass type2) {
            super(runtime, type2);
        }

        @JRubyMethod
        public IRubyObject to_der() {
            return super.to_der();
        }

        @JRubyMethod(required=1, optional=3)
        public IRubyObject initialize(IRubyObject[] args2) {
            IRubyObject value2 = args2[0];
            IRubyObject tag2 = this.getRuntime().getNil();
            IRubyObject tagging = this.getRuntime().getNil();
            IRubyObject tag_class = this.getRuntime().getNil();
            if (args2.length > 1) {
                tag2 = args2[1];
                if (args2.length > 2) {
                    tagging = args2[2];
                    if (args2.length > 3) {
                        tag_class = args2[3];
                    }
                }
                if (tag2.isNil()) {
                    this.asn1Error("must specify tag number");
                }
                if (tagging.isNil()) {
                    tagging = this.getRuntime().newSymbol("EXPLICIT");
                }
                if (!(tagging instanceof RubySymbol)) {
                    this.asn1Error("invalid tag default");
                }
                if (tag_class.isNil()) {
                    tag_class = this.getRuntime().newSymbol("CONTEXT_SPECIFIC");
                }
                if (!(tag_class instanceof RubySymbol)) {
                    this.asn1Error("invalid tag class");
                }
                if (tagging.toString().equals(":IMPLICIT") && RubyNumeric.fix2int(tag2) > 31) {
                    this.asn1Error("tag number for Universal too large");
                }
            } else {
                tag2 = this.defaultTag();
                tagging = this.getRuntime().getNil();
                tag_class = this.getRuntime().newSymbol("UNIVERSAL");
            }
            ThreadContext tc = this.getRuntime().getCurrentContext();
            this.callMethod(tc, "tag=", tag2);
            this.callMethod(tc, "value=", value2);
            this.callMethod(tc, "tagging=", tagging);
            this.callMethod(tc, "tag_class=", tag_class);
            return this;
        }

        ASN1Encodable toASN1() {
            int id2 = ASN1.idForRubyName(this.getMetaClass().getRealClass().getBaseName());
            if (id2 != -1) {
                ASN1EncodableVector vec = new ASN1EncodableVector();
                RubyArray arr = (RubyArray)this.callMethod(this.getRuntime().getCurrentContext(), "value");
                for (IRubyObject obj : arr.toJavaArray()) {
                    if (obj instanceof ASN1Data) {
                        vec.add(((ASN1Data)obj).toASN1());
                        continue;
                    }
                    vec.add(((ASN1Data)ASN1.decode(this.getRuntime().getClassFromPath("OpenSSL::ASN1"), OpenSSLImpl.to_der_if_possible(obj))).toASN1());
                }
                try {
                    ASN1Encodable result2 = (ASN1Encodable)((Class)ASN1_INFO[id2][1]).getConstructor(ASN1EncodableVector.class).newInstance(vec);
                    return result2;
                }
                catch (Exception e) {
                    throw RaiseException.createNativeRaiseException(this.getRuntime(), e);
                }
            }
            return null;
        }

        @JRubyMethod(frame=true)
        public IRubyObject each(Block block) {
            RubyArray arr = (RubyArray)this.callMethod(this.getRuntime().getCurrentContext(), "value");
            for (IRubyObject obj : arr.toJavaArray()) {
                block.yield(this.getRuntime().getCurrentContext(), obj);
            }
            return this.getRuntime().getNil();
        }

        protected void print(int indent) {
            this.printIndent(indent);
            System.out.println(this.getMetaClass().getRealClass().getBaseName() + ": ");
            RubyArray arr = (RubyArray)this.callMethod(this.getRuntime().getCurrentContext(), "value");
            for (IRubyObject obj : arr.toJavaArray()) {
                ((ASN1Data)obj).print(indent + 1);
            }
        }
    }

    public static class ASN1Primitive
    extends ASN1Data {
        private static final long serialVersionUID = 8489625559339190259L;
        public static ObjectAllocator ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime, RubyClass klass) {
                return new ASN1Primitive(runtime, klass);
            }
        };

        public ASN1Primitive(Ruby runtime, RubyClass type2) {
            super(runtime, type2);
        }

        public String toString() {
            return this.callMethod(this.getRuntime().getCurrentContext(), "value").toString();
        }

        @JRubyMethod
        public IRubyObject to_der() {
            return super.to_der();
        }

        @JRubyMethod(required=1, optional=4)
        public IRubyObject initialize(IRubyObject[] args2) {
            String v;
            IRubyObject value2 = args2[0];
            IRubyObject tag2 = this.getRuntime().getNil();
            IRubyObject tagging = this.getRuntime().getNil();
            IRubyObject tag_class = this.getRuntime().getNil();
            if (args2.length > 1) {
                tag2 = args2[1];
                if (args2.length > 2) {
                    tagging = args2[2];
                    if (args2.length > 3) {
                        tag_class = args2[3];
                    }
                }
                if (tag2.isNil()) {
                    this.asn1Error("must specify tag number");
                }
                if (tagging.isNil()) {
                    tagging = this.getRuntime().newSymbol("EXPLICIT");
                }
                if (!(tagging instanceof RubySymbol)) {
                    this.asn1Error("invalid tag default");
                }
                if (tag_class.isNil()) {
                    tag_class = this.getRuntime().newSymbol("CONTEXT_SPECIFIC");
                }
                if (!(tag_class instanceof RubySymbol)) {
                    this.asn1Error("invalid tag class");
                }
                if (tagging.toString().equals(":IMPLICIT") && RubyNumeric.fix2int(tag2) > 31) {
                    this.asn1Error("tag number for Universal too large");
                }
            } else {
                tag2 = this.defaultTag();
                tagging = this.getRuntime().getNil();
                tag_class = this.getRuntime().newSymbol("UNIVERSAL");
            }
            if ("ObjectId".equals(this.getMetaClass().getRealClass().getBaseName()) && (v = ASN1.getSymLookup(this.getRuntime()).get(this.getObjectIdentifier(value2.toString()))) != null) {
                value2 = this.getRuntime().newString(v);
            }
            ThreadContext tc = this.getRuntime().getCurrentContext();
            this.callMethod(tc, "tag=", tag2);
            this.callMethod(tc, "value=", value2);
            this.callMethod(tc, "tagging=", tagging);
            this.callMethod(tc, "tag_class=", tag_class);
            return this;
        }

        private DERObjectIdentifier getObjectIdentifier(String nameOrOid) {
            DERObjectIdentifier val1 = ASN1.getOIDLookup(this.getRuntime()).get(nameOrOid.toLowerCase());
            if (null != val1) {
                return val1;
            }
            DERObjectIdentifier val2 = new DERObjectIdentifier(nameOrOid);
            return val2;
        }

        ASN1Encodable toASN1() {
            int tag2 = ASN1.idForRubyName(this.getMetaClass().getRealClass().getBaseName());
            Class imp = (Class)ASN1_INFO[tag2][1];
            IRubyObject val = this.callMethod(this.getRuntime().getCurrentContext(), "value");
            if (imp == DERObjectIdentifier.class) {
                return this.getObjectIdentifier(val.toString());
            }
            if (imp == DERNull.class) {
                return new DERNull();
            }
            if (imp == DERBoolean.class) {
                return new DERBoolean(val.isTrue());
            }
            if (imp == DERUTCTime.class) {
                return new DERUTCTime(((RubyTime)val).getJavaDate());
            }
            if (imp == DERInteger.class && val instanceof RubyBignum) {
                return new DERInteger(((RubyBignum)val).getValue());
            }
            if (imp == DERInteger.class) {
                return new DERInteger(new BigInteger(val.toString()));
            }
            if (imp == DEROctetString.class) {
                return new DEROctetString(val.convertToString().getBytes());
            }
            if (imp == DERBitString.class) {
                byte[] bs = val.convertToString().getBytes();
                int unused2 = 0;
                for (int i2 = bs.length - 1; i2 > -1; --i2) {
                    if (bs[i2] == 0) {
                        unused2 += 8;
                        continue;
                    }
                    byte v2 = bs[i2];
                    int x = 8;
                    while (v2 != 0) {
                        v2 = (byte)(v2 << 1);
                        --x;
                    }
                    unused2 += x;
                    break;
                }
                return new DERBitString(bs, unused2);
            }
            if (val instanceof RubyString) {
                try {
                    return (ASN1Encodable)imp.getConstructor(String.class).newInstance(val.toString());
                }
                catch (Exception ex) {
                    throw RaiseException.createNativeRaiseException(this.getRuntime(), ex);
                }
            }
            System.err.println("object with tag: " + tag2 + " and value: " + val + " and val.class: " + val.getClass().getName() + " and impl: " + imp.getName());
            System.err.println("WARNING: unimplemented method called: asn1data#toASN1");
            return null;
        }

        protected void print(int indent) {
            this.printIndent(indent);
            System.out.println(this.getMetaClass().getRealClass().getBaseName() + ": " + this.callMethod(this.getRuntime().getCurrentContext(), "value").callMethod(this.getRuntime().getCurrentContext(), "inspect").toString());
        }
    }

    public static class ASN1Data
    extends RubyObject {
        private static final long serialVersionUID = 6117598347932209839L;
        public static ObjectAllocator ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime, RubyClass klass) {
                return new ASN1Data(runtime, klass);
            }
        };

        public ASN1Data(Ruby runtime, RubyClass type2) {
            super(runtime, type2);
        }

        protected void asn1Error() {
            this.asn1Error(null);
        }

        protected void asn1Error(String msg) {
            throw Utils.newError(this.getRuntime(), "OpenSSL::ASN1::ASN1Error", msg);
        }

        @JRubyMethod
        public IRubyObject initialize(IRubyObject value2, IRubyObject tag2, IRubyObject tag_class) {
            if (!(tag_class instanceof RubySymbol)) {
                this.asn1Error("invalid tag class");
            }
            if (tag_class.toString().equals(":UNIVERSAL") && RubyNumeric.fix2int(tag2) > 31) {
                this.asn1Error("tag number for Universal too large");
            }
            ThreadContext tc = this.getRuntime().getCurrentContext();
            this.callMethod(tc, "tag=", tag2);
            this.callMethod(tc, "value=", value2);
            this.callMethod(tc, "tag_class=", tag_class);
            return this;
        }

        ASN1Encodable toASN1() {
            ThreadContext tc = this.getRuntime().getCurrentContext();
            int tag2 = RubyNumeric.fix2int(this.callMethod(tc, "tag"));
            IRubyObject val = this.callMethod(tc, "value");
            if (val instanceof RubyArray) {
                RubyArray arr = (RubyArray)this.callMethod(tc, "value");
                if (arr.size() > 1) {
                    ASN1EncodableVector vec = new ASN1EncodableVector();
                    for (IRubyObject obj : arr.toJavaArray()) {
                        vec.add(((ASN1Data)obj).toASN1());
                    }
                    return new DERTaggedObject(tag2, new DERSequence(vec));
                }
                return new DERTaggedObject(tag2, ((ASN1Data)arr.getList().get(0)).toASN1());
            }
            return new DERTaggedObject(tag2, ((ASN1Data)val).toASN1());
        }

        @JRubyMethod
        public IRubyObject to_der() {
            return this.getRuntime().newString(new ByteList(this.toASN1().getDEREncoded(), false));
        }

        protected IRubyObject defaultTag() {
            int i2 = ASN1.idForRubyName(this.getMetaClass().getRealClass().getBaseName());
            if (i2 != -1) {
                return this.getRuntime().newFixnum(i2);
            }
            return this.getRuntime().getNil();
        }

        protected void print() {
            this.print(0);
        }

        protected void printIndent(int indent) {
            for (int i2 = 0; i2 < indent; ++i2) {
                System.out.print(" ");
            }
        }

        protected void print(int indent) {
            this.printIndent(indent);
            System.out.println("ASN1Data: ");
            IRubyObject val = this.callMethod(this.getRuntime().getCurrentContext(), "value");
            if (val instanceof RubyArray) {
                RubyArray arr = (RubyArray)val;
                for (IRubyObject obj : arr.toJavaArray()) {
                    ((ASN1Data)obj).print(indent + 1);
                }
            } else {
                ((ASN1Data)val).print(indent + 1);
            }
        }
    }

    public static class ObjectId {
        @JRubyMethod(meta=true, rest=true)
        public static IRubyObject register(IRubyObject recv2, IRubyObject[] args2) {
            DERObjectIdentifier deroi = new DERObjectIdentifier(args2[0].toString());
            ASN1.getOIDLookup(recv2.getRuntime()).put(args2[1].toString().toLowerCase(), deroi);
            ASN1.getOIDLookup(recv2.getRuntime()).put(args2[2].toString().toLowerCase(), deroi);
            ASN1.getSymLookup(recv2.getRuntime()).put(deroi, args2[1].toString());
            return recv2.getRuntime().getTrue();
        }

        @JRubyMethod(name={"sn", "short_name"})
        public static IRubyObject sn(IRubyObject self) {
            return self.getRuntime().newString(ASN1.getShortNameFor(self.getRuntime(), self.callMethod(self.getRuntime().getCurrentContext(), "value").toString()));
        }

        @JRubyMethod(name={"ln", "long_name"})
        public static IRubyObject ln(IRubyObject self) {
            return self.getRuntime().newString(ASN1.getLongNameFor(self.getRuntime(), self.callMethod(self.getRuntime().getCurrentContext(), "value").toString()));
        }

        @JRubyMethod
        public static IRubyObject oid(IRubyObject self) {
            return self.getRuntime().newString(ASN1.getObjectIdentifier(self.getRuntime(), self.callMethod(self.getRuntime().getCurrentContext(), "value").toString()).getId());
        }
    }
}

