/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.bouncycastle.asn1;

import java.io.IOException;
import java.math.BigInteger;
import org.jruby.org.bouncycastle.asn1.ASN1Object;
import org.jruby.org.bouncycastle.asn1.ASN1OctetString;
import org.jruby.org.bouncycastle.asn1.ASN1TaggedObject;
import org.jruby.org.bouncycastle.asn1.DERObject;
import org.jruby.org.bouncycastle.asn1.DEROutputStream;
import org.jruby.org.bouncycastle.util.Arrays;

public class DEREnumerated
extends ASN1Object {
    byte[] bytes;

    public static DEREnumerated getInstance(Object object) {
        if (object == null || object instanceof DEREnumerated) {
            return (DEREnumerated)object;
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static DEREnumerated getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        DERObject dERObject = aSN1TaggedObject.getObject();
        if (bl || dERObject instanceof DEREnumerated) {
            return DEREnumerated.getInstance(dERObject);
        }
        return new DEREnumerated(((ASN1OctetString)dERObject).getOctets());
    }

    public DEREnumerated(int n) {
        this.bytes = BigInteger.valueOf(n).toByteArray();
    }

    public DEREnumerated(BigInteger bigInteger) {
        this.bytes = bigInteger.toByteArray();
    }

    public DEREnumerated(byte[] byArray) {
        this.bytes = byArray;
    }

    public BigInteger getValue() {
        return new BigInteger(this.bytes);
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        dEROutputStream.writeEncoded(10, this.bytes);
    }

    boolean asn1Equals(DERObject dERObject) {
        if (!(dERObject instanceof DEREnumerated)) {
            return false;
        }
        DEREnumerated dEREnumerated = (DEREnumerated)dERObject;
        return Arrays.areEqual(this.bytes, dEREnumerated.bytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }
}

