/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.bouncycastle.util.encoders;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jruby.org.bouncycastle.util.encoders.Encoder;
import org.jruby.org.bouncycastle.util.encoders.UrlBase64Encoder;

public class UrlBase64 {
    private static final Encoder encoder = new UrlBase64Encoder();

    public static byte[] encode(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            encoder.encode(byArray, 0, byArray.length, byteArrayOutputStream);
        }
        catch (IOException iOException) {
            throw new RuntimeException("exception encoding URL safe base64 string: " + iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static int encode(byte[] byArray, OutputStream outputStream) throws IOException {
        return encoder.encode(byArray, 0, byArray.length, outputStream);
    }

    public static byte[] decode(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            encoder.decode(byArray, 0, byArray.length, byteArrayOutputStream);
        }
        catch (IOException iOException) {
            throw new RuntimeException("exception decoding URL safe base64 string: " + iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static int decode(byte[] byArray, OutputStream outputStream) throws IOException {
        return encoder.decode(byArray, 0, byArray.length, outputStream);
    }

    public static byte[] decode(String string2) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            encoder.decode(string2, byteArrayOutputStream);
        }
        catch (IOException iOException) {
            throw new RuntimeException("exception decoding URL safe base64 string: " + iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static int decode(String string2, OutputStream outputStream) throws IOException {
        return encoder.decode(string2, outputStream);
    }
}

