/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.spring.vfs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VFSUtils;
import org.jboss.virtual.VirtualFile;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.Resource;

public class VFSResource
extends AbstractResource {
    private VirtualFile file;

    public VFSResource(VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Null file");
        }
        this.file = file;
    }

    public VFSResource(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("Null url");
        }
        try {
            this.file = VFS.getRoot((URL)url);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot retrieve file from URL: ", e);
        }
    }

    public boolean exists() {
        try {
            return this.file.exists();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isOpen() {
        return false;
    }

    public boolean isReadable() {
        try {
            return this.file.getSize() > 0L;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public long lastModified() {
        try {
            return this.file.getLastModified();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public URL getURL() throws IOException {
        try {
            return this.file.toURL();
        }
        catch (URISyntaxException e) {
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    public URI getURI() throws IOException {
        try {
            return this.file.toURI();
        }
        catch (URISyntaxException e) {
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    public File getFile() throws IOException {
        if (VFSUtils.isNestedFile((VirtualFile)this.file)) {
            throw new IOException("This resource is a nested resource: " + this.file);
        }
        try {
            return new File(VFSUtils.getCompatibleURI((VirtualFile)this.file));
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    public Resource createRelative(String relativePath) throws IOException {
        if (relativePath.startsWith(".") || relativePath.indexOf("/") == -1) {
            return new VFSResource(VFS.getRoot((URL)new URL(this.getURL(), relativePath)));
        }
        try {
            return new VFSResource(this.file.findChild(relativePath));
        }
        catch (IOException e) {
            return new VFSResource(VFS.getRoot((URL)new URL(this.getURL(), relativePath)));
        }
    }

    public String getFilename() {
        return this.file.getName();
    }

    public String getDescription() {
        return this.file.toString();
    }

    public InputStream getInputStream() throws IOException {
        return this.file.openStream();
    }

    public String toString() {
        return this.getDescription();
    }

    public boolean equals(Object other) {
        if (other instanceof VFSResource) {
            return this.file.equals((Object)((VFSResource)((Object)other)).file);
        }
        return false;
    }

    public int hashCode() {
        return this.file.hashCode();
    }
}

