/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.util.stax;

import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.internal.soa.esb.util.stax.ElementContent;

public class URIElement
extends ElementContent {
    private URI value;

    public URIElement() {
    }

    public URIElement(URI value) {
        this.setValue(value);
    }

    public URIElement(XMLStreamReader in) throws XMLStreamException {
        this.parse(in);
    }

    protected void putValue(XMLStreamReader in, String value) throws XMLStreamException {
        URI uriValue;
        try {
            uriValue = new URI(value);
        }
        catch (URISyntaxException urise) {
            throw new XMLStreamException("Failed to parse URI: " + value, urise);
        }
        this.setValue(uriValue);
    }

    public void setValue(URI value) {
        this.value = value;
    }

    public URI getValue() {
        return this.value;
    }

    protected void writeChildContent(XMLStreamWriter out) throws XMLStreamException {
        if (this.value != null) {
            out.writeCharacters(this.value.toString());
        }
    }

    protected void putElement(XMLStreamReader in, QName elementName) throws XMLStreamException {
    }

    public boolean isValid() {
        return this.value != null && super.isValid();
    }
}

