/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.actions;

import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.jboss.soa.esb.actions.ActionLifecycle;
import org.jboss.soa.esb.actions.ActionLifecycleException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.MessagePayloadProxy;
import org.jboss.soa.esb.notification.NotificationList;

public class Notifier
implements ActionLifecycle {
    private MessagePayloadProxy payloadProxy;
    protected ConfigTree _config;
    protected ConfigTree[] _notifyOK;
    protected ConfigTree[] _notifyError;
    protected static Logger _logger = Logger.getLogger(Notifier.class);

    public Notifier(ConfigTree config) {
        this._config = config;
        this.payloadProxy = new MessagePayloadProxy(config, new String[]{"org.jboss.soa.esb.message.content.bytes"}, new String[]{"org.jboss.soa.esb.message.content.bytes"});
    }

    public void initialise() throws ActionLifecycleException {
        if (null == this._config) {
            this._notifyError = new ConfigTree[0];
            this._notifyOK = this._notifyError;
        } else {
            this._notifyOK = this.getNotificationList("ok");
            this._notifyError = this.getNotificationList("err");
        }
    }

    public void destroy() throws ActionLifecycleException {
    }

    public Message process(Message message) {
        return message;
    }

    public void notifyOK(Message message) {
        NotificationList.notifyAll(this._notifyOK, message);
    }

    public void notifyError(Message message, Throwable th) {
        NotificationList.notifyAll(this._notifyError, message);
    }

    @Deprecated
    public String messageAsString(Message message) throws MessageDeliverException {
        byte[] ba = null;
        return null == message ? "<null message>" : (null == (ba = (byte[])this.payloadProxy.getPayload(message)) ? "<null body content>" : new String(ba));
    }

    private ConfigTree[] getNotificationList(String type) {
        ArrayList<ConfigTree> list = new ArrayList<ConfigTree>();
        if (null != type) {
            type = type.toLowerCase();
        }
        for (ConfigTree tree : this._config.getChildren("NotificationList")) {
            String sType = tree.getAttribute("type");
            if (null == sType || null != type && !sType.toLowerCase().equals(type)) continue;
            list.add(tree);
        }
        ConfigTree[] array = new ConfigTree[list.size()];
        return list.toArray(array);
    }
}

