/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.services.security.auth.ws;

import java.io.ByteArrayInputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import org.apache.commons.codec.binary.Base64;

public class BinarySecurityToken {
    private String encodingType;
    private String valueType;
    private Certificate cert;

    public String getEncodingType() {
        return this.encodingType;
    }

    public void setEncodingType(String encodingType) {
        this.encodingType = this.stripNS(encodingType);
    }

    public String getValueType() {
        return this.valueType;
    }

    public void setValueType(String valueType) {
        this.valueType = this.stripNS(valueType);
    }

    public Certificate getKey() {
        return this.cert;
    }

    public void setKey(String key) {
        try {
            byte[] keyBytes = null;
            if (this.encodingType.equalsIgnoreCase(EncodingType.Base64Binary.toString())) {
                Base64 decoder = new Base64();
                keyBytes = decoder.decode(key.getBytes());
            } else {
                keyBytes = key.getBytes();
            }
            CertificateFactory factory = CertificateFactory.getInstance(this.certificateMatch(this.valueType));
            this.cert = factory.generateCertificate(new ByteArrayInputStream(keyBytes));
        }
        catch (CertificateException e) {
            throw new IllegalStateException("Could not create certificate: ", e);
        }
    }

    private String certificateMatch(String valueType) {
        if (valueType.startsWith("X509")) {
            return "X.509";
        }
        return valueType;
    }

    private String stripNS(String value) {
        if (value != null) {
            if (value.startsWith("http")) {
                int idx = value.indexOf(35);
                if (idx > 0) {
                    value = value.substring(idx + 1);
                }
            } else {
                int idx = value.indexOf(58);
                if (idx > 0) {
                    value = value.substring(idx + 1);
                }
            }
        }
        return value;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum EncodingType {
        Base64Binary,
        HexBinary;

    }
}

