/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.assertion.AssertArgument;

public class FileUtil {
    public static final String classInstanceUUID = UUID.randomUUID().toString();
    private static final Logger LOGGER = Logger.getLogger(FileUtil.class);

    public static boolean renameTo(File from, File to) {
        AssertArgument.isNotNull(from, "from");
        AssertArgument.isNotNull(to, "to");
        if (!from.exists()) {
            LOGGER.debug((Object)("Unable to rename file '" + from.getAbsolutePath() + "' to '" + to.getAbsolutePath() + "'.  '" + from.getAbsolutePath() + "' doesn't exist."));
            return false;
        }
        if (to.exists()) {
            LOGGER.debug((Object)("Unable to rename file '" + from.getAbsolutePath() + "' to '" + to.getAbsolutePath() + "'.  '" + to.getAbsolutePath() + "' already exist."));
            return false;
        }
        if (!from.renameTo(to)) {
            return FileUtil.moveFile(from, to);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean moveFile(File from, File to) {
        File tmpFile;
        AssertArgument.isNotNull(from, "from");
        AssertArgument.isNotNull(to, "to");
        if (!from.exists()) {
            LOGGER.debug((Object)("Unable to move file '" + from.getAbsolutePath() + "' to '" + to.getAbsolutePath() + "'.  '" + from.getAbsolutePath() + "' doesn't exist."));
            return false;
        }
        if (to.exists()) {
            LOGGER.debug((Object)("Unable to move file '" + from.getAbsolutePath() + "' to '" + to.getAbsolutePath() + "'.  '" + to.getAbsolutePath() + "' already exist."));
            return false;
        }
        File fromFileDir = from.getParentFile();
        File fromLocalRename = new File(fromFileDir, classInstanceUUID + "." + from.getName() + "." + classInstanceUUID);
        if (!from.renameTo(fromLocalRename)) {
            LOGGER.debug((Object)("Unable to perform local rename of file '" + from.getAbsolutePath() + "' to '" + fromLocalRename.getAbsolutePath() + "'.  Unable to move file."));
            return true;
        }
        if (!fromLocalRename.exists()) {
            LOGGER.debug((Object)("Failed to perform local rename of file '" + from.getAbsolutePath() + "' to '" + fromLocalRename.getAbsolutePath() + "'.  Unable to move file."));
            return true;
        }
        try {
            tmpFile = File.createTempFile("copy", ".tmp", to.getParentFile());
        }
        catch (IOException ioe) {
            LOGGER.debug((Object)"Could not create temporary file for writing", (Throwable)ioe);
            return true;
        }
        try {
            FileUtil.copyFile(fromLocalRename, tmpFile);
            if (!tmpFile.renameTo(to)) {
                LOGGER.debug((Object)("Could not rename temporary file " + tmpFile.getAbsolutePath()));
                boolean bl = false;
                return bl;
            }
            if (!fromLocalRename.delete()) {
                LOGGER.debug((Object)("Failed to delete local rename file '" + fromLocalRename.getAbsolutePath() + "'."));
            }
        }
        finally {
            tmpFile.delete();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static boolean copyFile(File from, File to) {
        block28: {
            FileInputStream fis;
            try {
                fis = new FileInputStream(from);
            }
            catch (IOException ioe) {
                LOGGER.debug((Object)"Could not open input file for reading", (Throwable)ioe);
                return false;
            }
            try {
                int count;
                byte[] buffer;
                FileOutputStream fos;
                try {
                    fos = new FileOutputStream(to);
                }
                catch (IOException ioe) {
                    LOGGER.debug((Object)"Could not open output file for writing", (Throwable)ioe);
                    boolean bl = false;
                    try {
                        fis.close();
                    }
                    catch (IOException ioe2) {
                        // empty catch block
                    }
                    return bl;
                }
                long filesize = from.length();
                byte[] byArray = buffer = filesize > 256L ? new byte[256] : new byte[(int)filesize];
                while ((count = fis.read(buffer)) > 0) {
                    fos.write(buffer, 0, count);
                }
                try {
                    fos.close();
                }
                catch (IOException ioe) {}
                break block28;
                catch (IOException ioe) {
                    boolean bl;
                    try {
                        LOGGER.debug((Object)"Error copying file", (Throwable)ioe);
                        to.delete();
                        bl = false;
                    }
                    catch (Throwable throwable) {
                        try {
                            fos.close();
                        }
                        catch (IOException ioe3) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {
                        fos.close();
                    }
                    catch (IOException ioe4) {
                        // empty catch block
                    }
                    try {
                        fis.close();
                    }
                    catch (IOException ioe5) {
                        // empty catch block
                    }
                    return bl;
                }
            }
            finally {
                try {
                    fis.close();
                }
                catch (IOException ioe) {}
            }
        }
        return true;
    }

    public static String readTextFile(File file) throws IOException {
        StringBuffer sb = new StringBuffer(1024);
        BufferedReader reader = new BufferedReader(new FileReader(file.getPath()));
        char[] chars = new char[1];
        while (reader.read(chars) > -1) {
            sb.append(String.valueOf(chars));
            chars = new char[1];
        }
        reader.close();
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFile(File file) throws IOException {
        ByteArrayOutputStream fileBuffer = new ByteArrayOutputStream();
        FileInputStream fileInStream = new FileInputStream(file);
        try {
            byte[] readBuffer = new byte[256];
            int readCount = 0;
            while ((readCount = ((InputStream)fileInStream).read(readBuffer)) != -1) {
                fileBuffer.write(readBuffer, 0, readCount);
            }
        }
        finally {
            ((InputStream)fileInStream).close();
        }
        return fileBuffer.toByteArray();
    }
}

