/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.wife.swift.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.wife.WifeException;
import net.sourceforge.wife.swift.model.SwiftBlock;
import net.sourceforge.wife.swift.model.SwiftBlock1;
import net.sourceforge.wife.swift.model.SwiftBlock2Input;
import net.sourceforge.wife.swift.model.SwiftBlock2Output;
import net.sourceforge.wife.swift.model.SwiftBlock3;
import net.sourceforge.wife.swift.model.SwiftBlock4;
import net.sourceforge.wife.swift.model.SwiftBlock5;
import net.sourceforge.wife.swift.model.SwiftBlockUser;
import net.sourceforge.wife.swift.model.SwiftMessage;
import net.sourceforge.wife.swift.model.SwiftTagListBlock;
import net.sourceforge.wife.swift.model.Tag;
import net.sourceforge.wife.swift.model.UnparsedTextList;

public class SwiftParser {
    public static final String EOL = System.getProperty("line.separator", "\n");
    private static final transient Logger log = Logger.getLogger(SwiftParser.class.getName());
    private Reader reader;
    private StringBuffer buffer;
    private SwiftMessage currentMessage;
    private final List errors = new ArrayList();

    public SwiftParser(InputStream is) {
        this(new InputStreamReader(is));
    }

    public SwiftParser(Reader r) {
        this.setReader(r);
    }

    public SwiftParser(String message) {
        this(new StringReader(message));
    }

    public SwiftParser() {
    }

    public void setReader(Reader r) {
        this.buffer = new StringBuffer();
        this.reader = r;
    }

    public void setData(String data) {
        this.setReader(new StringReader(data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SwiftMessage message() throws IOException {
        SwiftMessage message;
        this.currentMessage = message = new SwiftMessage(false);
        this.errors.clear();
        try {
            boolean done = false;
            SwiftBlock b = null;
            do {
                if ((b = this.consumeBlock()) != null) {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("consumed block: " + b);
                    }
                    this.currentMessage.addBlock(b);
                    continue;
                }
                if (log.isLoggable(Level.FINE)) {
                    log.fine("no block consumed");
                }
                done = true;
            } while (!done);
        }
        finally {
            this.currentMessage = null;
        }
        return message;
    }

    protected SwiftBlock consumeBlock() throws IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("consumeBlock: findBlockStart()");
        }
        this.findBlockStart();
        if (log.isLoggable(Level.FINE)) {
            log.fine("block start found");
        }
        String s = this.readUntilBlockEnds();
        if (log.isLoggable(Level.FINE)) {
            log.fine("block buffer: [" + s + "]");
        }
        if (s.equals("")) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("end of input");
            }
            return null;
        }
        if (s.startsWith("1:")) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Possible unparsed text");
            }
            if (this.currentMessage != null && this.currentMessage.getBlock1() != null) {
                UnparsedTextList list;
                if (log.isLoggable(Level.FINE)) {
                    log.fine("It is an unparsed text");
                }
                StringBuffer utBuffer = new StringBuffer();
                utBuffer.append("{");
                utBuffer.append(s);
                utBuffer.append("}");
                boolean done = false;
                while (!done) {
                    char[] data = new char[128];
                    int size = this.reader.read(data);
                    if (size > 0) {
                        utBuffer.append(data);
                        continue;
                    }
                    done = true;
                }
                String unparsedText = utBuffer.toString();
                if (log.isLoggable(Level.FINE)) {
                    log.fine("unparsed texts to process: [" + unparsedText + "]");
                }
                if ((list = this.processUnparsedText(unparsedText)) != null) {
                    this.currentMessage.setUnparsedTexts(list);
                }
                return null;
            }
            if (log.isLoggable(Level.FINE)) {
                log.severe("Regular block");
            }
        }
        char blockId = this.identifyBlock(s);
        if (log.isLoggable(Level.FINE)) {
            log.fine("blockId: " + blockId);
        }
        SwiftBlock b = null;
        if (blockId == ' ') {
            if (log.isLoggable(Level.SEVERE)) {
                log.severe("A block could not be identified!");
            }
            if (log.isLoggable(Level.SEVERE)) {
                log.severe("unidentified block:" + s);
            }
            throw new WifeException("The block " + s + " could not be identified");
        }
        switch (blockId) {
            case '1': {
                b = new SwiftBlock1(s);
                break;
            }
            case '2': {
                if (this.isInput(s)) {
                    b = new SwiftBlock2Input(s);
                    break;
                }
                b = new SwiftBlock2Output(s);
                break;
            }
            case '3': {
                b = this.tagListBlockConsume(new SwiftBlock3(), s);
                break;
            }
            case '4': {
                b = this.block4Consume(new SwiftBlock4(), s);
                break;
            }
            case '5': {
                b = this.tagListBlockConsume(new SwiftBlock5(), s);
                break;
            }
            default: {
                b = this.tagListBlockConsume(new SwiftBlockUser(Character.toString(blockId)), s);
            }
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Block consumed: " + b);
        }
        return b;
    }

    private boolean isInput(String s) {
        int i;
        if (log.isLoggable(Level.FINE)) {
            log.fine("block 2 type detection: " + s);
        }
        if ((i = s.indexOf(58)) >= 0 && i + 1 < s.length()) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("checking if [" + Character.toUpperCase(s.charAt(i + 1)) + "] is input");
            }
            return Character.toUpperCase(s.charAt(i + 1)) == 'I';
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("assuming output block 2");
        }
        return false;
    }

    protected SwiftTagListBlock tagListBlockConsume(SwiftTagListBlock b, String s) throws IOException {
        int start;
        if (log.isLoggable(Level.FINE)) {
            log.fine("data to consume: " + s);
        }
        if ((start = s.indexOf(58)) >= 0 && start + 1 < s.length()) {
            String data = s.substring(start + 1);
            if (log.isLoggable(Level.FINE)) {
                log.fine("data: " + data);
            }
            for (int i = 0; i < data.length(); ++i) {
                int end;
                char c = data.charAt(i);
                if (c == '{') {
                    end = data.indexOf(125, i);
                    if (end < 0 || data.length() <= end) continue;
                    String inner = data.substring(i + 1, end);
                    i = end;
                    Tag t = new Tag(inner);
                    log.fine("" + t);
                    b.addTag(t);
                    continue;
                }
                for (end = i; end < data.length() && data.charAt(end) != '{'; ++end) {
                }
                String unparsedText = data.substring(i, end).trim();
                if (log.isLoggable(Level.FINE)) {
                    log.fine("possible block unparsed text: \"" + unparsedText + "\"");
                }
                if (!"".equals(unparsedText)) {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("adding block unparsed text: \"" + unparsedText + "\"");
                    }
                    b.unparsedTextAddText(unparsedText);
                } else if (log.isLoggable(Level.FINE)) {
                    log.fine("ingoring empty trimed unparsed text");
                }
                i = end - 1;
            }
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("processed block: " + b);
        }
        return b;
    }

    protected SwiftBlock4 block4Consume(SwiftBlock4 b, String s) throws IOException {
        int start;
        s = this.block4EndOfBlockFix(s);
        if (log.isLoggable(Level.FINE)) {
            log.fine("block4Consume [" + s + "]");
        }
        if (s.charAt(start = 0) == '4') {
            ++start;
        }
        if (s.charAt(start) == ':') {
            ++start;
        }
        while (start < s.length()) {
            char c;
            if (log.isLoggable(Level.FINE)) {
                log.fine("parsing at: begin [" + start + "] buffer [" + s.substring(start) + "]");
            }
            int begin = start;
            do {
                c = s.charAt(start++);
            } while (start < s.length() && c != ':' && c != '{' && c != '}');
            if (log.isLoggable(Level.FINE)) {
                log.fine("position: begin [" + begin + "] current [" + start + "]");
            }
            int ignore = 0;
            if (c == '}' && s.charAt(start - 1) == '-') {
                ignore = 1;
            }
            String unparsedText = s.substring(begin, start - ignore - 1).trim();
            if (log.isLoggable(Level.FINE)) {
                log.fine("possible block unparsed text: \"" + unparsedText + "\"");
            }
            if (!"".equals(unparsedText)) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("adding block unparsed text: \"" + unparsedText + "\"");
                }
                b.unparsedTextAddText(unparsedText);
            } else if (log.isLoggable(Level.FINE)) {
                log.fine("ingoring empty trimed unparsed text");
            }
            if (start == s.length()) {
                if (!log.isLoggable(Level.FINE)) continue;
                log.fine("reached end of input, terminating");
                continue;
            }
            int end = 0;
            String tag = null;
            String tagUnparsedText = null;
            switch (c) {
                case '}': {
                    if (start != s.length() && log.isLoggable(Level.FINE)) {
                        log.fine("reached end of block with pending input [" + s.substring(start) + "]");
                    }
                    start = s.length();
                    break;
                }
                case ':': {
                    end = this.textTagEnd(s, start);
                    tag = s.substring(start, end);
                    break;
                }
                case '{': {
                    if (s.startsWith("1:", start)) {
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("processing block unparsed text at [" + (start - 1) + "]");
                        }
                        begin = start > 0 ? start - 1 : 0;
                        end = begin + 1;
                        while (end < s.length() && !s.startsWith("{1:", end)) {
                            end = this.blockTagEnd(s, end + 1);
                        }
                        unparsedText = s.substring(begin, end);
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("block unparsed text from [" + begin + "] to [" + end + "] is [" + unparsedText + "]");
                        }
                        b.unparsedTextAddText(unparsedText);
                        break;
                    }
                    end = this.blockTagEnd(s, start);
                    tag = s.substring(start, end - 1);
                    int utPos = tag.indexOf("{1:");
                    if (utPos == -1) break;
                    tagUnparsedText = tag.substring(utPos);
                    tag = tag.substring(0, utPos);
                }
            }
            if (tag != null) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("position: begin [" + begin + "] current [" + start + "] end [" + end + "]");
                }
                if (log.isLoggable(Level.FINE)) {
                    log.fine("processing tag [" + tag + "]");
                }
                Tag t = this.consumeTag(tag, tagUnparsedText);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("consumed tag [" + t + "]");
                }
                if (t != null) {
                    b.addTag(t);
                }
            }
            start = end;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("processed block: " + b);
        }
        return b;
    }

    private String block4EndOfBlockFix(String data) {
        if (data == null || data.length() == 0) {
            return data;
        }
        int end = data.length();
        if (data.charAt(--end) == '-') {
            if (end > 0 && data.charAt(--end) == '\n' && end > 0 && data.charAt(--end) != '\r') {
                ++end;
            }
            data = end > 0 ? data.substring(0, end) : "";
        }
        return data;
    }

    private int textTagEnd(String s, int start) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("textTagEnd: scan for text tag end starting at [" + start + "]");
        }
        while (start < s.length()) {
            char c = s.charAt(start);
            if (log.isLoggable(Level.FINE)) {
                log.fine("textTagEnd: cheking char [" + c + "]");
            }
            if (c == '\r' || c == '\n') {
                char z;
                int begin = start;
                if (start + 1 == s.length()) break;
                c = s.charAt(++start);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("textTagEnd: CR|LF cheking char [" + c + "]");
                }
                if (c == '\r' || c == '\n') {
                    if (start == s.length()) break;
                    c = s.charAt(++start);
                }
                if (log.isLoggable(Level.FINE)) {
                    log.fine("textTagEnd: final CR|LF char to check [" + c + "]");
                }
                if (c == '{' || c == '}') {
                    start = begin;
                    break;
                }
                if (c == ':' && start != s.length() && (z = s.charAt(++start)) != '\r' && z != '\n') {
                    start = begin;
                    break;
                }
                start = begin;
            } else {
                if (c == '-') {
                    char c2 = c = start + 1 < s.length() ? (char)s.charAt(start + 1) : (char)' ';
                    if (c == '}') break;
                }
                if (c == '}') break;
            }
            ++start;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("textTagEnd: found tag end at [" + start + "]");
        }
        return start;
    }

    private int blockTagEnd(String s, int start) {
        char c;
        if (log.isLoggable(Level.FINE)) {
            log.fine("blockTagEnd: scan for text tag end starting at [" + start + "]");
        }
        int balance = 0;
        do {
            c = s.charAt(start++);
            switch (c) {
                case '{': {
                    ++balance;
                    break;
                }
                case '}': {
                    --balance;
                }
            }
        } while (start < s.length() && (balance >= 0 || balance == 0 && c != '}'));
        if (log.isLoggable(Level.FINE)) {
            log.fine("blockTagEnd: found tag end at [" + start + "]");
        }
        return start;
    }

    protected Tag consumeTag(String buffer, String unparsedText) throws IOException {
        char c;
        if (log.isLoggable(Level.FINE)) {
            log.fine("consumeTag: buffer [" + buffer + "]");
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("consumeTag: unparsedText [" + unparsedText + "]");
        }
        int sep = buffer.indexOf(58);
        String name = null;
        String value = null;
        if (sep != -1) {
            name = buffer.substring(0, sep);
            value = buffer.substring(sep + 1);
        } else {
            value = buffer;
        }
        if ((name == null || name.equals("")) && (value == null || value.equals(""))) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("consumeTag: ignoring empty tag");
            }
            return null;
        }
        int size = value.length();
        if (size > 0 && ((c = value.charAt(size - 1)) == '\r' || c == '\n')) {
            --size;
        }
        if (size > 0 && ((c = value.charAt(size - 1)) == '\r' || c == '\n')) {
            --size;
        }
        if (size != value.length()) {
            value = value.substring(0, size);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("consumeTag: name [" + name + "] value [" + value + "]");
        }
        Tag t = new Tag();
        t.setName(name);
        t.setValue(value);
        if (unparsedText != null) {
            t.setUnparsedTexts(this.processUnparsedText(unparsedText));
        }
        return t;
    }

    private UnparsedTextList processUnparsedText(String unparsedText) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("processUnparsedText: len [" + unparsedText.length() + "] input [" + unparsedText + "]");
        }
        UnparsedTextList list = null;
        int start = 0;
        while (start < unparsedText.length()) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("processUnparsedText: starting scan at [" + start + "] len [" + unparsedText.length() + "]");
            }
            int end = start + 1;
            while (end + 1 < unparsedText.length() && !unparsedText.startsWith("{1:", end)) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("processUnparsedText: entering end [" + end + "]");
                }
                for (end = this.blockTagEnd(unparsedText, end + 1); end < unparsedText.length() && Character.isWhitespace(unparsedText.charAt(end)); ++end) {
                    if (!log.isLoggable(Level.FINE)) continue;
                    log.fine("processUnparsedText: skip white space char at [" + unparsedText.charAt(end) + "] pos [" + end + "]");
                }
            }
            String text = unparsedText.substring(start, end).trim();
            if (log.isLoggable(Level.FINE)) {
                log.fine("processUnparsedText: unparsed text is [" + text + "]");
            }
            if (!text.equals("")) {
                if (list == null) {
                    list = new UnparsedTextList();
                }
                list.addText(text);
            }
            start = end;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("processUnparsedText: returning [" + list + "]");
        }
        return list;
    }

    protected char identifyBlock(String s) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("identifyBlock('" + s + "')");
        }
        if (s != null && s.length() > 1) {
            char c = s.charAt(0);
            if ('0' <= c && c <= '9') {
                return c;
            }
            if ('a' <= c && c <= 'z') {
                return c;
            }
            if ('A' <= c && c <= 'Z') {
                return c;
            }
        }
        return ' ';
    }

    protected String readUntilBlockEnds() throws IOException {
        int start = this.buffer.length();
        int len = 0;
        int starts = 1;
        boolean done = false;
        while (!done) {
            int c = this.getChar();
            if (log.isLoggable(Level.FINE)) {
                log.fine("char " + (char)c + " (" + c + ")");
            }
            if (c == -1) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Found EOF");
                }
                done = true;
                continue;
            }
            if (this.isBlockStart((char)c)) {
                ++starts;
            }
            if (this.isBlockEnd((char)c)) {
                if (--starts == 0) {
                    done = true;
                    continue;
                }
                ++len;
                continue;
            }
            ++len;
            if (log.isLoggable(Level.FINE)) {
                log.fine("len: " + len);
            }
            if (!log.isLoggable(Level.FINE)) continue;
            log.fine("block spans: " + this.buffer.substring(start));
        }
        int end = start + len;
        if (starts != 0 && end - start > 0 && log.isLoggable(Level.FINE)) {
            log.fine("unbalanced '{' and '}' inside block (starts=" + starts + ")");
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("start: " + start);
            log.fine("end: " + end);
            log.fine("substring from start: " + this.buffer.substring(start));
            log.fine("len: " + len);
        }
        return this.buffer.substring(start, end);
    }

    private boolean isBlockEnd(char c) {
        return c == '}';
    }

    protected void findBlockStart() throws IOException {
        int c;
        while ((c = this.getChar()) != -1 && !this.isBlockStart((char)c)) {
        }
    }

    private boolean isBlockStart(char c) {
        return c == '{';
    }

    private int getChar() throws IOException {
        int c = this.reader.read();
        if (c >= 0) {
            this.buffer.append((char)c);
        }
        return c;
    }

    public List getErrors() {
        return new ArrayList(this.errors);
    }
}

