/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.wife.validation.util;

import java.math.BigInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.wife.validation.util.ISOCountries;

public class IBAN {
    private static final BigInteger BD_97 = new BigInteger("97");
    private static final BigInteger BD_98 = new BigInteger("98");
    private String invalidCause = null;
    private String iban;
    private static final transient Logger log = Logger.getLogger(IBAN.class.getName());

    public String getIban() {
        return this.iban;
    }

    public void setIban(String iban) {
        this.iban = iban;
    }

    public IBAN(String iban) {
        this.iban = iban;
    }

    public boolean isValid() {
        String workString;
        int mod;
        if (this.iban == null) {
            throw new IllegalStateException("iban is null");
        }
        this.invalidCause = null;
        String code = this.removeNonAlpha(this.iban);
        int len = code.length();
        if (len < 4) {
            this.invalidCause = "Too short (expected at least 4, got " + len + ")";
            return false;
        }
        String country = code.substring(0, 2);
        if (!ISOCountries.getInstance().isValidCode(country)) {
            this.invalidCause = "Invalid ISO country code: " + country;
            return false;
        }
        StringBuffer bban = new StringBuffer(code.substring(4));
        if (bban.length() == 0) {
            this.invalidCause = "Empty Basic Bank Account Number";
            return false;
        }
        bban.append(code.substring(0, 4));
        if (log.isLoggable(Level.FINE)) {
            log.fine("bban: " + bban);
        }
        if ((mod = this.modulo97(workString = this.translateChars(bban))) != 1) {
            this.invalidCause = "Verification failed (expected 1 and obtained " + mod + ")";
            return false;
        }
        return true;
    }

    public String translateChars(StringBuffer bban) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < bban.length(); ++i) {
            char c = bban.charAt(i);
            if (Character.isLetter(c)) {
                result.append(Character.getNumericValue(c));
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    public String removeNonAlpha(String iban) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < iban.length(); ++i) {
            char c = iban.charAt(i);
            if (!Character.isLetter(c) && !Character.isDigit(c)) continue;
            result.append(c);
        }
        return result.toString();
    }

    private int modulo97(String bban) {
        BigInteger b = new BigInteger(bban);
        b = b.divideAndRemainder(BD_97)[1];
        b = BD_98.min(b);
        b = b.divideAndRemainder(BD_97)[1];
        return b.intValue();
    }

    public String getInvalidCause() {
        return this.invalidCause;
    }
}

