/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import org.apache.ftpserver.ftplet.User;
import org.apache.ftpserver.gui.PluginPanel;
import org.apache.ftpserver.gui.PluginPanelContainer;
import org.apache.ftpserver.gui.SpyPanel;
import org.apache.ftpserver.interfaces.FtpServerContext;
import org.apache.ftpserver.listener.Connection;

public class SpyPanelContainer
extends PluginPanel {
    private static final long serialVersionUID = 7426681776615720958L;
    private JTabbedPane tabbedPane;
    private JLabel defaultComp;
    private FtpServerContext serverContext;

    public SpyPanelContainer(PluginPanelContainer container) {
        super(container);
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setPreferredSize(new Dimension(470, 340));
        this.add((Component)this.tabbedPane, "Center");
        this.defaultComp = new JLabel("Please, select a connection.", 0);
        this.defaultComp.setFont(new Font(null, 1, 17));
        this.defaultComp.setForeground(Color.blue);
        this.defaultComp.setBackground(Color.white);
        this.defaultComp.setBorder(BorderFactory.createEtchedBorder());
        this.defaultComp.setOpaque(true);
        this.tabbedPane.addTab("Spy", this.defaultComp);
    }

    public void monitorConnection(Connection con) {
        String userName = this.getCaption(con);
        int tabCount = this.tabbedPane.getTabCount();
        for (int i = 0; i < tabCount; ++i) {
            Connection tabcon;
            Component selComp = this.tabbedPane.getComponentAt(i);
            if (selComp == null || selComp == this.defaultComp || (tabcon = ((SpyPanel)selComp).getConnection()) != con) continue;
            this.tabbedPane.setTitleAt(i, userName);
            this.tabbedPane.setSelectedIndex(i);
            return;
        }
        SpyPanel spyPane = new SpyPanel(this.serverContext, con, this.tabbedPane, this.defaultComp);
        this.tabbedPane.remove(this.defaultComp);
        this.tabbedPane.add(userName, spyPane);
        this.tabbedPane.setSelectedComponent(spyPane);
    }

    private String getCaption(Connection con) {
        String tmp;
        User user = con.getSession().getUser();
        String name = "UNKNOWN";
        if (user != null && (tmp = user.getName()) != null) {
            name = tmp;
        }
        return name;
    }

    public void refresh(FtpServerContext serverContext) {
        int tabCount;
        this.serverContext = serverContext;
        int i = tabCount = this.tabbedPane.getTabCount();
        while (--i >= 0) {
            Component tabComp = this.tabbedPane.getComponentAt(i);
            if (tabComp == null || tabComp == this.defaultComp) continue;
            ((SpyPanel)tabComp).closePane();
        }
    }

    public boolean canBeDisplayed() {
        return this.serverContext != null;
    }

    public String toString() {
        return "Spy";
    }
}

