/*
 * JBoss, Home of Professional Open Source
 * Copyright 2010, Red Hat Middleware LLC, and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
package org.jboss.internal.soa.esb.rosetta.pooling.handlers;

import javax.jms.JMSException;

import org.jboss.internal.soa.esb.rosetta.pooling.JmsConnectionExceptionHandler;

/**
 * JBoss Messaging connection exception handler.
 *
 * @author <a href="mailto:Kevin.Conner@jboss.com">Kevin Conner</a>
 */
public class WMQConnectionExceptionHandler implements JmsConnectionExceptionHandler
{
    /**
     * WMQ error code.
     */
    public static final String WMQ_ERROR_CODE_CONNECTION_FAILURE = "MQJMS2008";
    /**
     * WMQ connection failure message.
     */
    public static final String WMQ_LINKED_EXCEPTION_CONNECTION_FAILURE = "MQJE001: Completion Code 2, Reason 2009";

    /**
     * Check the exception to see whether it indicates a connection failure
     * @param jmse The current JMS Exception
     * @return null if no connection failure, TRUE if the connection should be closed, FALSE if just cleaned up.
     */
    public Boolean isConnectionFailure(final JMSException jmse)
    {
        /*
         * Websphere MQ can drop the connection from the server side
         * without calling back on the exception listener.  We check for
         * the exception errorcode MQJMS2008 used by Websphere MQ when the connection has disappeared.
         * 
         * We return FALSE as we should not try to close the connection.
         */
        boolean iswmqMessagingConnectionFailure = false;
        
        if (WMQ_ERROR_CODE_CONNECTION_FAILURE.equals(jmse.getErrorCode())) {
            Exception linkedException = jmse.getLinkedException();
            if ((linkedException != null)
                    && (WMQ_LINKED_EXCEPTION_CONNECTION_FAILURE.equals(linkedException.getMessage()))) {
                iswmqMessagingConnectionFailure = true;
            }
        }
        return (iswmqMessagingConnectionFailure ? Boolean.FALSE : null) ;
    }
}
