/*
 * JBoss, Home of Professional Open Source Copyright 2008, Red Hat Middleware
 * LLC, and individual contributors by the @authors tag. See the copyright.txt
 * in the distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.internal.soa.esb.services.security;

import java.util.Set;

import org.jboss.soa.esb.services.security.SecurityConfig;
import org.jboss.soa.esb.services.security.SecurityContext;

/**
 * A SecurityContextPropagator can push/propagate and pop/remove security context
 * information to a specified targets security subsytem.
 * </p>
 * For example, a SecurityContextPropagator for JBossAS would propagate a security
 * context so that it is made available to JBossAS Security subsystem.
 *
 * @author <a href="mailto:dbevenius@jboss.com">Daniel Bevenius</a>
 */
public interface SecurityContextPropagator
{
    /**
     * Push/Propagate the Security context information to the destined system.
     *
     * @param context The security context to be pushed(propagated)
     * @param credentials The set of credentials that were provided for authentication.
     * @param config The SecurityConfig which give access to the service's security configuration.
     */
    void pushSecurityContext(final SecurityContext context, final Set<?> credentials, final SecurityConfig config);

    /**
     * Pop/Remove the Security context information to the destined system.
     *
     * @param context The security context to be pushed(propagated)
     * @param config The SecurityConfig which give access to the service's security configuration.
     */
    void popSecurityContext(final SecurityContext context, final SecurityConfig config);

}
