/*
 * JBoss, Home of Professional Open Source
 * Copyright 2011, Red Hat Middleware LLC, and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
package org.jboss.internal.soa.esb.util.stax.events;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import javax.xml.stream.events.Namespace;

/**
 * Cached event information for Namespace.
 */
public class ESBStaxNamespace extends ESBStaxAttribute implements Namespace
{
    private final String namespaceURI ;
    private final String prefix ;
    private final boolean defaultNamespaceDeclaration ;

    public ESBStaxNamespace(final Namespace namespace)
    {
        super(namespace) ;
        namespaceURI = namespace.getNamespaceURI() ;
        prefix = namespace.getPrefix() ;
        defaultNamespaceDeclaration = namespace.isDefaultNamespaceDeclaration() ;
    }

    public String getNamespaceURI()
    {
        return namespaceURI ;
    }

    public String getPrefix()
    {
        return prefix ;
    }

    public boolean isDefaultNamespaceDeclaration()
    {
        return defaultNamespaceDeclaration ;
    }

    @Override
    public boolean isNamespace()
    {
        return true ;
    }

    static List<Namespace> getNamespaces(final Iterator<Namespace> namespaces)
    {
        if (namespaces == null)
        {
            return null ;
        }
        else if (namespaces.hasNext())
        {
            final List<Namespace> result = new ArrayList<Namespace>() ;
            do
            {
                result.add(new ESBStaxNamespace(namespaces.next())) ;
            }
            while(namespaces.hasNext()) ;
            return result ;
        }
        else
        {
            return Collections.emptyList() ;
        }
    }
}
