package org.jboss.soa.esb.message.body.content;

/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

import java.io.Serializable;
import java.util.Date;

import javax.management.MBeanOperationInfo;
import javax.management.ObjectName;

/**
 * ServiceControlCommand is a serializable bean that contains JMX operations information. 
 * This data is passed in a command message from the OperationsCollector to the 
 * OperationsFiler.
 * 
 * ServiceControlCommand is used by the ESB Monitoring and Management console to invoke
 * JMX operations, but it can also be used in custom applications where you wish to control
 * the state of ESB services.     
 * 
 * See product/tools/console/invoke.jsp for an example of how to send a ServiceControlCommand
 * within a message in order to an invoke a JMX Operation.     
 * 
 * @author <a href="mailto:tcunning@redhat.com">Tom Cunningham</a>
 * @since Version 4.2
 */
public class ServiceControlCommand implements Serializable {
	private static final long serialVersionUID = -3039074516951343026L;
	private String objectName;
	private String attribute;
	private String server;
	private Date collectionTime; 
	private String operation;
	private String description;
	private String returntype;
	private Long id;
	
	public ServiceControlCommand(String f_objectName, String f_server, Date f_collectionTime, String f_operation,
			String f_description, String f_returntype) {
		operation = f_operation;
		objectName = f_objectName;
		server = f_server;
		collectionTime = f_collectionTime;
		description = f_description;
		returntype = f_returntype;
	}
	
	public ServiceControlCommand(ObjectName f_objectname, MBeanOperationInfo mboi, String f_server) {
		objectName = f_objectname.toString();
		operation = mboi.getName();
		server = f_server;
		description = mboi.getDescription();
		returntype = mboi.getReturnType();
	}
	
	/**
	 * Id name getter.
	 * @return id id
	 */
	public Long getId() {
		return id;
	}
	
	/**
	 * Id name mutator.
	 * @param id id
	 */
	public void setId(Long id) {
		this.id = id;
	}
	
	/**
	 * Attribute name getter.
	 * @return attribute name
	 */
	public String getAttribute() {
		return attribute;
	}
	
	/**
	 * Attribute name mutator.
	 * @param attribute attribute name
	 */
	public void setAttribute(String attribute) {
		this.attribute = attribute;
	}
	
	/**
	 * Collection time getter.
	 * @return collection time
	 */
	public Date getCollectionTime() {
		return collectionTime;
	}
	
	/**
	 * Collection time mutator.
	 * @param collectionTime collection time
	 */
	public void setCollectionTime(Date collectionTime) {
		this.collectionTime = collectionTime;
	}
	
	/**
	 * Object data getter.
	 * @return data
	 */
	public String getOperation() {
		return operation;
	}
	
	/**
	 * Object data mutator.
	 * @param data data
	 */
	public void setOperation(String operation) {
		this.operation = operation;
	}
	
	/**
	 * Object name getter.
	 * @return object name
	 */
	public String getObjectName() {
		return objectName;
	}
	
	/**
	 * Object name setter.
	 * @param objectName object name
	 */
	public void setObjectName(String objectName) {
		this.objectName = objectName;
	}
	
	/**
	 * Server name getter.
	 * @return server name
	 */
	public String getServer() {
		return server;
	}
	
	/**
	 * Server name mutator.
	 * @param server server name
	 */
	public void setServer(String server) {
		this.server = server;
	}
	
	/**
	 * Description name getter.
	 * @return server name
	 */
	public String getDescription() {
		return description;
	}
	
	/**
	 * Description name mutator.
	 * @param server server name
	 */
	public void setDescription(String description) {
		this.description = description;
	}
	
	/**
	 * Return type name getter.
	 * @return server name
	 */
	public String getReturntype() {
		return returntype;
	}
	
	/**
	 * Return type name mutator.
	 * @param server server name
	 */
	public void setReturntype(String returntype) {
		this.returntype = returntype;
	}
	
	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		return "objectName[" + objectName +"] attribute[" + attribute
			+ "] server[" + server + "] collectionTime[" + collectionTime 
			+ "] operation[" + operation + "]";
	}
}
