/*
 * JBoss, Home of Professional Open Source Copyright 2008, Red Hat Middleware
 * LLC, and individual contributors by the @authors tag. See the copyright.txt
 * in the distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.services.security.auth.login;

import java.io.IOException;

import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;

import org.jboss.internal.soa.esb.services.security.EsbCallbackHandler;
import org.jboss.internal.soa.esb.services.security.UserPassCallbackHandler;
import org.jboss.soa.esb.services.security.SecurityConfig;
import org.jboss.soa.esb.services.security.auth.AuthenticationRequest;

/**
 * JAAS Callbackhandler that can be used with JBossSTS login modules.
 * <p/>
 * 
 * This callback handler delegates to {@link UserPassCallbackHandler} to handle
 * username and password callbacks.
 * 
 * It also uses {@link JBossSTSTokenCallbackHandler} to retreive the token from the
 * authentication request.
 * 
 * @author <a href="mailto:dbevenius@jboss.com">Daniel Bevenius</a>
 */
public class JBossSTSIssueCallbackHandler implements EsbCallbackHandler
{
	private AuthenticationRequest authRequest;
    
    public void handle(final Callback[] callbacks) throws IOException, UnsupportedCallbackException
    {
        final UserPassCallbackHandler userPassHandler = new UserPassCallbackHandler(authRequest, false);
        userPassHandler.handle(callbacks);
        
        final JBossSTSTokenCallbackHandler tokenHandler = new JBossSTSTokenCallbackHandler(authRequest);
        tokenHandler.handle(callbacks);
    }

    public void setAuthenticationRequest(AuthenticationRequest authRequest)
    {
        this.authRequest = authRequest;
    }

    public void setSecurityConfig(SecurityConfig config)
    {
    }
}
