/*
 * JBoss, Home of Professional Open Source
 * Copyright 2009, Red Hat Middleware LLC, and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
package org.jboss.soa.bpel.runtime.engine;

import org.jboss.soa.dsp.InvocationAdapter;
import org.jboss.soa.dsp.ServiceProvider;

/**
 * This interface represents a BPEL engine.
 * 
 * @author gbrown
 * @author Heiko Braun
 *
 */
public interface BPELEngine extends ServiceProvider {

	public static final String Service="bpel/Engine";

	/**
	 * This method initializes the BPEL engine. This method must
	 * be called before invoking any BPEL processes.
	 * 
	 * @throws Exception Failed to initialize
	 */
    public void init() throws Exception;

  /**
   * 
   * @param invocationAdapter
   * @throws Exception
   */
   public void invoke(InvocationAdapter invocationAdapter) throws Exception;
	
	/**
	 * This method closes the BPEL engine.
	 * 
	 * @throws Exception Failed to close
	 */
    public void close() throws Exception;
    
  /**
   * Access the management interface of the underlying engine   
   */
  public Object getManagementInterface();
}
