/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import org.h2.command.ddl.SchemaCommand;
import org.h2.engine.Session;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.table.Table;

public class DropView
extends SchemaCommand {
    private String viewName;
    private boolean ifExists;

    public DropView(Session session, Schema schema) {
        super(session, schema);
    }

    public void setIfExists(boolean bl) {
        this.ifExists = bl;
    }

    public void setViewName(String string) {
        this.viewName = string;
    }

    public int update() {
        this.session.commit(true);
        Table table = this.getSchema().findTableOrView(this.session, this.viewName);
        if (table == null) {
            if (!this.ifExists) {
                throw DbException.get(90037, this.viewName);
            }
        } else {
            if (!"VIEW".equals(table.getTableType())) {
                throw DbException.get(90037, this.viewName);
            }
            this.session.getUser().checkRight(table, 15);
            table.lock(this.session, true, true);
            this.session.getDatabase().removeSchemaObject(this.session, table);
        }
        return 0;
    }
}

