/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.Multimap;
import com.google.common.collect.testing.OneSizeTestContainerGenerator;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.google.AbstractMultimapTester;
import java.util.Collection;
import java.util.Map;
import org.truth0.Truth;

@GwtCompatible
public class MultimapClearTester<K, V>
extends AbstractMultimapTester<K, V, Multimap<K, V>> {
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(absent={MapFeature.SUPPORTS_REMOVE})
    public void testClearUnsupported() {
        try {
            this.multimap().clear();
            MultimapClearTester.fail((String)"Expected UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    private void assertCleared() {
        MultimapClearTester.assertEquals((int)0, (int)this.multimap().size());
        MultimapClearTester.assertTrue((boolean)this.multimap().isEmpty());
        MultimapClearTester.assertEquals(this.multimap(), ((OneSizeTestContainerGenerator)this.getSubjectGenerator()).create(new Object[0]));
        Truth.ASSERT.that(Boolean.valueOf(this.multimap().entries().isEmpty()));
        Truth.ASSERT.that(Boolean.valueOf(this.multimap().asMap().isEmpty()));
        Truth.ASSERT.that(Boolean.valueOf(this.multimap().keySet().isEmpty()));
        Truth.ASSERT.that(Boolean.valueOf(this.multimap().keys().isEmpty()));
        Truth.ASSERT.that(Boolean.valueOf(this.multimap().values().isEmpty()));
        for (Object key : this.sampleKeys()) {
            this.assertGet(key, new Object[0]);
        }
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testClear() {
        this.multimap().clear();
        this.assertCleared();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testClearThroughEntries() {
        this.multimap().entries().clear();
        this.assertCleared();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testClearThroughAsMap() {
        this.multimap().asMap().clear();
        this.assertCleared();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testClearThroughKeySet() {
        this.multimap().keySet().clear();
        this.assertCleared();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testClearThroughKeys() {
        this.multimap().keys().clear();
        this.assertCleared();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testClearThroughValues() {
        this.multimap().values().clear();
        this.assertCleared();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testClearPropagatesToGet() {
        for (Object key : this.sampleKeys()) {
            this.resetContainer();
            Collection collection = this.multimap().get(key);
            this.multimap().clear();
            Truth.ASSERT.that(collection).isEmpty();
        }
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testClearPropagatesToAsMapGet() {
        for (Object key : this.sampleKeys()) {
            this.resetContainer();
            Collection collection = (Collection)this.multimap().asMap().get(key);
            if (collection == null) continue;
            this.multimap().clear();
            Truth.ASSERT.that(collection).isEmpty();
        }
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testClearPropagatesToAsMap() {
        Map asMap = this.multimap().asMap();
        this.multimap().clear();
        Truth.ASSERT.that(asMap).isEmpty();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testClearPropagatesToEntries() {
        Collection entries = this.multimap().entries();
        this.multimap().clear();
        Truth.ASSERT.that(entries).isEmpty();
    }
}

