/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.quick;

import com.intersys.cache.CacheObject;
import com.intersys.cache.Dataholder;
import com.intersys.cache.ExternalObjectProvider;
import com.intersys.cache.SysDatabase;
import com.intersys.cache.jdbcutil.ConnectionUtils;
import com.intersys.cache.jdbcutil.JDBCAdapter;
import com.intersys.cache.jdbcutil.RDBMSAdapter;
import com.intersys.cache.quick.ColumnBasedField;
import com.intersys.cache.quick.DBAdapter;
import com.intersys.cache.quick.Mappings;
import com.intersys.cache.quick.QuickCacheObject;
import com.intersys.cache.quick.QuickDatabase;
import com.intersys.cache.quick.QuickEmbeddedObject;
import com.intersys.cache.quick.QuickPersistentObject;
import com.intersys.cache.quick.QuickReaderObject;
import com.intersys.cache.quick.QuickStreamObject;
import com.intersys.cache.quick.SQLParser;
import com.intersys.cache.quick.SerialStorage;
import com.intersys.cache.quick.TableBasedClass;
import com.intersys.cache.quick.ThirdPartyDatabase;
import com.intersys.classes.CacheRootObject;
import com.intersys.classes.ObjectHandle;
import com.intersys.classes.Persistent;
import com.intersys.classes.RegisteredObject;
import com.intersys.classes.SerialObject;
import com.intersys.jdbc.CacheConnection;
import com.intersys.jdbc.ObjectFactory;
import com.intersys.jdbc.QuickStatement;
import com.intersys.jdbc.SysListProxy;
import com.intersys.objects.CacheException;
import com.intersys.objects.CacheInputStream;
import com.intersys.objects.CacheOutputStream;
import com.intersys.objects.CacheReader;
import com.intersys.objects.CacheServerException;
import com.intersys.objects.CacheServerSensitive;
import com.intersys.objects.CacheWriter;
import com.intersys.objects.CandidateKey;
import com.intersys.objects.DatabaseExistsException;
import com.intersys.objects.DatabaseUtilities;
import com.intersys.objects.Id;
import com.intersys.objects.InvalidClassException;
import com.intersys.objects.Logger;
import com.intersys.objects.ObjectServerInfo;
import com.intersys.objects.Oid;
import com.intersys.objects.StatusCode;
import com.intersys.objects.SystemError;
import com.intersys.objects.reflect.CacheClass;
import com.jalapeno.runtime.DetachedObjectsManager;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;

public abstract class LightDatabase
extends ExternalObjectProvider
implements SysDatabase,
Mappings,
ObjectFactory {
    private static Map databases = null;
    private Map mCache;
    protected boolean amIConnectionOwner;
    protected DBAdapter mAdapter;
    protected Map mClassMap;
    protected Map mTableToClassMap;
    private Map mReverseClassMap;
    protected Map mElementKeyMap;
    private Map mBulkLoadStatements;
    protected String mURL;
    private ClassLoader mClassLoader = null;
    protected ObjectServerInfo mInfo;
    protected long mProcess;
    private int mRefCount = 0;
    private boolean isConnectionOpen = false;
    private DetachedObjectsManager mDetachedbjectsManager;

    protected LightDatabase() {
    }

    protected LightDatabase(Connection connection) throws CacheException {
        this.amIConnectionOwner = false;
        try {
            this.mURL = connection.getMetaData().getURL();
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Can not determine Connection URL");
        }
        this.initClientDatabase(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initClientDatabase(Connection connection) throws CacheException {
        if (databases == null) {
            databases = Collections.synchronizedMap(new HashMap());
        }
        Map map = databases;
        synchronized (map) {
            if (databases.containsKey(connection)) {
                try {
                    int n = 0;
                    if (connection instanceof CacheConnection) {
                        n = (int)((CacheConnection)connection).getCacheJobID();
                    }
                    throw new DatabaseExistsException(n);
                }
                catch (SQLException sQLException) {
                    throw new DatabaseExistsException(0);
                }
            }
            this.isConnectionOpen = true;
            this.mClassMap = new HashMap();
            this.mTableToClassMap = new HashMap();
            this.mReverseClassMap = new HashMap();
            this.mElementKeyMap = new HashMap();
            this.mInfo = new ObjectServerInfo();
            this.onInitDatabase(connection);
            try {
                this.myConnection().setAutoCommit(true);
            }
            catch (SQLException sQLException) {
                throw new SystemError(sQLException, "Failed to set autocommit to true.");
            }
            int n = ConnectionUtils.determineCacheType();
            if (n != 0) {
                this.mCache = new HashMap();
            }
            databases.put(connection, this);
            ++this.mRefCount;
        }
    }

    protected abstract void onInitDatabase(Connection var1) throws CacheException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LightDatabase getDatabase(Connection connection) throws CacheException {
        Connection connection2 = connection;
        synchronized (connection2) {
            if (databases == null || !databases.containsKey(connection)) {
                return LightDatabase.createDatabase(connection);
            }
            QuickDatabase quickDatabase = (QuickDatabase)databases.get(connection);
            if (!LightDatabase.onTheSameConnection(quickDatabase, connection)) {
                return LightDatabase.createDatabase(connection);
            }
            ++quickDatabase.mRefCount;
            if (Logger.debugOn()) {
                Logger.out.println("Increased ref count for Database " + quickDatabase.mProcess + " it is now " + quickDatabase.mRefCount);
            }
            return quickDatabase;
        }
    }

    private static boolean onTheSameConnection(LightDatabase lightDatabase, Connection connection) throws CacheException {
        try {
            String string;
            if (!(connection instanceof CacheConnection) && "Cache".equalsIgnoreCase(string = connection.getMetaData().getDatabaseProductName())) {
                connection = JDBCAdapter.getCacheConnection(connection);
            }
            if (connection instanceof CacheConnection) {
                long l;
                long l2 = ((CacheConnection)connection).getCacheJobID();
                return l2 == (l = lightDatabase.mProcess);
            }
            return true;
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException, "Attempt to use closed connection to construct Database");
        }
    }

    private static LightDatabase createDatabase(Connection connection) throws CacheException {
        String string;
        if (connection instanceof CacheConnection) {
            return new QuickDatabase(connection);
        }
        try {
            string = connection.getMetaData().getDatabaseProductName();
        }
        catch (SQLException sQLException) {
            throw new CacheException("Can not determine Database Product.");
        }
        if ("Cache".equalsIgnoreCase(string)) {
            connection = JDBCAdapter.getCacheConnection(connection);
            return new QuickDatabase(connection);
        }
        return new ThirdPartyDatabase(connection);
    }

    public CacheObject openByKey(String string, CandidateKey candidateKey, int n) throws CacheException {
        Object object;
        int n2;
        TableBasedClass tableBasedClass = (TableBasedClass)this.getCacheClass(string);
        String string2 = tableBasedClass.getSchemaName();
        String string3 = tableBasedClass.getSQLTableName();
        int n3 = n2 = n > 0 ? 0 : 1;
        if (Logger.debugOn()) {
            Logger.out.println("Opening by key: " + candidateKey);
        }
        if ((object = this.myAdapter().loadByKey(string2, string3, candidateKey, n2, tableBasedClass)) == null) {
            throw new CacheException("Failed to open object of class " + tableBasedClass.getName() + " with primary key " + candidateKey.toString(), 5809);
        }
        int n4 = tableBasedClass.getSQLTableMetadata().getRowIdColumnNumber();
        String string4 = null;
        try {
            SysListProxy.rewind(object);
            string4 = SysListProxy.getString(object, n4 - 1);
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException, "Failed to determine id of opened object");
        }
        SQLRow sQLRow = new SQLRow(string4, tableBasedClass);
        QuickPersistentObject quickPersistentObject = null;
        if (this.mCache != null) {
            quickPersistentObject = (QuickPersistentObject)this.mCache.get(sQLRow);
        }
        if (quickPersistentObject == null) {
            quickPersistentObject = this.createCacheObject(object, tableBasedClass, null, tableBasedClass.getName(), string4, n2, 7502);
        }
        return quickPersistentObject;
    }

    private Object existsByKey(TableBasedClass tableBasedClass, CandidateKey candidateKey) throws CacheException {
        String string = tableBasedClass.getSchemaName();
        String string2 = tableBasedClass.getSQLTableName();
        if (Logger.debugOn()) {
            Logger.out.println("Exists for key: " + candidateKey);
        }
        return this.myAdapter().existsForKey(string, string2, candidateKey);
    }

    private Dataholder[] existsByKey(String string, String string2, Dataholder[] dataholderArray) throws CacheException {
        TableBasedClass tableBasedClass = (TableBasedClass)this.getCacheClass(string);
        int n = string2.lastIndexOf("Exists");
        String string3 = string2.substring(0, n);
        CandidateKey candidateKey = tableBasedClass.createKey(string3);
        int n2 = candidateKey.getLength();
        for (int i = 0; i < dataholderArray.length; ++i) {
            if (i >= n2) continue;
            candidateKey.set(i, dataholderArray[i].getString());
        }
        Object object = this.existsByKey(tableBasedClass, candidateKey);
        boolean bl = object != null;
        return new Dataholder[]{new Dataholder(bl), Dataholder.create(object)};
    }

    public boolean deleteObject(String string, CandidateKey candidateKey) throws CacheException {
        int n = 0;
        TableBasedClass tableBasedClass = (TableBasedClass)this.getCacheClass(string);
        String string2 = tableBasedClass.getSchemaName();
        String string3 = tableBasedClass.getSQLTableName();
        int n2 = n > 0 ? 0 : 1;
        return this.myAdapter().deleteByKey(string2, string3, candidateKey, n2, tableBasedClass);
    }

    public DetachedObjectsManager getDetachedObjectsManager() {
        if (this.mDetachedbjectsManager == null) {
            this.mDetachedbjectsManager = DetachedObjectsManager.createDetachedObjectsManager(this);
        }
        return this.mDetachedbjectsManager;
    }

    protected DetachedObjectsManager getDetachedObjectsManagerIfExists() {
        return this.mDetachedbjectsManager;
    }

    public CacheObject openCacheObject(String string, byte[] byArray, int n, int n2) throws CacheException {
        if (n2 <= 0) {
            return this.openCacheObject(string, byArray, n);
        }
        throw new CacheException("Timeout is not supported in this implementation of Database interface.");
    }

    public CacheObject openCacheObject(String string, byte[] byArray) throws CacheException {
        return this.openCacheObject(string, byArray, -1);
    }

    public CacheObject openCacheObject(Oid oid, int n, int n2) throws CacheException {
        if (n2 > 0) {
            throw new CacheException("Timeout is not supported in this implementation of Database interface.");
        }
        SQLRow sQLRow = new SQLRow(this, oid);
        return this.openObjectByRow(sQLRow, n, null);
    }

    public CacheObject openCacheObject(String string, String string2) throws CacheException {
        SQLRow sQLRow = new SQLRow(this, string2, string);
        return this.openObjectByRow(sQLRow, -1, string);
    }

    public CacheObject openCacheObject(String string, String string2, int n) throws CacheException {
        SQLRow sQLRow = new SQLRow(this, string2, string);
        return this.openObjectByRow(sQLRow, n, string);
    }

    public CacheObject openCacheObject(String string, String string2, int n, int n2) throws CacheException {
        SQLRow sQLRow = new SQLRow(this, string2, string);
        if (n2 > 0) {
            throw new CacheException("Timeout is not supported in this implementation of Database interface.");
        }
        return this.openObjectByRow(sQLRow, n, string);
    }

    public CacheObject openCacheObject(String string, byte[] byArray, int n) throws CacheException {
        SQLRow sQLRow;
        TableBasedClass tableBasedClass = (TableBasedClass)this.getCacheClass(string);
        if (tableBasedClass.isSerial()) {
            return this.deserializeObject(string, byArray);
        }
        if (string != null) {
            CacheClass cacheClass = this.getCacheClass(string);
            if (cacheClass == null) {
                throw new InvalidClassException("Cacahe class " + string + " does not exist");
            }
            sQLRow = new SQLRow(byArray, cacheClass, this);
        } else {
            sQLRow = new SQLRow(byArray, null, this);
        }
        return this.openObjectByRow(sQLRow, n, string);
    }

    private CacheObject openObjectByRow(SQLRow sQLRow, int n, String string) throws CacheException {
        QuickPersistentObject quickPersistentObject = null;
        if (this.mCache != null) {
            quickPersistentObject = (QuickPersistentObject)this.mCache.get(sQLRow);
        }
        if (quickPersistentObject != null) {
            return quickPersistentObject;
        }
        if (string == null || string.startsWith("%") && sQLRow.getClassName() != null) {
            string = sQLRow.getClassName();
        }
        int n2 = n <= 0 ? 1 : 0;
        TableBasedClass tableBasedClass = (TableBasedClass)this.getCacheClass(string);
        Object object = this.loadObject(sQLRow, n2, tableBasedClass);
        quickPersistentObject = this.createCacheObject(object, tableBasedClass, sQLRow, string, null, n2, 7502);
        return quickPersistentObject;
    }

    private synchronized QuickPersistentObject createCacheObject(Object object, TableBasedClass tableBasedClass, SQLRow sQLRow, String string, String string2, int n, int n2) throws CacheException {
        if (Logger.getDebugCache()) {
            Logger.out.println("Recieved data for object: " + object);
        }
        String string3 = LightDatabase.parseClassName(tableBasedClass, object);
        QuickPersistentObject quickPersistentObject = null;
        if (string3 != null && !string3.equals(string)) {
            if (string2 == null) {
                string2 = sQLRow.getId();
            }
            sQLRow = new SQLRow(this, string2, string3);
            if (this.mCache != null) {
                quickPersistentObject = (QuickPersistentObject)this.mCache.get(sQLRow);
            }
            if (quickPersistentObject != null) {
                return quickPersistentObject;
            }
            tableBasedClass = (TableBasedClass)this.getCacheClass(string3);
            object = this.loadObject(sQLRow, n, tableBasedClass);
        }
        quickPersistentObject = new QuickPersistentObject(tableBasedClass, object, n2);
        this.addToMap(quickPersistentObject, sQLRow, string, string2);
        return quickPersistentObject;
    }

    protected void addToMap(QuickPersistentObject quickPersistentObject, SQLRow sQLRow, String string, String string2) throws CacheException {
        QuickPersistentObject quickPersistentObject2;
        if (this.mCache == null) {
            return;
        }
        if (sQLRow == null) {
            sQLRow = new SQLRow(this, string2, string);
        }
        if ((quickPersistentObject2 = this.mCache.put(sQLRow, quickPersistentObject)) != null && quickPersistentObject2 != quickPersistentObject) {
            throw new IllegalStateException("Replacing an object in Cache!");
        }
    }

    protected void removeFromMap(String string, String string2) throws CacheException {
        if (this.mCache == null) {
            return;
        }
        SQLRow sQLRow = new SQLRow(this, string2, string);
        this.mCache.remove(sQLRow);
    }

    protected String getColumnSQL(TableBasedClass tableBasedClass) throws CacheException {
        return tableBasedClass.getColumnsSQL();
    }

    public Iterator openByQuery(String string, String string2) throws CacheException {
        TableBasedClass tableBasedClass = (TableBasedClass)this.getCacheClass(string);
        String string3 = tableBasedClass.getFullSQLTableNameQuoted();
        String string4 = "select " + this.getColumnSQL(tableBasedClass) + " from " + string3;
        if (string2 != null && string2.trim().length() > 0) {
            string4 = string4 + " where " + string2;
        }
        return this.openByQuery(string4, tableBasedClass, null);
    }

    public Iterator openByQuery(String string, String string2, Object[] objectArray) throws CacheException {
        TableBasedClass tableBasedClass = (TableBasedClass)this.getCacheClass(string);
        String string3 = tableBasedClass.getFullSQLTableNameQuoted();
        String string4 = "select " + this.getColumnSQL(tableBasedClass) + " from " + string3;
        if (string2 != null && string2.trim().length() > 0) {
            string4 = string4 + " where " + string2;
        }
        return this.openByQuery(string4, tableBasedClass, objectArray);
    }

    public Iterator openByQuery(String string) throws CacheException {
        StringBuffer stringBuffer = new StringBuffer(string);
        TableBasedClass tableBasedClass = (TableBasedClass)SQLParser.forBulkLoad(stringBuffer, this, null);
        return this.openByQuery(stringBuffer.toString(), tableBasedClass, null);
    }

    public Iterator openByQuery(String string, Object[] objectArray) throws CacheException {
        StringBuffer stringBuffer = new StringBuffer(string);
        TableBasedClass tableBasedClass = (TableBasedClass)SQLParser.forBulkLoad(stringBuffer, this, null);
        return this.openByQuery(stringBuffer.toString(), tableBasedClass, objectArray);
    }

    private Iterator openByQuery(String string, TableBasedClass tableBasedClass, Object[] objectArray) throws CacheException {
        string = this.adjustSQL(tableBasedClass, string);
        int n = tableBasedClass.getIdField().getColumnIndexForGet() - 1;
        if (Logger.getDebugCache()) {
            Logger.out.println("Opening by query: " + string);
        }
        try {
            PreparedStatement preparedStatement = this.getStatementForOpen(string);
            if (objectArray != null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (object == null) {
                        preparedStatement.setNull(i + 1, 12);
                        continue;
                    }
                    preparedStatement.setObject(i + 1, objectArray[i]);
                }
            }
            ResultSet resultSet = this.myAdapter().executeQuery(preparedStatement);
            return this.getResultSetIterator(resultSet, tableBasedClass, n);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed to open objects of class " + tableBasedClass.getName() + " by query: " + string);
        }
    }

    protected String adjustSQL(TableBasedClass tableBasedClass, String string) throws CacheException {
        return string;
    }

    protected abstract Iterator getResultSetIterator(ResultSet var1, TableBasedClass var2, int var3) throws CacheException;

    private PreparedStatement getStatementForOpen(String string) throws SQLException {
        PreparedStatement preparedStatement;
        if (this.mBulkLoadStatements == null) {
            this.mBulkLoadStatements = new HashMap();
        }
        if ((preparedStatement = (PreparedStatement)this.mBulkLoadStatements.get(string)) == null) {
            preparedStatement = this.myConnection().prepareStatement(string);
            this.mBulkLoadStatements.put(string, preparedStatement);
        }
        return preparedStatement;
    }

    public Collection openObjects(String string, Collection collection, int n) throws CacheException {
        ArrayList arrayList = new ArrayList(collection.size());
        Object object = SysListProxy.createSysList(this.getConnectionInfo());
        try {
            if (!this.prepareForBulkLoad(arrayList, object, string, collection)) {
                return arrayList;
            }
            int n2 = n <= 0 ? 1 : 0;
            Object object2 = this.bulkLoad(string, object, n2);
            this.postBulkLoad(arrayList, object, object2, string, n2);
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException, "Error opening a set of object of class " + string);
        }
        return arrayList;
    }

    private boolean prepareForBulkLoad(List list, Object object, String string, Collection collection) throws CacheException, SQLException {
        int n = 0;
        if (this.mCache != null) {
            for (Object object2 : collection) {
                SQLRow sQLRow;
                Object v;
                if (!(object2 instanceof String)) {
                    object2 = object2.toString();
                }
                if ((v = this.mCache.get(sQLRow = new SQLRow(this, (String)object2, string))) != null) {
                    list.add(((CacheObject)v).newJavaInstance());
                    continue;
                }
                SysListProxy.setString(object, (String)object2);
                ++n;
            }
            if (n == 0) {
                return false;
            }
            Object object3 = SysListProxy.createSysList(this.getConnectionInfo());
            SysListProxy.setInteger(object3, n);
            SysListProxy.concatenate(object3, object);
            object = object3;
        } else {
            n = collection.size();
            SysListProxy.setInteger(object, n);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                SysListProxy.setObject(object, iterator.next());
            }
        }
        return true;
    }

    private void postBulkLoad(List list, Object object, Object object2, String string, int n) throws CacheException, SQLException {
        SysListProxy.rewind(object);
        int n2 = SysListProxy.getInteger(object);
        int n3 = 0;
        while (!SysListProxy.atEnd(object2)) {
            Object object3 = SysListProxy.getSubList(object2, 18);
            QuickPersistentObject quickPersistentObject = null;
            TableBasedClass tableBasedClass = (TableBasedClass)this.getCacheClass(string);
            String string2 = SysListProxy.getString(object);
            quickPersistentObject = this.createCacheObject(object3, tableBasedClass, null, string, string2, n, 7502);
            list.add(quickPersistentObject.newJavaInstance());
            ++n3;
        }
        if (n3 != n2) {
            throw new SystemError("Only " + n3 + " out of " + n2 + " objects were opened.");
        }
    }

    private static String parseClassName(TableBasedClass tableBasedClass, Object object) throws CacheException {
        String string;
        int n = tableBasedClass.getXClassNameColumn();
        try {
            SysListProxy.rewind(object);
            string = SysListProxy.getString(object, n - 1);
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException, "Failed to determine real class of opened object");
        }
        if (string == null) {
            return null;
        }
        int n2 = string.lastIndexOf(126);
        string = string.substring(0, n2);
        int n3 = string.lastIndexOf(126);
        return string.substring(n3 + 1, n2);
    }

    protected Object loadObject(String string, TableBasedClass tableBasedClass) throws CacheException {
        SQLRow sQLRow = new SQLRow(string, tableBasedClass);
        return this.loadObject(sQLRow, 1, tableBasedClass);
    }

    private Object loadObject(SQLRow sQLRow, int n, TableBasedClass tableBasedClass) throws CacheException {
        Object object = this.myAdapter().load(sQLRow.schema, sQLRow.table, sQLRow.getId(), n, tableBasedClass);
        if (object == null) {
            throw new CacheException("Failed to open object of class " + sQLRow.getClassName() + " with id " + sQLRow.getId(), 5809);
        }
        return object;
    }

    private Object bulkLoad(String string, Object object, int n) throws CacheException {
        CacheClass cacheClass = this.getCacheClass(string);
        if (cacheClass == null) {
            throw new CacheException("Cache class " + string + " does not exist");
        }
        SQLRow sQLRow = new SQLRow(cacheClass);
        Object object2 = this.myAdapter().bulkLoad(sQLRow.schema, sQLRow.table, object, n);
        if (object2 == null) {
            throw new CacheException("Failed to open set of objects of class " + sQLRow.getClassName(), 5809);
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheObject newCacheObject(String string) throws CacheException {
        TableBasedClass tableBasedClass = (TableBasedClass)this.getCacheClass(string);
        Object object = tableBasedClass;
        synchronized (object) {
            if (!tableBasedClass.isVerified()) {
                tableBasedClass.verifyClass();
            }
        }
        if (tableBasedClass.isPersistent()) {
            return new QuickPersistentObject(tableBasedClass);
        }
        if (tableBasedClass.hasSerialStorage()) {
            object = new SerialStorage(tableBasedClass, null);
            return new QuickEmbeddedObject((SerialStorage)object);
        }
        return new QuickEmbeddedObject(tableBasedClass);
    }

    public CacheObject deserializeObject(String string, byte[] byArray) throws CacheException {
        return this.deserializeObject(string, SysListProxy.createSysList(byArray, this.getConnectionInfo()));
    }

    public CacheObject deserializeObject(String string, Object object) throws CacheException {
        SerialStorage serialStorage = new SerialStorage(this, string, object);
        return new QuickEmbeddedObject(serialStorage);
    }

    public Object deserialize(Object object) throws SQLException {
        try {
            if (object == null || SysListProxy.atEnd(object)) {
                return null;
            }
            return this.deserializeObject(null, object).newJavaInstance();
        }
        catch (CacheException cacheException) {
            throw new SQLException(cacheException.getMessage());
        }
    }

    public CacheObject newClientObject(String string) throws CacheException {
        return this.newCacheObject(string);
    }

    public CacheObject newCacheObject(String string, String string2) throws CacheException {
        if (string2 == null || string2.length() == 0) {
            return this.newCacheObject(string);
        }
        throw new CacheException("Constructor with argument is not  supported in Light mode.");
    }

    protected ArrayList getListOfReferencesAsChildTable(String string, Object object, int n, int n2, int n3) throws CacheException {
        SQLRow sQLRow = new SQLRow(string);
        return this.myAdapter().getListAsChildTable(sQLRow.schema, sQLRow.table, object, n, n2, 0, n3);
    }

    protected HashMap getArrayOfReferencesAsChildTable(String string, Object object, int n, int n2, int n3) throws CacheException {
        SQLRow sQLRow = new SQLRow(string);
        return this.myAdapter().getArrayAsChildTable(sQLRow.schema, sQLRow.table, object, n, n2, 0, n3);
    }

    public void createObjects(String string, Collection collection) throws CacheException {
        Object object;
        Object object2;
        Object object32;
        if (!this.serverSupportsBulk()) {
            throw new CacheServerException("Server does not support operation. Upgrade to a later version");
        }
        int n = collection.size();
        if (Logger.getDebugCache()) {
            Logger.out.println("Creating " + n + " objects of type " + string);
        }
        Object object4 = this.createSysList();
        try {
            SysListProxy.setInteger(object4, n);
        }
        catch (SQLException sQLException) {
            throw new SystemError(sQLException, "Weird error: empty list is corrupted.");
        }
        int n2 = 0;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object object5 = SysListProxy.createSysList(this.getConnectionInfo());
        for (Object object32 : collection) {
            object2 = (QuickPersistentObject)((CacheRootObject)object32).getProxy();
            if (n2 > 0) {
                SysListProxy.clearList(object5);
            }
            switch (((QuickPersistentObject)object2).save(object5, true, false)) {
                case 2: {
                    arrayList.add(object32);
                }
                case 0: 
                case 1: {
                    try {
                        SysListProxy.concatenate(object4, object5);
                        break;
                    }
                    catch (SQLException sQLException) {
                        throw new SystemError(sQLException, "Data is corrupted.");
                    }
                }
                default: {
                    throw new SystemError("Unknown code from save.");
                }
            }
            if (Logger.getDebugCache()) {
                Logger.out.println(n2 + ": values: " + object5.toString());
            }
            ++n2;
        }
        TableBasedClass tableBasedClass = (TableBasedClass)this.getCacheClass(string);
        object32 = new SQLRow(tableBasedClass);
        object2 = this.myAdapter().bulkCreate(((SQLRow)object32).schema, ((SQLRow)object32).table, 4, object4, 0);
        ColumnBasedField columnBasedField = tableBasedClass.getIdField();
        n2 = 0;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object object6;
            try {
                object6 = SysListProxy.getObject(object2);
            }
            catch (SQLException sQLException) {
                throw new CacheException(sQLException, "Only " + n2 + " objects were created successfully.");
            }
            object = (Persistent)iterator.next();
            QuickPersistentObject quickPersistentObject = (QuickPersistentObject)((CacheRootObject)object).getProxy();
            quickPersistentObject.setProperty(columnBasedField, Dataholder.create(object6), false, true);
            ++n2;
        }
        if (Logger.getDebugCache()) {
            Logger.out.println("Scheduling for second save: " + arrayList.size() + " objects");
        }
        if (!arrayList.isEmpty()) {
            this.saveObjects(string, arrayList);
        }
        for (Object object6 : collection) {
            object = (QuickPersistentObject)((CacheRootObject)object6).getProxy();
            ((QuickPersistentObject)object).invalidate(null);
        }
    }

    public void saveObjects(String string, Collection collection) throws CacheException {
        Object object42;
        if (!this.serverSupportsBulk()) {
            throw new CacheServerException("Server does not support operation. Upgrade to a later version");
        }
        int n = collection.size();
        if (Logger.getDebugCache()) {
            Logger.out.println("Saving " + n + " objects of type " + string);
        }
        Object object2 = this.createSysList();
        try {
            SysListProxy.setInteger(object2, n);
        }
        catch (SQLException sQLException) {
            throw new SystemError(sQLException, "Weird error: empty list is corrupted.");
        }
        int n2 = 0;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object object3 = SysListProxy.createSysList(this.getConnectionInfo());
        boolean[] blArray = new boolean[n];
        for (Object object42 : collection) {
            Iterator iterator = (QuickPersistentObject)((CacheRootObject)object42).getProxy();
            if (n2 > 0) {
                SysListProxy.clearList(object3);
            }
            try {
                SysListProxy.setString(object3, ((QuickPersistentObject)((Object)iterator)).getId().toString());
            }
            catch (SQLException sQLException) {
                throw new SystemError(sQLException, "List is corrupted.");
            }
            switch (((QuickPersistentObject)((Object)iterator)).save(object3, true, false)) {
                case 2: {
                    arrayList.add(object42);
                }
                case 1: {
                    blArray[n2] = true;
                }
                case 0: {
                    try {
                        SysListProxy.concatenate(object2, object3);
                        break;
                    }
                    catch (SQLException sQLException) {
                        throw new SystemError(sQLException, "List is corrupted.");
                    }
                }
                default: {
                    throw new SystemError("Unknown code from save.");
                }
            }
            if (Logger.getDebugCache()) {
                Logger.out.println(n2 + ": values: " + object3.toString());
            }
            ++n2;
        }
        CacheClass cacheClass = this.getCacheClass(string);
        if (cacheClass == null) {
            throw new CacheException("Cache class " + string + " does not exist");
        }
        object42 = new SQLRow(cacheClass);
        this.myAdapter().bulkStore(((SQLRow)object42).schema, ((SQLRow)object42).table, object2, 0);
        if (Logger.getDebugCache()) {
            Logger.out.println("Scheduling for second save: " + arrayList.size() + " objects");
        }
        for (Persistent persistent : arrayList) {
            persistent.getProxy().save(false);
        }
        n2 = 0;
        for (Persistent persistent : collection) {
            if (blArray[n2]) {
                QuickPersistentObject quickPersistentObject = (QuickPersistentObject)persistent.getProxy();
                quickPersistentObject.invalidate(null);
            }
            ++n2;
        }
    }

    protected Object create(TableBasedClass tableBasedClass, Object object) throws CacheException {
        SQLRow sQLRow = new SQLRow(tableBasedClass);
        if (Logger.getDebugCache()) {
            Logger.out.println("Creating object of type " + tableBasedClass.getName());
            Logger.out.println("Values: " + object.toString());
        }
        int n = tableBasedClass.getIdField().getJDBCType();
        Object object2 = this.myAdapter().create(sQLRow.schema, sQLRow.table, n, object, 1, tableBasedClass);
        return object2;
    }

    protected String createChild(CacheClass cacheClass, Object object, Object object2) throws CacheException {
        SQLRow sQLRow = new SQLRow(cacheClass);
        return (String)this.saveChildRow(sQLRow, object, 12, object2);
    }

    protected void save(Oid oid, Object object) throws CacheException {
        SQLRow sQLRow = new SQLRow(this, oid);
        if (Logger.getDebugCache()) {
            Logger.out.print("Updating object of type " + sQLRow.getClassName());
            Logger.out.println("; id: " + sQLRow.getId());
            Logger.out.println("Values: " + object.toString());
        }
        this.myAdapter().store(sQLRow.schema, sQLRow.table, sQLRow.getId(), object, 0, (TableBasedClass)this.getCacheClass(sQLRow.getClassName()));
    }

    protected void saveChildList(String string, String string2, List list, boolean bl) throws CacheException {
        SQLRow sQLRow = new SQLRow(string);
        this.myAdapter().childTableRowRemove(sQLRow.schema, sQLRow.table, string2, 0);
        int n = this.getKeyColumn(string);
        int n2 = 0;
        for (Object e : list) {
            this.saveValueAsChild(sQLRow, string2, 4, n, new Integer(++n2), e, bl, true);
        }
    }

    public boolean isLightConnection() {
        return true;
    }

    protected void saveChildArray(String string, String string2, Map map, boolean bl) throws CacheException {
        SQLRow sQLRow = new SQLRow(string);
        this.myAdapter().childTableRowRemove(sQLRow.schema, sQLRow.table, string2, 0);
        int n = this.getKeyColumn(string);
        for (Map.Entry entry : map.entrySet()) {
            this.saveValueAsChild(sQLRow, string2, 12, n, entry.getKey(), entry.getValue(), bl, false);
        }
    }

    protected int getKeyColumn(String string) throws CacheException {
        TableBasedClass tableBasedClass = (TableBasedClass)this.mClassMap.get(string);
        if (tableBasedClass == null) {
            return -1;
        }
        return tableBasedClass.getKeyColumn();
    }

    private void saveValueAsChild(SQLRow sQLRow, String string, int n, int n2, Object object, Object object2, boolean bl, boolean bl2) throws CacheException {
        try {
            if (object2 instanceof Persistent) {
                this.savePersistentAsChild(sQLRow, string, n, n2, object, (Persistent)object2, bl);
            } else if (object2 instanceof RegisteredObject) {
                this.saveSerialAsChild(sQLRow, string, n, n2, object, (RegisteredObject)object2, bl, bl2);
            } else {
                this.saveDatatypeAsChild(sQLRow, string, n, n2, object, object2);
            }
        }
        catch (SQLException sQLException) {
            throw new SystemError(sQLException, "Failed to stuff values to SysList");
        }
    }

    private void saveSerialAsChild(SQLRow sQLRow, String string, int n, int n2, Object object, RegisteredObject registeredObject, boolean bl, boolean bl2) throws CacheException, SQLException {
        ColumnBasedField columnBasedField;
        Object object2;
        Iterator iterator;
        TableBasedClass tableBasedClass = this.getCacheClass(registeredObject.getCacheClass().getName(), sQLRow.toString());
        int n3 = 2;
        int n4 = tableBasedClass.getNumberOfCachedElements() - n3;
        Vector<Object> vector = new Vector<Object>(n4);
        vector.setSize(n4);
        for (int i = 1; i < n4; ++i) {
            vector.set(i, QuickStatement.UNCHANGED_OBJECT);
        }
        try {
            if (n2 == 0) {
                vector.set(0, object);
                vector.set(1, QuickStatement.UNCHANGED_OBJECT);
            } else {
                vector.set(0, QuickStatement.UNCHANGED_OBJECT);
                vector.set(1, object);
            }
        }
        catch (Exception exception) {
            throw new SystemError(exception, "Failed to save child object of class " + tableBasedClass.getName() + " with key " + object + " row " + sQLRow.toString() + " (key type: " + n + " key column: " + n2 + " n = " + n4 + ")");
        }
        QuickCacheObject quickCacheObject = (QuickCacheObject)registeredObject.getProxy();
        if (quickCacheObject instanceof QuickEmbeddedObject) {
            iterator = ((QuickEmbeddedObject)quickCacheObject).getAllProperties();
        } else if (quickCacheObject instanceof QuickPersistentObject) {
            iterator = ((QuickPersistentObject)quickCacheObject).getAllProperties();
        } else {
            throw new CacheException("Unsupported type for serial object in child table " + sQLRow.schema + "." + sQLRow.table + ": " + quickCacheObject.getClass().getName());
        }
        while (iterator.hasNext()) {
            object2 = (Map.Entry)iterator.next();
            String string2 = (String)object2.getKey();
            columnBasedField = (ColumnBasedField)tableBasedClass.getField(string2);
            if (columnBasedField == null) continue;
            int n5 = columnBasedField.getColumnIndexForSet() - n3;
            if (bl2 && n5 < 2) continue;
            Object object3 = quickCacheObject.valueToSave(columnBasedField, object2.getValue(), bl);
            if (object3 instanceof Dataholder && ((Dataholder)object3).getObject() == null) {
                object3 = null;
            }
            if (object3 == null) continue;
            vector.set(n5, object3);
        }
        object2 = SysListProxy.createSysList(this.getConnectionInfo());
        SysListProxy.setInteger(object2, n4);
        for (int i = 0; i < n4; ++i) {
            columnBasedField = vector.get(i);
            if (columnBasedField.equals(QuickStatement.UNCHANGED_OBJECT)) {
                SysListProxy.setUndefined(object2);
                continue;
            }
            SysListProxy.setObject(object2, vector.get(i));
        }
        this.saveChildRow(sQLRow, string, n, object2);
    }

    protected TableBasedClass getCacheClass(String string, String string2) throws CacheException {
        TableBasedClass tableBasedClass = (TableBasedClass)this.mClassMap.get(string2);
        if (tableBasedClass == null) {
            throw new SystemError("Metadata for class " + string + " and child table " + string2 + " was not registered.");
        }
        return tableBasedClass;
    }

    protected boolean isClassRegistered(String string) {
        return this.mClassMap.get(string) != null;
    }

    private void savePersistentAsChild(SQLRow sQLRow, String string, int n, int n2, Object object, Persistent persistent, boolean bl) throws CacheException, SQLException {
        Id id = persistent.getId();
        if (id == null) {
            persistent.save(bl);
            id = persistent.getId();
        }
        Object object2 = SysListProxy.createSysList(this.getConnectionInfo());
        SysListProxy.setInteger(object2, 2);
        if (n2 == 0) {
            SysListProxy.setObject(object2, object);
            SysListProxy.setString(object2, id.toString());
        } else {
            SysListProxy.setString(object2, id.toString());
            SysListProxy.setObject(object2, object);
        }
        this.saveChildRow(sQLRow, string, n, object2);
    }

    private Object saveChildRow(SQLRow sQLRow, Object object, int n, Object object2) throws CacheException {
        if (Logger.getDebugCache()) {
            Logger.out.print("Updating child object of type " + sQLRow.getClassName());
            Logger.out.println("; parent id: " + object);
            Logger.out.println("values: " + object2.toString());
        }
        Object object3 = this.myAdapter().childTableRowInsert(sQLRow.schema, sQLRow.table, n, object, object2, 1);
        return object3;
    }

    private void saveDatatypeAsChild(SQLRow sQLRow, String string, int n, int n2, Object object, Object object2) throws CacheException, SQLException {
        Object object3 = SysListProxy.createSysList(this.getConnectionInfo());
        SysListProxy.setInteger(object3, 2);
        if (n2 == 0) {
            SysListProxy.setObject(object3, object);
            SysListProxy.setObject(object3, object2);
        } else {
            SysListProxy.setObject(object3, object2);
            SysListProxy.setObject(object3, object);
        }
        this.saveChildRow(sQLRow, string, n, object3);
    }

    protected Object wrapRefList(List list, boolean bl) throws CacheException {
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (Persistent persistent : list) {
            if (!this.equals(persistent.getDatabase())) {
                throw new CacheException("Attempt to save persistent " + persistent + " object from another database: " + persistent.getDatabase() + " in " + this.toString());
            }
            Id id = persistent.getId();
            if (bl || id == null) {
                persistent.save();
                id = persistent.getId();
            }
            arrayList.add(id.toString());
        }
        try {
            return SysListProxy.wrapListOfReferences(arrayList, this.getConnectionInfo());
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException, "Failed to wrap list of references");
        }
    }

    protected Object wrapSerialList(List list) throws CacheException {
        ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
        for (SerialObject serialObject : list) {
            arrayList.add(serialObject.serialize());
        }
        try {
            return SysListProxy.wrapListOfDatatypes(arrayList, this.getConnectionInfo());
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException, "Failed to wrap list of serial objects");
        }
    }

    protected Object wrapPrimList(List list) throws CacheException {
        try {
            return SysListProxy.wrapListOfDatatypes(list, this.getConnectionInfo());
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException, "Failed to wrap list of references");
        }
    }

    protected Object wrapRefArray(Map map, boolean bl) throws CacheException {
        HashMap hashMap = new HashMap(map.size());
        for (Map.Entry entry : map.entrySet()) {
            Persistent persistent = (Persistent)entry.getValue();
            if (!this.equals(persistent.getDatabase())) {
                throw new CacheException("Attempt to save persistent " + persistent + " object from another database: " + persistent.getDatabase() + " in " + this.toString());
            }
            Id id = persistent.getId();
            if (bl || id == null) {
                persistent.save();
                id = persistent.getId();
            }
            hashMap.put(entry.getKey(), id.toString());
        }
        try {
            return SysListProxy.wrapMapOfReferences(hashMap, this.getConnectionInfo());
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException, "Failed to wrap array of references");
        }
    }

    protected Object wrapPrimArray(Map map) throws CacheException {
        try {
            return SysListProxy.wrapMapOfDatatypes(map, this.getConnectionInfo());
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException, "Failed to wrap list of references");
        }
    }

    protected Object wrapSerialArray(Map map) throws CacheException {
        HashMap hashMap = new HashMap(map.size());
        for (Map.Entry entry : map.entrySet()) {
            SerialObject serialObject = (SerialObject)entry.getValue();
            hashMap.put(entry.getKey(), serialObject.serialize());
        }
        try {
            return SysListProxy.wrapMapOfDatatypes(hashMap, this.getConnectionInfo());
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException, "Failed to wrap list of references");
        }
    }

    protected Object wrapBinaryStream(InputStream inputStream, QuickCacheObject quickCacheObject) throws CacheException {
        return this.myAdapter().wrapBinaryStream(inputStream, quickCacheObject);
    }

    protected Object wrapCharacterStream(Reader reader, QuickCacheObject quickCacheObject) throws CacheException {
        return this.myAdapter().wrapCharacterStream(reader, quickCacheObject);
    }

    protected InputStream getJDBCBinaryStream(Object object) throws SQLException {
        return this.myAdapter().getBinaryStream(object);
    }

    protected Reader getJDBCCharacterStream(Object object) throws SQLException {
        return this.myAdapter().getReader(object);
    }

    public void deleteObject(Oid oid) throws CacheException {
        this.deleteObject(oid, -1);
    }

    public void deleteObject(Oid oid, int n) throws CacheException {
        SQLRow sQLRow = new SQLRow(this, oid);
        this.deleteObject(sQLRow, n);
    }

    public void deleteObject(String string, Id id) throws CacheException {
        this.deleteObject(string, id, -1);
    }

    public void deleteObject(String string, Id id, int n) throws CacheException {
        SQLRow sQLRow = new SQLRow(this, id.toString(), string);
        this.deleteObject(sQLRow, n);
    }

    private synchronized void deleteObject(SQLRow sQLRow, int n) throws CacheException {
        QuickPersistentObject quickPersistentObject = null;
        if (this.mCache != null) {
            quickPersistentObject = (QuickPersistentObject)this.mCache.get(sQLRow);
        }
        if (quickPersistentObject != null) {
            quickPersistentObject.objectDeleted();
        }
        int n2 = n > 0 ? 0 : 1;
        this.myAdapter().remove(sQLRow.schema, sQLRow.table, sQLRow.getId(), n2);
    }

    public CacheObject getCacheObjectUnsafe(String string, int n) throws CacheException {
        throw new SystemError("This method never should have been called  in this implementation of Database");
    }

    public boolean ensureInMap(int n, String string) throws CacheException {
        throw new SystemError("This method never should have been called  in this implementation of Database");
    }

    public void releaseFromMap(int n) throws CacheException {
        throw new SystemError("This method never should have been called  in this implementation of Database");
    }

    public int getCacheType() throws CacheException {
        if (this.mCache == null) {
            return 0;
        }
        return 1;
    }

    public Dataholder[] runClassMethod(String string, String string2, int[] nArray, Dataholder[] dataholderArray, int n) throws CacheException {
        if (string2.endsWith("Exists")) {
            return this.existsByKey(string, string2, dataholderArray);
        }
        throw new CacheException("Not supported feature. Use full Database implementation.");
    }

    public Dataholder runClassMethod(String string, String string2, Dataholder[] dataholderArray, int n) throws CacheException {
        if (string2.endsWith("Exists")) {
            return this.existsByKey(string, string2, dataholderArray)[0];
        }
        throw new CacheException("Not supported feature. Use full Database implementation.");
    }

    public void closeObject(int n) throws CacheException {
    }

    public void releaseObject(Object object) throws CacheException {
        SQLRow sQLRow = this.rowByZRef(object);
        if (sQLRow == null) {
            return;
        }
        QuickPersistentObject quickPersistentObject = (QuickPersistentObject)this.mCache.get(sQLRow);
        if (quickPersistentObject != null) {
            quickPersistentObject.invalidate(null);
        }
    }

    public void closeObject(Object object) throws CacheException {
        SQLRow sQLRow = this.rowByZRef(object);
        if (sQLRow == null) {
            return;
        }
        Object v = this.mCache.remove(sQLRow);
        if (v != null && v instanceof QuickPersistentObject) {
            ((QuickPersistentObject)v).cleanup();
        }
    }

    protected void closeObject(Object object, QuickCacheObject quickCacheObject) throws CacheException {
        SQLRow sQLRow = this.rowByZRef(object);
        if (sQLRow == null) {
            return;
        }
        Object v = this.mCache.get(sQLRow);
        if (v == null) {
            return;
        }
        quickCacheObject.cleanup();
        if (quickCacheObject != v) {
            throw new IllegalStateException("Object was replaced");
        }
        this.mCache.remove(sQLRow);
    }

    protected Object isInCache(Object object) throws CacheException {
        SQLRow sQLRow = this.rowByZRef(object);
        if (sQLRow == null) {
            return object;
        }
        return this.mCache.get(sQLRow);
    }

    private SQLRow rowByZRef(Object object) throws CacheException {
        SQLRow sQLRow;
        if (this.mCache == null) {
            return null;
        }
        if (object instanceof Oid) {
            sQLRow = new SQLRow(this, (Oid)object);
        } else if (object instanceof QuickCacheObject.ZRef) {
            QuickCacheObject.ZRef zRef = (QuickCacheObject.ZRef)object;
            String string = zRef.getIdString();
            if (string == null) {
                return null;
            }
            sQLRow = new SQLRow(this, string, zRef.getClassName());
        } else {
            throw new CacheException("Unknown type of Internal Object reference: " + object.getClass().getName());
        }
        return sQLRow;
    }

    public CacheInputStream getInputStream(int n) throws CacheException {
        throw new CacheException("Not yet implemented feature.");
    }

    public CacheReader getReader(int n) throws CacheException {
        throw new CacheException("Not yet implemented feature.");
    }

    public CacheOutputStream getOutputStream(int n) throws CacheException {
        throw new CacheException("Not yet implemented feature.");
    }

    public CacheWriter getWriter(int n) throws CacheException {
        throw new CacheException("Not yet implemented feature.");
    }

    public CacheInputStream getInputStream(CacheObject cacheObject) throws CacheException {
        QuickStreamObject quickStreamObject = (QuickStreamObject)cacheObject;
        return quickStreamObject.getIn();
    }

    public CacheReader getReader(CacheObject cacheObject) throws CacheException {
        QuickReaderObject quickReaderObject = (QuickReaderObject)cacheObject;
        return quickReaderObject.getIn();
    }

    public CacheOutputStream getOutputStream(CacheObject cacheObject) throws CacheException {
        QuickStreamObject quickStreamObject = (QuickStreamObject)cacheObject;
        return quickStreamObject.getOut();
    }

    public CacheWriter getWriter(CacheObject cacheObject) throws CacheException {
        QuickReaderObject quickReaderObject = (QuickReaderObject)cacheObject;
        return quickReaderObject.getOut();
    }

    public ResultSet getCacheResultSet(String string) throws CacheException {
        if (this.myAdapter() instanceof JDBCAdapter) {
            return ((JDBCAdapter)((Object)this.myAdapter())).getCacheResultSet(string);
        }
        throw new CacheException("Getting ResultSet by oref is not supported in this mode.");
    }

    public boolean existsObject(Oid oid) throws CacheException {
        SQLRow sQLRow = new SQLRow(this, oid);
        return this.existsObject(sQLRow);
    }

    public boolean existsObject(String string, Id id) throws CacheException {
        SQLRow sQLRow = new SQLRow(this, id.toString(), string);
        return this.existsObject(sQLRow);
    }

    private boolean existsObject(SQLRow sQLRow) throws CacheException {
        try {
            String string = sQLRow.schema + '.' + sQLRow.table;
            int n = this.myAdapter().countElements(string, "ID='" + sQLRow.getId() + "'");
            if (n == 1) {
                return true;
            }
            if (n == 0) {
                return false;
            }
            throw new SystemError("Unknown error checking object existence");
        }
        catch (CacheServerException cacheServerException) {
            throw new CacheException(cacheServerException, "Failed to check for object existence: table: " + sQLRow.schema + '.' + sQLRow.table + "; id: " + sQLRow.getId());
        }
    }

    public Statement createStatement() throws CacheException {
        try {
            return this.myConnection().createStatement();
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed to create SQL statement.");
        }
    }

    public PreparedStatement prepareStatement(String string) throws CacheException {
        try {
            return this.myConnection().prepareStatement(string);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed to prepare SQL statement: " + string);
        }
    }

    public CallableStatement prepareCall(String string) throws CacheException {
        return RDBMSAdapter.prepareCall(this.myConnection(), string);
    }

    public boolean isLowLevelConnectionClosed() throws CacheException {
        try {
            return this.mAdapter == null || this.mAdapter.getConnection() == null || this.mAdapter.getConnection().isClosed();
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException, "Failed to check whether connection is closed.");
        }
    }

    public Object getListBuffer(int n, int n2, int n3) throws CacheException {
        throw new CacheException("Not yet implemented feature.");
    }

    public Object getArrayBuffer(int n, String string, int n2, int n3) throws CacheException {
        throw new CacheException("Not yet implemented feature.");
    }

    public Object getObjectListBuffer(int n, int n2, int n3) throws CacheException {
        throw new CacheException("Not yet implemented feature.");
    }

    public Object getObjectArrayBuffer(int n, String string, int n2, int n3) throws CacheException {
        throw new CacheException("Not yet implemented feature.");
    }

    public void registerSensitiveObject(CacheServerSensitive cacheServerSensitive) {
        throw new UnsupportedOperationException("Not supported feature. Use full Database implementation.");
    }

    public void registerSensitiveObject(CacheServerSensitive cacheServerSensitive, Set set) throws CacheException {
        throw new CacheException("Not supported feature. Use full Database implementation.");
    }

    public void registerSensitiveObject(CacheServerSensitive cacheServerSensitive, ObjectHandle objectHandle) throws CacheException {
        throw new CacheException("Not supported feature. Use full Database implementation.");
    }

    public void registerSensitiveObject(CacheServerSensitive cacheServerSensitive, int n) throws CacheException {
        throw new CacheException("Not supported feature. Use full Database implementation.");
    }

    public boolean unRegisterSensitiveObject(CacheServerSensitive cacheServerSensitive) throws CacheException {
        throw new CacheException("Not supported feature. Use full Database implementation.");
    }

    public void processObjectBuffer(Object object, Object object2, CacheServerSensitive cacheServerSensitive) throws CacheException {
        throw new CacheException("Not supported feature. Use full Database implementation.");
    }

    public void decreaseServerReferenceCount(int n, int n2) throws CacheException {
        throw new CacheException("Not supported feature. Use full Database implementation.");
    }

    public void onConnectionClosed() {
        if (Logger.debugOn()) {
            Logger.out.println(this.mProcess + ": " + this.toString() + ": Connection closed event received.");
        }
        try {
            this.mRefCount = 0;
            this.close();
        }
        catch (Exception exception) {
            ConnectionUtils.processErrorOnConnectionClose(exception, this, this.mProcess);
        }
    }

    public Map getCache() {
        return new TreeMap(this.mCache);
    }

    public void setConnectionOwner(boolean bl) {
        this.amIConnectionOwner = bl;
    }

    public Map close() throws CacheException {
        --this.mRefCount;
        if (!ConnectionUtils.processCloseDatabase(this, this.mRefCount, this.mProcess)) {
            return new TreeMap(this.mCache);
        }
        if (!this.isConnectionOpen) {
            throw new CacheException("Attempt to close already closed Database " + this.toString());
        }
        if (this.mDetachedbjectsManager != null) {
            this.mDetachedbjectsManager.close();
        }
        this.closeAllObjects(false);
        this.onClose();
        this.isConnectionOpen = false;
        this.mAdapter.close(this.amIConnectionOwner);
        databases.remove(this.mAdapter.getConnection());
        return this.mCache;
    }

    protected abstract void onClose();

    public synchronized void closeAllObjects(boolean bl) {
        if (this.mDetachedbjectsManager != null) {
            this.mDetachedbjectsManager.clear();
        }
        if (this.mCache == null) {
            return;
        }
        Map map = this.mCache;
        this.mCache = null;
        for (Object v : map.values()) {
            if (v == null || !(v instanceof QuickPersistentObject)) continue;
            ((QuickPersistentObject)v).cleanup();
        }
        map.clear();
        this.mCache = map;
    }

    public void closeAllObjects() throws CacheException {
        this.closeAllObjects(false);
    }

    public void flush() {
    }

    public void setProfileOn(int n) {
        this.myAdapter().setProfileOn(n);
    }

    public void resetProfile(int n) throws CacheException {
        this.myAdapter().resetProfile(n);
    }

    public void setProfileOff(int n) {
        this.myAdapter().setProfileOff(n);
    }

    public int getNumberOfOpenObjects() {
        if (this.mCache != null) {
            return this.mCache.size();
        }
        return 0;
    }

    public long getServerTime() {
        return this.myAdapter().getServerTime();
    }

    public int getNumberOfServerCalls() {
        return this.myAdapter().getNumberServerCalls();
    }

    public long getServerTime(int n) {
        return this.myAdapter().getServerTime(n);
    }

    public int getNumberOfServerCalls(int n) {
        return this.myAdapter().getNumberServerCalls(n);
    }

    public void printStatistics(PrintStream printStream) {
        System.out.println("Not yet implemented feature.");
    }

    public void printStatistics() {
        this.printStatistics(System.out);
    }

    public ObjectServerInfo getServerInfo() {
        try {
            return (ObjectServerInfo)this.mInfo.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public int parseStatus(StatusCode statusCode) throws CacheException {
        if (!statusCode.isError()) {
            return statusCode.getCode();
        }
        return 0;
    }

    public int parseStatus(Dataholder dataholder) throws CacheException {
        StatusCode statusCode = dataholder.getStatusCode();
        if (statusCode.isError()) {
            throw new CacheException("Code: " + statusCode.getCode() + "; Text: " + statusCode.getText(), statusCode.getCode());
        }
        return statusCode.getCode();
    }

    public DatabaseUtilities utilities() {
        return new DatabaseUtilities(this);
    }

    public void transactionStart() throws CacheException {
        try {
            this.myConnection().setAutoCommit(false);
        }
        catch (SQLException sQLException) {
            throw new SystemError(sQLException, "Failed to set autocommit to false.");
        }
    }

    public void transactionCommit() throws CacheException {
        try {
            this.myConnection().commit();
            this.myConnection().setAutoCommit(true);
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException, "Failed to commit transaction.");
        }
    }

    public void transactionRollback() throws CacheException {
        try {
            this.myConnection().rollback();
            this.myConnection().setAutoCommit(true);
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException, "Failed to commit transaction.");
        }
    }

    public CacheClass getCacheClass(String string) throws CacheException {
        TableBasedClass tableBasedClass = (TableBasedClass)this.getCacheClassIfLoaded(string);
        if (tableBasedClass == null) {
            tableBasedClass = this.createQuickCacheClass(string, true);
        }
        return tableBasedClass;
    }

    public CacheClass getCacheClassByTableName(String string) throws CacheException {
        TableBasedClass tableBasedClass = (TableBasedClass)this.getCacheClassIfLoadedByTable(string);
        if (tableBasedClass == null) {
            tableBasedClass = this.createQuickCacheClassByTable(string, true);
        }
        return tableBasedClass;
    }

    protected abstract TableBasedClass createQuickCacheClass(String var1, boolean var2) throws CacheException;

    public CacheClass getCacheClassIfLoaded(String string) throws CacheException {
        CacheClass cacheClass = (CacheClass)this.mClassMap.get(string);
        return cacheClass;
    }

    public CacheClass getCacheClassIfLoadedByTable(String string) throws CacheException {
        CacheClass cacheClass = (CacheClass)this.mTableToClassMap.get(string);
        return cacheClass;
    }

    public void addClass(CacheClass cacheClass, String string) throws CacheException {
        if (string != null) {
            this.mReverseClassMap.put(string, cacheClass.getName());
        }
    }

    public void registerClass(CacheClass cacheClass) {
        this.mClassMap.put(cacheClass.getName(), cacheClass);
    }

    public void removeClass(CacheClass cacheClass) {
        this.mClassMap.remove(cacheClass.getName());
    }

    public void removeClass(String string) {
        this.mClassMap.remove(string);
    }

    public String getCacheClassName(String string) throws CacheException {
        return (String)this.mReverseClassMap.get(string);
    }

    public ClassLoader getClassLoader() {
        if (this.mClassLoader != null) {
            return this.mClassLoader;
        }
        return this.getClass().getClassLoader();
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.mClassLoader = classLoader;
    }

    public long getProcessNumber() {
        return this.mProcess;
    }

    protected final Object createSysList() {
        Object object = SysListProxy.createSysList(this.getConnectionInfo());
        return object;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof LightDatabase)) {
            return false;
        }
        LightDatabase lightDatabase = (LightDatabase)object;
        return this.myAdapter().equals(lightDatabase.myAdapter());
    }

    public String getConnectionString() {
        return this.mURL;
    }

    public void setConsoleOutput(PrintStream printStream) {
    }

    public boolean addListener(EventListener eventListener) {
        return false;
    }

    public boolean removeListener(EventListener eventListener) {
        return false;
    }

    public SysDatabase getLightDatabase() throws CacheException {
        return this;
    }

    protected final Connection myConnection() {
        return this.myAdapter().getConnection();
    }

    protected final DBAdapter myAdapter() {
        if (this.isConnectionOpen) {
            return this.mAdapter;
        }
        throw new RuntimeException("Database connection is not open.");
    }

    protected abstract boolean serverSupportsBulk();

    public void removeClassFromMap(String string) {
        this.mClassMap.remove(string);
    }

    protected abstract TableBasedClass createQuickCacheClass(ColumnBasedField var1) throws CacheException;

    protected abstract boolean commaSeparatedCollectionsInRS();

    public abstract TableBasedClass createQuickCacheClassByTable(String var1, boolean var2) throws CacheException;

    protected abstract class ResultSetIterator
    implements Iterator {
        private int mIdcol;
        private TableBasedClass mClass;
        protected ResultSet mRS;
        private Object mCur;
        boolean atEnd = false;

        public ResultSetIterator(ResultSet resultSet, TableBasedClass tableBasedClass, int n) {
            this.mRS = resultSet;
            this.mClass = tableBasedClass;
            this.mIdcol = n;
            this.mCur = null;
        }

        public boolean hasNext() {
            if (this.mCur != null) {
                return true;
            }
            try {
                return this.nextObject();
            }
            catch (Exception exception) {
                throw new RuntimeException("Fatal Error: " + exception.getMessage());
            }
        }

        public Object next() {
            if (this.mCur == null) {
                try {
                    if (!this.nextObject()) {
                        throw new NoSuchElementException();
                    }
                }
                catch (SQLException sQLException) {
                    throw new RuntimeException("Fatal Error: " + sQLException.getMessage());
                }
                catch (CacheException cacheException) {
                    throw new RuntimeException("Fatal Error: " + cacheException.getMessage());
                }
            }
            Object object = this.mCur;
            this.mCur = null;
            return object;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        private boolean nextObject() throws SQLException, CacheException {
            if (this.atEnd) {
                return false;
            }
            if (!this.mRS.next()) {
                this.atEnd = true;
                this.mRS.close();
                return false;
            }
            Object object = this.getWire();
            String string = SysListProxy.getString(object, this.mIdcol);
            SQLRow sQLRow = new SQLRow(string, this.mClass);
            QuickPersistentObject quickPersistentObject = null;
            if (LightDatabase.this.mCache != null) {
                quickPersistentObject = (QuickPersistentObject)LightDatabase.this.mCache.get(sQLRow);
            }
            if (quickPersistentObject == null) {
                int n = 7506;
                quickPersistentObject = LightDatabase.this.createCacheObject(object, this.mClass, sQLRow, this.mClass.getName(), string, 1, n);
            } else if (Logger.getDebugCache()) {
                Logger.out.println("Skipping object " + sQLRow.id);
            }
            this.mCur = quickPersistentObject.newJavaInstance(true);
            return true;
        }

        protected abstract Object getWire() throws SQLException;
    }

    private static class SQLRow
    implements Comparable {
        public String schema;
        public String table;
        private String mClassName;
        private String id;
        private int iId = 0;

        public SQLRow(LightDatabase lightDatabase, Oid oid) throws CacheException {
            this(lightDatabase.getCacheClass(oid.getClassName()));
            this.setupId(oid.getId().toString());
        }

        public SQLRow(byte[] byArray, CacheClass cacheClass, LightDatabase lightDatabase) throws CacheException {
            try {
                Object object = SysListProxy.createSysList(byArray, false, lightDatabase.getConnectionInfo());
                this.setupId(SysListProxy.getString(object, 0));
                String string = SysListProxy.getString(object, 1);
                if (!(string == null || cacheClass != null && string.equals(cacheClass.getName()))) {
                    cacheClass = lightDatabase.getCacheClass(string);
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.mClassName = cacheClass.getName();
            this.setupTable(cacheClass.getFullSQLTableName());
        }

        public SQLRow(String string) {
            this.setupTable(string);
        }

        public SQLRow(CacheClass cacheClass) {
            this.mClassName = cacheClass.getName();
            this.setupTable(cacheClass.getFullSQLTableName());
        }

        public SQLRow(LightDatabase lightDatabase, String string, String string2) throws CacheException {
            CacheClass cacheClass = lightDatabase.getCacheClass(string2);
            if (cacheClass == null) {
                throw new InvalidClassException("Cache class " + string2 + " does not exist");
            }
            this.setupTable(cacheClass.getFullSQLTableName());
            this.setupId(string);
        }

        public SQLRow(String string, CacheClass cacheClass) {
            this.setupTable(cacheClass.getFullSQLTableName());
            this.setupId(string);
        }

        public String getId() {
            return this.id;
        }

        public String getClassName() {
            if (this.mClassName != null) {
                return this.mClassName;
            }
            return this.schema + "." + this.table;
        }

        private final void setupId(String string) {
            this.id = string;
            try {
                this.iId = Integer.parseInt(this.id);
            }
            catch (Exception exception) {
                this.iId = -1;
            }
        }

        private final void setupTable(String string) {
            int n = string.lastIndexOf(46);
            if (n < 0) {
                this.table = string;
                this.schema = "";
            } else {
                this.table = string.substring(n + 1);
                this.schema = string.substring(0, n);
            }
        }

        public String toString() {
            String string = this.schema + "." + this.table;
            if (this.id != null) {
                string = string + "[" + this.id.toString() + "]";
            }
            return string;
        }

        public boolean equals(Object object) {
            if (!(object instanceof SQLRow)) {
                return false;
            }
            SQLRow sQLRow = (SQLRow)object;
            if (this.id == null && sQLRow.id != null) {
                return false;
            }
            if (this.iId >= 0 && this.iId != sQLRow.iId) {
                return false;
            }
            if (this.id != null && !this.id.equals(sQLRow.id)) {
                return false;
            }
            if (this.table == null && sQLRow.table != null) {
                return false;
            }
            if (this.table != null && !this.table.equals(sQLRow.table)) {
                return false;
            }
            if (this.schema == null && sQLRow.schema != null) {
                return false;
            }
            return this.schema == null || this.schema.equals(sQLRow.schema);
        }

        public int hashCode() {
            String string = (this.table == null ? this.table : "") + (this.schema == null ? this.schema : "");
            int n = string.hashCode();
            if (this.iId > 0) {
                n += this.iId;
            } else if (this.id != null) {
                n += this.id.hashCode();
            }
            return n;
        }

        public int compareTo(Object object) {
            if (object instanceof SQLRow) {
                SQLRow sQLRow = (SQLRow)object;
                int n = this.getClassName().compareTo(sQLRow.getClassName());
                if (n != 0) {
                    return n;
                }
                if (this.id == null) {
                    if (sQLRow.id == null) {
                        return 0;
                    }
                    return 1;
                }
                return this.id.compareTo(sQLRow.id);
            }
            return this.toString().compareTo(object.toString());
        }
    }
}

