/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.config;

import com.opensymphony.xwork2.config.Configuration;
import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.config.ConfigurationProvider;
import com.opensymphony.xwork2.config.impl.DefaultConfiguration;
import com.opensymphony.xwork2.config.providers.XmlConfigurationProvider;
import com.opensymphony.xwork2.util.FileManager;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationManager {
    protected static final Log LOG = LogFactory.getLog(ConfigurationManager.class);
    protected Configuration configuration;
    protected Lock providerLock = new ReentrantLock();
    private List<ConfigurationProvider> configurationProviders = new CopyOnWriteArrayList<ConfigurationProvider>();
    protected String defaultFrameworkBeanName;

    public ConfigurationManager() {
        this("xwork");
    }

    public ConfigurationManager(String name) {
        this.defaultFrameworkBeanName = name;
    }

    public synchronized Configuration getConfiguration() {
        if (this.configuration == null) {
            this.setConfiguration(new DefaultConfiguration(this.defaultFrameworkBeanName));
            try {
                this.configuration.reload(this.getConfigurationProviders());
            }
            catch (ConfigurationException e) {
                this.setConfiguration(null);
                throw e;
            }
        } else {
            this.conditionalReload();
        }
        return this.configuration;
    }

    public synchronized void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ConfigurationProvider> getConfigurationProviders() {
        this.providerLock.lock();
        try {
            if (this.configurationProviders.size() == 0) {
                this.configurationProviders.add(new XmlConfigurationProvider("xwork.xml", true));
            }
            List<ConfigurationProvider> list = this.configurationProviders;
            return list;
        }
        finally {
            this.providerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfigurationProviders(List<ConfigurationProvider> configurationProviders) {
        this.providerLock.lock();
        try {
            this.configurationProviders = new CopyOnWriteArrayList<ConfigurationProvider>(configurationProviders);
        }
        finally {
            this.providerLock.unlock();
        }
    }

    public void addConfigurationProvider(ConfigurationProvider provider) {
        if (!this.configurationProviders.contains(provider)) {
            this.configurationProviders.add(provider);
        }
    }

    public void clearConfigurationProviders() {
        for (ConfigurationProvider configurationProvider : this.configurationProviders) {
            try {
                configurationProvider.destroy();
            }
            catch (Exception e) {
                LOG.warn((Object)("error while destroying configuration provider [" + configurationProvider + "]"), (Throwable)e);
            }
        }
        this.configurationProviders.clear();
    }

    public synchronized void destroyConfiguration() {
        this.clearConfigurationProviders();
        this.setConfigurationProviders(new CopyOnWriteArrayList<ConfigurationProvider>());
        if (this.configuration != null) {
            this.configuration.destroy();
        }
        this.configuration = null;
    }

    public synchronized void conditionalReload() {
        if (FileManager.isReloadingConfigs()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Checking ConfigurationProviders for reload.");
            }
            boolean reload = false;
            List<ConfigurationProvider> providers = this.getConfigurationProviders();
            for (ConfigurationProvider provider : providers) {
                if (!provider.needsReload()) continue;
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Detected configuration provider " + provider + " needs to be reloaded.  Reloading all providers."));
                }
                reload = true;
                break;
            }
            if (reload) {
                for (ConfigurationProvider configurationProvider : this.configurationProviders) {
                    try {
                        configurationProvider.destroy();
                    }
                    catch (Exception e) {
                        LOG.warn((Object)("error while destroying configuration provider [" + configurationProvider + "]"), (Throwable)e);
                    }
                }
                this.configuration.reload(providers);
            }
        }
    }

    public synchronized void reload() {
        this.getConfiguration().reload(this.getConfigurationProviders());
    }
}

