/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc3.tds;

import com.sybase.jdbc3.tds.DataFormat;
import com.sybase.jdbc3.tds.ParamFormatToken;
import com.sybase.jdbc3.tds.RowFormat2Token;
import com.sybase.jdbc3.tds.RowFormatToken;
import com.sybase.jdbc3.tds.SrvAcceptor;
import com.sybase.jdbc3.tds.SrvCapabilityToken;
import com.sybase.jdbc3.tds.SrvCurCloseToken;
import com.sybase.jdbc3.tds.SrvCurDeclare3Token;
import com.sybase.jdbc3.tds.SrvCurFetchToken;
import com.sybase.jdbc3.tds.SrvCurInfo3Token;
import com.sybase.jdbc3.tds.SrvCurInfoToken;
import com.sybase.jdbc3.tds.SrvCurOpenToken;
import com.sybase.jdbc3.tds.SrvCursor;
import com.sybase.jdbc3.tds.SrvDataFormat;
import com.sybase.jdbc3.tds.SrvDataInputStream;
import com.sybase.jdbc3.tds.SrvDbrpcToken;
import com.sybase.jdbc3.tds.SrvDoneToken;
import com.sybase.jdbc3.tds.SrvEedToken;
import com.sybase.jdbc3.tds.SrvEnvChangeToken;
import com.sybase.jdbc3.tds.SrvErrorToken;
import com.sybase.jdbc3.tds.SrvEventListener;
import com.sybase.jdbc3.tds.SrvFormatToken;
import com.sybase.jdbc3.tds.SrvJavaTypeFormatter;
import com.sybase.jdbc3.tds.SrvLanguageToken;
import com.sybase.jdbc3.tds.SrvLoginAckToken;
import com.sybase.jdbc3.tds.SrvLoginToken;
import com.sybase.jdbc3.tds.SrvLogoutToken;
import com.sybase.jdbc3.tds.SrvNotifier;
import com.sybase.jdbc3.tds.SrvParamFormat2Token;
import com.sybase.jdbc3.tds.SrvParamsToken;
import com.sybase.jdbc3.tds.SrvProtocolException;
import com.sybase.jdbc3.tds.SrvRequestListener;
import com.sybase.jdbc3.tds.SrvReturnStatusToken;
import com.sybase.jdbc3.tds.SrvRowDataFormat2;
import com.sybase.jdbc3.tds.SrvRowFormat2Token;
import com.sybase.jdbc3.tds.SrvRowFormatToken;
import com.sybase.jdbc3.tds.SrvRowToken;
import com.sybase.jdbc3.tds.SrvSQLTypeFormatter;
import com.sybase.jdbc3.tds.SrvSQLTypeFormatter2;
import com.sybase.jdbc3.tds.SrvSession;
import com.sybase.jdbc3.tds.SrvTypeException;
import com.sybase.jdbc3.tds.Token;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class SrvReceiver
implements SrvRequestListener,
Runnable {
    protected Hashtable _sessions = new Hashtable();
    protected Hashtable _regProcs = new Hashtable();
    protected Vector _acceptors = new Vector();
    private SrvNotifier _notifier = null;
    protected static int _nextCursorID = 0;
    protected String _server = null;
    private boolean _running = false;

    public SrvReceiver(String string) {
        this._server = string;
    }

    public SrvSession createSession(Socket socket) throws IOException {
        return this.startSession(new SrvSession(socket, socket.getInputStream(), socket.getOutputStream(), false, false));
    }

    public void registerAcceptor(SrvAcceptor srvAcceptor) {
        this._acceptors.addElement(srvAcceptor);
    }

    public SrvSession createSession(InputStream inputStream, OutputStream outputStream) throws IOException {
        return this.startSession(new SrvSession(inputStream, outputStream, false, false));
    }

    public SrvSession createSession(Socket socket, boolean bl, boolean bl2) throws IOException {
        return this.startSession(new SrvSession(socket, socket.getInputStream(), socket.getOutputStream(), bl, bl2));
    }

    public void connect(SrvSession srvSession, SrvLoginToken srvLoginToken) {
        this.handleLogin(srvSession, srvLoginToken.getUser(), srvLoginToken.getPassword(), srvLoginToken.getHost(), srvLoginToken.getLocale(), srvLoginToken.getPacketSize());
    }

    public void disconnect(SrvSession srvSession, SrvLogoutToken srvLogoutToken) {
        this.handleDisconnect(srvSession, srvLogoutToken);
        if (srvLogoutToken != null) {
            try {
                srvSession.send((Token)new SrvDoneToken(0, 0, 0));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Socket socket = srvSession.getSocket();
        srvSession.close();
        this.removeSession(srvSession);
        try {
            if (socket != null) {
                socket.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void language(SrvSession srvSession, SrvLanguageToken srvLanguageToken) {
        ParamFormatToken paramFormatToken = null;
        SrvJavaTypeFormatter srvJavaTypeFormatter = null;
        SrvParamsToken srvParamsToken = null;
        Object[] objectArray = new Object[]{};
        if (srvLanguageToken.hasParams()) {
            try {
                paramFormatToken = (ParamFormatToken)srvSession.receive();
                srvParamsToken = (SrvParamsToken)srvSession.receive();
            }
            catch (ClassCastException classCastException) {
                this.error(srvSession, new SrvProtocolException("Did not get PARAMFMT, PARAMFMT2, PARAMS tokens for LANGUAGE request"));
                return;
            }
            catch (IOException iOException) {
                this.error(srvSession, iOException);
                return;
            }
            try {
                srvJavaTypeFormatter = new SrvJavaTypeFormatter((SrvFormatToken)paramFormatToken, srvSession.getClientCapability());
                objectArray = srvJavaTypeFormatter.convertData((Token)srvParamsToken);
            }
            catch (IOException iOException) {
                this.error(srvSession, iOException);
                return;
            }
        }
        if (srvLanguageToken.getLanguage() == null) {
            try {
                this.sendMessage(srvSession, 32001, "Null command was issued. Please try again.", null, 0);
                this.sendDone(srvSession, -1, true, true, false);
            }
            catch (IOException iOException) {
                this.error(srvSession, iOException);
            }
        } else {
            this.handleLanguage(srvSession, srvLanguageToken.getLanguage().trim(), objectArray);
        }
    }

    public void rpc(SrvSession srvSession, SrvDbrpcToken srvDbrpcToken) {
        String string;
        SrvFormatToken srvFormatToken = null;
        SrvJavaTypeFormatter srvJavaTypeFormatter = null;
        SrvParamsToken srvParamsToken = null;
        Object[] objectArray = new Object[]{};
        if (srvDbrpcToken.hasParams()) {
            try {
                srvFormatToken = (SrvFormatToken)srvSession.receive();
                srvDbrpcToken._hasWidetableParams = srvFormatToken instanceof SrvParamFormat2Token;
                srvParamsToken = (SrvParamsToken)srvSession.receive();
            }
            catch (ClassCastException classCastException) {
                this.error(srvSession, new SrvProtocolException("Did not get PARAMFMT,PARAMFMT2,PARAMS tokens for RPC request"));
                return;
            }
            catch (IOException iOException) {
                this.error(srvSession, iOException);
                return;
            }
            try {
                srvJavaTypeFormatter = new SrvJavaTypeFormatter(srvFormatToken, srvSession.getClientCapability());
                objectArray = srvJavaTypeFormatter.convertData((Token)srvParamsToken);
            }
            catch (IOException iOException) {
                this.error(srvSession, iOException);
                return;
            }
        }
        if ((string = srvDbrpcToken.getName()).equals("sp_regwatch")) {
            this.addRegprocListener(srvSession, (String)objectArray[0], ((Short)objectArray[1]).intValue());
            try {
                this.sendRPCParams(srvSession, 0, null, null, true);
            }
            catch (Exception exception) {}
        } else if (string.equals("sp_regnowatch")) {
            boolean bl = this.removeRegprocListener(srvSession, (String)objectArray[0]);
            try {
                if (!bl) {
                    srvSession.send(this.createMessage(srvSession, 16126, "This connection was not registered for procedure " + objectArray[0], "Unknown", "sp_regnowatch", 0));
                }
                this.sendRPCParams(srvSession, 0, null, null, false);
                this.sendDone(srvSession, 0, !bl, true, true);
            }
            catch (Exception exception) {}
        } else {
            this.handleRPC(srvSession, srvDbrpcToken, objectArray);
            this.notifyRegprocListener(string, objectArray);
        }
    }

    public void bulk(SrvSession srvSession, SrvDataInputStream srvDataInputStream) {
        this.handleBulk(srvSession, srvDataInputStream);
    }

    public void attention(SrvSession srvSession) {
        this.handleAttention(srvSession);
    }

    public void error(SrvSession srvSession, IOException iOException) {
        this.handleError(srvSession, iOException);
    }

    public abstract void handleLogin(SrvSession var1, String var2, String var3, String var4, String var5, int var6);

    public abstract void handleLanguage(SrvSession var1, String var2, Object[] var3);

    protected void handleError(SrvSession srvSession, IOException iOException) {
        try {
            if (iOException instanceof EOFException || iOException instanceof SrvProtocolException) {
                srvSession.close();
                this.removeSession(srvSession);
            } else if (iOException instanceof SrvTypeException) {
                srvSession.send(this.createMessage(srvSession, 32000, "Server error: " + iOException, "Unknown", "", 0));
                srvSession.close();
                this.removeSession(srvSession);
            } else if (iOException instanceof IOException) {
                srvSession.close();
                this.removeSession(srvSession);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void declareCursor(SrvSession srvSession, SrvCurDeclare3Token srvCurDeclare3Token, boolean bl) {
        SrvCursor srvCursor = new SrvCursor();
        srvCursor.setName(srvCurDeclare3Token._cursorName);
        srvCursor.setOptions(srvCurDeclare3Token._options);
        srvCursor.setStatement(srvCurDeclare3Token._query);
        Object object = this;
        synchronized (object) {
            srvCursor.setID(++_nextCursorID);
        }
        this.buildCursorResultSet(srvSession, srvCursor);
        srvSession._cursors.put(new Integer(srvCursor.getID()), srvCursor);
        try {
            srvCursor.clearCurInfoStatus();
            srvCursor.buildYourOwnCurInfoStatus(-3);
            object = new SrvCurInfo3Token();
            ((SrvCurInfoToken)object).setCursor(srvCursor);
            ((SrvCurInfoToken)object).setCommand(3);
            srvSession.send((Token)object);
            if (!bl) {
                srvSession.sendDone(-1, false, true, false);
            } else {
                srvSession.sendDone(-1, false, false, false);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void processCurInfo(SrvSession srvSession, SrvCurInfoToken srvCurInfoToken, boolean bl) {
        SrvCursor srvCursor = srvCurInfoToken._curId == 0 ? this.retrieveCursor(srvSession, srvCurInfoToken._cursorName) : (SrvCursor)srvSession._cursors.get(new Integer(srvCurInfoToken._curId));
        if (srvCursor == null) {
            return;
        }
        switch (srvCurInfoToken._command) {
            case 1: {
                if (srvCurInfoToken._fetchSize <= 0) break;
                srvCursor.setFetchSize(srvCurInfoToken._fetchSize);
                this.reportCursorStatus(srvSession, srvCursor, srvCurInfoToken._command, bl);
                break;
            }
            case 2: {
                this.reportCursorStatus(srvSession, srvCursor, srvCurInfoToken._command, bl);
                break;
            }
        }
    }

    public void reportCursorStatus(SrvSession srvSession, SrvCursor srvCursor, int n, boolean bl) {
        try {
            srvCursor.buildYourOwnCurInfoStatus(n);
            SrvCurInfo3Token srvCurInfo3Token = new SrvCurInfo3Token();
            srvCurInfo3Token.setCursor(srvCursor);
            srvCurInfo3Token.setCommand(3);
            srvSession.send((Token)srvCurInfo3Token);
            if (!bl) {
                srvSession.sendDone(-1, false, true, false);
            } else {
                srvSession.sendDone(-1, false, false, false);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void openCursor(SrvSession srvSession, SrvCurOpenToken srvCurOpenToken, boolean bl) {
        try {
            SrvCursor srvCursor = srvCurOpenToken._curId == 0 ? this.retrieveCursor(srvSession, srvCurOpenToken._cursorName) : (SrvCursor)srvSession._cursors.get(new Integer(srvCurOpenToken._curId));
            if (srvCursor == null) {
                return;
            }
            srvSession.send((Token)srvCursor.getRowFormat());
            SrvCurInfo3Token srvCurInfo3Token = new SrvCurInfo3Token();
            srvCurInfo3Token.setCursor(srvCursor);
            srvCursor.setState(1);
            srvCursor.buildYourOwnCurInfoStatus(2);
            srvCurInfo3Token.setCommand(3);
            srvSession.send((Token)srvCurInfo3Token);
            if (!bl) {
                srvSession.sendDone(-1, false, true, false);
            } else {
                srvSession.sendDone(-1, false, false, false);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void closeCursor(SrvSession srvSession, SrvCurCloseToken srvCurCloseToken) {
        SrvCursor srvCursor = srvCurCloseToken._curId == 0 ? this.retrieveCursor(srvSession, srvCurCloseToken._cursorName) : (SrvCursor)srvSession._cursors.get(new Integer(srvCurCloseToken._curId));
        if (srvCursor == null) {
            return;
        }
        srvCursor.setState(2);
        try {
            SrvCurInfo3Token srvCurInfo3Token = new SrvCurInfo3Token();
            srvCursor.buildYourOwnCurInfoStatus(2);
            srvCurInfo3Token.setCursor(srvCursor);
            srvCurInfo3Token.setCommand(3);
            srvSession.send((Token)srvCurInfo3Token);
            if ((srvCurCloseToken._options & 1) != 0) {
                srvSession._cursors.remove(new Integer(srvCursor.getID()));
                srvCursor.setState(3);
                srvCursor.buildYourOwnCurInfoStatus(2);
                srvCurInfo3Token.setCursor(srvCursor);
                srvCurInfo3Token.setCommand(3);
                srvSession.send((Token)srvCurInfo3Token);
            }
            srvSession.sendDone(0, false, true, false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void cursorFetch(SrvSession srvSession, SrvCurFetchToken srvCurFetchToken) {
        SrvCursor srvCursor = srvCurFetchToken._curId == 0 ? this.retrieveCursor(srvSession, srvCurFetchToken._cursorName) : (SrvCursor)srvSession._cursors.get(new Integer(srvCurFetchToken._curId));
        if (srvCursor == null) {
            return;
        }
        srvCursor.fetchRows(srvSession, srvCurFetchToken);
    }

    protected SrvCursor retrieveCursor(SrvSession srvSession, String string) {
        SrvCursor srvCursor = null;
        boolean bl = false;
        Object object = srvSession._cursors.keys();
        while (object.hasMoreElements()) {
            Integer n = (Integer)object.nextElement();
            srvCursor = (SrvCursor)srvSession._cursors.get(n);
            if (!string.equals(srvCursor.getName())) continue;
            bl = true;
            break;
        }
        if (!bl) {
            try {
                object = "No cursor found with name " + string;
                this.sendMessage(srvSession, 32000, (String)object, null, 1);
                this.sendDone(srvSession, -1, true, true, true);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return srvCursor;
    }

    public abstract void buildCursorResultSet(SrvSession var1, SrvCursor var2);

    public abstract void handleRPC(SrvSession var1, SrvDbrpcToken var2, Object[] var3);

    public abstract void handleDisconnect(SrvSession var1, SrvLogoutToken var2);

    public abstract void handleBulk(SrvSession var1, SrvDataInputStream var2);

    public abstract void handleAttention(SrvSession var1);

    protected void sendLogin(SrvSession srvSession, SrvCapabilityToken srvCapabilityToken, String string, boolean bl, int n) throws IOException {
        byte[] byArray = new byte[]{1, 1, 0, 0};
        if (srvCapabilityToken == null) {
            srvCapabilityToken = srvSession.getClientCapability();
        }
        int n2 = 0;
        if (bl) {
            SrvEnvChangeToken srvEnvChangeToken = this.makeEnvChangeToken(n);
            srvSession.send((Token)srvEnvChangeToken);
            if (srvSession._encodingChanged) {
                srvEnvChangeToken = new SrvEnvChangeToken();
                srvEnvChangeToken.addVariable(3, "", srvSession.getCharset());
                srvSession.send((Token)srvEnvChangeToken);
            }
            srvSession.send((Token)new SrvLoginAckToken(5, string, byArray));
            srvSession.send((Token)srvCapabilityToken);
        } else {
            srvSession.send((Token)new SrvLoginAckToken(6, string, byArray));
            n2 = 2;
        }
        srvSession.send((Token)new SrvDoneToken(n2, 0, 0));
    }

    public int sendResults(SrvSession srvSession, String[] stringArray, Object[][] objectArray) throws IOException, SrvTypeException, SQLException {
        return this.sendResults(srvSession, stringArray, objectArray, null);
    }

    public int sendResults(SrvSession srvSession, String[] stringArray, Object[][] objectArray, String[] stringArray2) throws IOException, SrvTypeException, SQLException {
        int n;
        SrvFormatToken srvFormatToken = null;
        SrvCapabilityToken srvCapabilityToken = srvSession.getClientCapability();
        SrvJavaTypeFormatter srvJavaTypeFormatter = null;
        if (!srvCapabilityToken._respCaps.get(45)) {
            srvFormatToken = new SrvRowFormat2Token();
            srvJavaTypeFormatter = new SrvJavaTypeFormatter(srvFormatToken, srvCapabilityToken);
        } else {
            srvFormatToken = new SrvRowFormatToken();
            srvJavaTypeFormatter = new SrvJavaTypeFormatter((SrvRowFormatToken)srvFormatToken, srvCapabilityToken);
        }
        if (stringArray != null && stringArray.length != objectArray[0].length) {
            throw new SrvTypeException("Number of names do not match number of data elements in results send");
        }
        if (stringArray2 != null && stringArray2.length != objectArray[0].length) {
            throw new SrvTypeException("Number of locales do not match number of data elements in results send");
        }
        for (int i = 0; i < objectArray[0].length; ++i) {
            n = 0;
            if (objectArray[0][i] instanceof String) {
                n = this.getMaxCharLength(objectArray, i);
            }
            srvJavaTypeFormatter.addFormat(objectArray[0][i], this.checkNullValue(stringArray, i), 0, n, this.checkNullValue(stringArray2, i));
        }
        srvSession.send((Token)srvFormatToken);
        SrvRowToken srvRowToken = new SrvRowToken();
        for (n = 0; n < objectArray.length; ++n) {
            srvJavaTypeFormatter.convertData((Token)srvRowToken, objectArray[n]);
            srvSession.send((Token)srvRowToken);
        }
        return objectArray.length;
    }

    public int sendResults(SrvSession srvSession, SrvDataFormat[] srvDataFormatArray, Object[][] objectArray) throws IOException, SrvTypeException, SQLException {
        SrvRowFormatToken srvRowFormatToken = null;
        SrvCapabilityToken srvCapabilityToken = srvSession.getClientCapability();
        srvRowFormatToken = new SrvRowFormatToken();
        SrvJavaTypeFormatter srvJavaTypeFormatter = new SrvJavaTypeFormatter(srvRowFormatToken, srvCapabilityToken);
        if (srvDataFormatArray.length != objectArray[0].length) {
            throw new SrvTypeException("Number of SrvDataFormat do not match number of data elements in results send");
        }
        for (int i = 0; i < objectArray[0].length; ++i) {
            srvJavaTypeFormatter.addFormat(srvDataFormatArray[i]);
        }
        srvSession.send((Token)srvRowFormatToken);
        SrvRowToken srvRowToken = new SrvRowToken();
        for (int i = 0; i < objectArray.length; ++i) {
            srvJavaTypeFormatter.convertData((Token)srvRowToken, objectArray[i]);
            srvSession.send((Token)srvRowToken);
        }
        return objectArray.length;
    }

    public int sendResults(SrvSession srvSession, DataFormat[] dataFormatArray, Object[][] objectArray) throws IOException, SrvTypeException, SQLException {
        SrvFormatToken srvFormatToken = null;
        SrvCapabilityToken srvCapabilityToken = srvSession.getClientCapability();
        srvFormatToken = !srvCapabilityToken._respCaps.get(45) ? (dataFormatArray[0] instanceof SrvRowDataFormat2 ? new SrvRowFormat2Token() : new SrvRowFormatToken()) : new SrvRowFormatToken();
        SrvJavaTypeFormatter srvJavaTypeFormatter = new SrvJavaTypeFormatter(srvFormatToken, srvCapabilityToken);
        if (dataFormatArray.length != objectArray[0].length) {
            throw new SrvTypeException("Number of SrvDataFormat do not match number of data elements in results send");
        }
        for (int i = 0; i < objectArray[0].length; ++i) {
            srvJavaTypeFormatter.addFormat(dataFormatArray[i]);
        }
        srvSession.send((Token)srvFormatToken);
        SrvRowToken srvRowToken = new SrvRowToken();
        for (int i = 0; i < objectArray.length; ++i) {
            srvJavaTypeFormatter.convertData((Token)srvRowToken, objectArray[i]);
            srvSession.send((Token)srvRowToken);
        }
        return objectArray.length;
    }

    public int sendResults(SrvSession srvSession, ResultSet resultSet) throws IOException, SrvTypeException, SQLException {
        return this.sendResults(srvSession, this.buildDataFormat(srvSession, resultSet), resultSet);
    }

    public int sendResults(SrvSession srvSession, SrvDataFormat[] srvDataFormatArray, ResultSet resultSet) throws IOException, SrvTypeException, SQLException {
        SrvSQLTypeFormatter srvSQLTypeFormatter;
        SrvFormatToken srvFormatToken;
        SrvCapabilityToken srvCapabilityToken = srvSession.getClientCapability();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        if (resultSetMetaData instanceof RowFormat2Token && !srvCapabilityToken._respCaps.get(45)) {
            srvFormatToken = new SrvRowFormat2Token();
            srvSQLTypeFormatter = new SrvSQLTypeFormatter2(srvFormatToken, srvSession.getClientCapability());
        } else {
            srvFormatToken = new SrvRowFormatToken();
            srvSQLTypeFormatter = new SrvSQLTypeFormatter(srvFormatToken, srvSession.getClientCapability());
        }
        for (int i = 0; i < srvDataFormatArray.length; ++i) {
            srvSQLTypeFormatter.addFormat(srvDataFormatArray[i]);
        }
        return this.sendResults(srvSession, srvSQLTypeFormatter, (RowFormatToken)srvFormatToken, resultSet);
    }

    public int sendResults(SrvSession srvSession, DataFormat[] dataFormatArray, ResultSet resultSet) throws IOException, SrvTypeException, SQLException {
        SrvSQLTypeFormatter srvSQLTypeFormatter;
        SrvFormatToken srvFormatToken;
        SrvCapabilityToken srvCapabilityToken = srvSession.getClientCapability();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        if (resultSetMetaData instanceof RowFormat2Token && !srvCapabilityToken._respCaps.get(45)) {
            srvFormatToken = new SrvRowFormat2Token();
            srvSQLTypeFormatter = new SrvSQLTypeFormatter2(srvFormatToken, srvSession.getClientCapability());
        } else {
            srvFormatToken = new SrvRowFormatToken();
            srvSQLTypeFormatter = new SrvSQLTypeFormatter(srvFormatToken, srvSession.getClientCapability());
        }
        for (int i = 0; i < dataFormatArray.length; ++i) {
            srvSQLTypeFormatter.addFormat(dataFormatArray[i]);
        }
        return this.sendResults(srvSession, srvSQLTypeFormatter, (RowFormatToken)srvFormatToken, resultSet);
    }

    public int sendResults(SrvSession srvSession, SrvFormatToken srvFormatToken, Object[][] objectArray) throws IOException, SrvTypeException, SQLException {
        Object var4_4 = null;
        SrvCapabilityToken srvCapabilityToken = srvSession.getClientCapability();
        SrvJavaTypeFormatter srvJavaTypeFormatter = null;
        if (srvCapabilityToken._respCaps.get(45) && srvFormatToken instanceof SrvRowFormat2Token) {
            throw new SrvTypeException("Attempt to send a SrvRowFormat2 token when widetable has been disabled.");
        }
        srvJavaTypeFormatter = srvFormatToken instanceof SrvRowFormat2Token ? new SrvJavaTypeFormatter((SrvRowFormat2Token)srvFormatToken, srvCapabilityToken) : new SrvJavaTypeFormatter((SrvRowFormatToken)srvFormatToken, srvCapabilityToken);
        if (srvFormatToken != null && srvFormatToken.getFormatCount() != objectArray[0].length) {
            throw new SrvTypeException("Number of names do not match number of data elements in results send");
        }
        srvSession.send((Token)srvFormatToken);
        SrvRowToken srvRowToken = new SrvRowToken();
        for (int i = 0; i < objectArray.length; ++i) {
            srvJavaTypeFormatter.convertData((Token)srvRowToken, objectArray[i]);
            srvSession.send((Token)srvRowToken);
        }
        return objectArray.length;
    }

    public void sendParams(SrvSession srvSession, Object[] objectArray, Object[] objectArray2, int n) throws IOException {
        srvSession.sendParams(objectArray, objectArray2, n);
    }

    public void sendRPCParams(SrvSession srvSession, int n, Object[] objectArray, Object[] objectArray2, boolean bl) throws IOException {
        srvSession.send(new SrvReturnStatusToken(n));
        if (objectArray2 != null) {
            this.sendParams(srvSession, objectArray, objectArray2, 1);
            this.sendDone(srvSession, 1, false, false, true);
        }
        this.sendDone(srvSession, 0, false, bl, true);
    }

    public void sendMessage(SrvSession srvSession, int n, String string, String string2, int n2) throws IOException {
        srvSession.send(this.createMessage(srvSession, n, string, this._server, string2, n2));
    }

    public Token createMessage(SrvSession srvSession, int n, String string, String string2, String string3, int n2) {
        if (srvSession.getClientCapability()._respCaps.get(2)) {
            return new SrvErrorToken(n, 0, 20, string, string2, string3, 1);
        }
        return new SrvEedToken(n, 0, 20, "UNKWN", 0, string, string2, string3, 1);
    }

    public DataFormat[] buildDataFormat(SrvSession srvSession, ResultSet resultSet) throws SrvTypeException, SQLException, IOException {
        SrvSQLTypeFormatter srvSQLTypeFormatter;
        SrvCapabilityToken srvCapabilityToken = srvSession.getClientCapability();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        if (resultSetMetaData instanceof RowFormat2Token && !srvCapabilityToken._respCaps.get(45)) {
            SrvRowFormat2Token srvRowFormat2Token = new SrvRowFormat2Token();
            srvSQLTypeFormatter = new SrvSQLTypeFormatter2(srvRowFormat2Token, srvSession.getClientCapability());
        } else {
            SrvRowFormatToken srvRowFormatToken = new SrvRowFormatToken();
            srvSQLTypeFormatter = new SrvSQLTypeFormatter(srvRowFormatToken, srvSession.getClientCapability());
        }
        return srvSQLTypeFormatter.buildDataFormat(resultSet);
    }

    protected int getMaxCharLength(Object[][] objectArray, int n) {
        int n2 = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            String string = (String)objectArray[i][n];
            if (n2 >= string.length()) continue;
            n2 = string.length();
        }
        return n2 + 1;
    }

    protected void sendDone(SrvSession srvSession, int n, boolean bl, boolean bl2, boolean bl3) throws IOException {
        srvSession.sendDone(n, bl, bl2, bl3);
    }

    protected SrvSession startSession(SrvSession srvSession) {
        srvSession.addSrvRequestListener(this);
        Thread thread = new Thread(srvSession);
        Thread thread2 = this._sessions.put(srvSession, thread);
        thread.start();
        return srvSession;
    }

    protected Thread getSession(SrvSession srvSession) {
        return (Thread)this._sessions.get(srvSession);
    }

    protected void removeSession(SrvSession srvSession) {
        srvSession.removeSrvRequestListener(this);
        srvSession.close();
        Thread thread = this.getSession(srvSession);
        Object v = this._sessions.remove(srvSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addRegprocListener(SrvSession srvSession, String string, int n) {
        Hashtable hashtable = null;
        Object object = this._regProcs;
        synchronized (object) {
            if (this._notifier == null) {
                this._notifier = new SrvNotifier();
                this._notifier.start();
            }
            if ((hashtable = (Hashtable)this._regProcs.get(string)) == null) {
                hashtable = new Hashtable();
                this._regProcs.put(string, hashtable);
            }
        }
        object = (SrvEventListener)hashtable.get(srvSession);
        if (object != null) {
            ((SrvEventListener)object)._options = n;
            return;
        }
        object = new SrvEventListener(srvSession, n, hashtable);
    }

    protected boolean removeRegprocListener(SrvSession srvSession, String string) {
        Hashtable hashtable = (Hashtable)this._regProcs.get(string);
        if (hashtable == null) {
            return false;
        }
        SrvEventListener srvEventListener = (SrvEventListener)hashtable.get(srvSession);
        if (srvEventListener != null) {
            srvEventListener.close();
            return true;
        }
        return false;
    }

    protected void notifyRegprocListener(String string, Object[] objectArray) {
        Hashtable hashtable = (Hashtable)this._regProcs.get(string);
        if (hashtable == null || hashtable.isEmpty()) {
            return;
        }
        this._notifier.queueNotifications(hashtable, string, objectArray);
    }

    protected void passthruResults(SrvSession srvSession, Statement statement, String string) throws IOException, SQLException {
        boolean bl = string == null ? ((PreparedStatement)statement).execute() : statement.execute(string);
        int n = 0;
        int n2 = 0;
        int n3 = -2;
        do {
            if (bl) {
                this.sendDone(srvSession, this.sendResults(srvSession, statement.getResultSet()), false, false, true);
                n3 = n2;
            } else {
                n = statement.getUpdateCount();
                if (n2 == n3 + 1) {
                    this.sendDone(srvSession, -1, false, false, true);
                } else {
                    this.sendDone(srvSession, n, false, false, true);
                }
            }
            bl = statement.getMoreResults();
            ++n2;
        } while (bl || n != -1);
        this.sendDone(srvSession, -1, false, true, false);
    }

    private int sendResults(SrvSession srvSession, SrvSQLTypeFormatter srvSQLTypeFormatter, RowFormatToken rowFormatToken, ResultSet resultSet) throws IOException, SQLException {
        int n = resultSet.getMetaData().getColumnCount();
        if (n != ((SrvFormatToken)rowFormatToken).getFormatCount()) {
            throw new SrvTypeException("Number of SrvDataFormat do not match number of data elements in results send");
        }
        srvSession.send((Token)rowFormatToken);
        int n2 = 0;
        try {
            while (resultSet.next()) {
                SrvRowToken srvRowToken = new SrvRowToken();
                srvSQLTypeFormatter.convertData((Token)srvRowToken, resultSet);
                srvSession.send((Token)srvRowToken);
                ++n2;
            }
        }
        catch (SQLException sQLException) {
            throw new SrvProtocolException("SQL error on next row fetch: " + sQLException);
        }
        return n2;
    }

    private SrvEnvChangeToken makeEnvChangeToken(int n) {
        String string = new Integer(n).toString();
        SrvEnvChangeToken srvEnvChangeToken = new SrvEnvChangeToken();
        srvEnvChangeToken.addVariable(4, "", string);
        return srvEnvChangeToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this._running = true;
        while (this._running) {
            try {
                SrvReceiver srvReceiver = this;
                synchronized (srvReceiver) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public synchronized void shutdown() {
        Runnable runnable;
        Enumeration<Object> enumeration = this._acceptors.elements();
        while (enumeration.hasMoreElements()) {
            runnable = (SrvAcceptor)enumeration.nextElement();
            ((SrvAcceptor)runnable).shutdown();
            try {
                ((Thread)runnable).join();
            }
            catch (InterruptedException interruptedException) {}
        }
        enumeration = this._sessions.keys();
        while (enumeration.hasMoreElements()) {
            runnable = (SrvSession)enumeration.nextElement();
            Thread thread = (Thread)this._sessions.get(runnable);
            ((SrvSession)runnable).close();
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        this._running = false;
        this.notifyAll();
    }

    private String checkNullValue(String[] stringArray, int n) {
        if (stringArray == null) {
            return null;
        }
        return stringArray[n];
    }
}

