/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.packet.DataPart;
import com.sap.dbtech.jdbc.translators.InputStreamFilter;
import com.sap.dbtech.util.JoinStream;
import com.sap.dbtech.util.StructuredMem;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

public class Putval {
    private byte[] descriptor;
    private byte[] sourceBytes;
    protected StructuredMem descriptorMark;
    private InputStream stream;
    protected StructuredMem requestedData = null;
    protected int requestedLen;
    private int bufpos;

    Putval(InputStream inputStream, int n, int n2) {
        this.stream = n >= 0 ? new InputStreamFilter(inputStream, n) : inputStream;
        this.bufpos = n2;
    }

    Putval(byte[] byArray, int n) {
        this.stream = new ByteArrayInputStream(byArray);
        this.sourceBytes = byArray;
        this.bufpos = n;
    }

    Object cloneForBatch() {
        if (this.sourceBytes == null) {
            return this;
        }
        return new Putval(this.sourceBytes, this.bufpos);
    }

    protected Putval(int n) {
        this.bufpos = n;
        this.stream = null;
    }

    public boolean atEnd() {
        return this.stream == null;
    }

    private byte[] newDescriptor() {
        byte[] byArray = new byte[40];
        return byArray;
    }

    public void putDescriptor(DataPart dataPart, int n) {
        if (this.descriptor == null) {
            this.descriptor = this.newDescriptor();
        }
        this.descriptorMark = dataPart.putDescriptor(n, this.descriptor);
    }

    public void setDescriptor(byte[] byArray) {
        this.descriptor = byArray;
    }

    public void markErrorStream() {
        this.descriptorMark.putInt1(8, 27);
        this.descriptorMark.putInt4(0, 32);
        this.descriptorMark.putInt4(0, 36);
        try {
            this.stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.stream = null;
    }

    public void transferStream(DataPart dataPart) throws SQLException {
        if (this.atEnd()) {
            dataPart.markEmptyStream(this.descriptorMark);
        } else {
            boolean bl = dataPart.fillWithStream(this.stream, this.descriptorMark, this);
            if (bl) {
                try {
                    this.stream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.stream = null;
            }
        }
    }

    public void transferStream(DataPart dataPart, int n) throws SQLException {
        this.transferStream(dataPart);
        this.descriptorMark.putInt2(n, 28);
    }

    public String toString() {
        return "<Putval " + this.stream + ">";
    }

    public void markAsLast(DataPart dataPart) {
        if (dataPart.size() - dataPart.getExtent() - 8 - 40 - 1 < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n = dataPart.getExtent();
        this.putDescriptor(dataPart, n);
        dataPart.addArg(n, 41);
        this.descriptorMark.putInt1(5, 27);
    }

    public void markRequestedChunk(StructuredMem structuredMem, int n) {
        this.requestedData = structuredMem;
        this.requestedLen = n;
    }

    public void reset() {
        if (this.requestedData != null) {
            byte[] byArray = this.requestedData.getBytes(0, this.requestedLen);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            this.stream = this.stream == null ? byteArrayInputStream : new JoinStream(new InputStream[]{byteArrayInputStream, this.stream});
            this.requestedData = null;
        }
    }

    public final int getBufpos() {
        return this.bufpos;
    }
}

