/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.classes;

import com.intersys.cache.CacheEvent;
import com.intersys.cache.CacheEventListener;
import com.intersys.cache.CacheObject;
import com.intersys.cache.Dataholder;
import com.intersys.classes.SysAbstractArray;
import com.intersys.jdbc.SysListProxy;
import com.intersys.objects.CacheException;
import com.intersys.objects.CacheServerSensitive;
import com.intersys.objects.StringHolder;
import com.intersys.objects.SystemError;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

abstract class ArrayBuffer
implements CacheServerSensitive,
CacheEventListener {
    private static int FORWARD = 1;
    private static int BACKWARD = -1;
    private static int DEFAULT_BUFFER_SIZE = 10;
    protected int mBufferSize;
    private int currentSize = 0;
    private int mArraySize = -1;
    private boolean mAutoLoad = true;
    private boolean mRegistered = false;
    private boolean mCached = false;
    private boolean headLoaded = false;
    private boolean tailLoaded = false;
    private Object mSeqBuffer;
    private Map mDirBuffer;
    protected CacheObject mArray;

    public ArrayBuffer(SysAbstractArray sysAbstractArray, int n) throws CacheException {
        this.mArray = sysAbstractArray.mInternal;
        this.mBufferSize = n;
        this.mDirBuffer = new HashMap(this.mBufferSize);
        if (this.mBufferSize >= 32768) {
            this.mAutoLoad = true;
        }
    }

    public ArrayBuffer(SysAbstractArray sysAbstractArray) throws CacheException {
        this(sysAbstractArray, DEFAULT_BUFFER_SIZE);
    }

    public int getBufferSize() {
        return this.mBufferSize;
    }

    public static int getDefaultBufferSize() {
        return DEFAULT_BUFFER_SIZE;
    }

    public static void setDefaultBufferSize(int n) {
        DEFAULT_BUFFER_SIZE = n;
    }

    public boolean getAutoLoad() {
        return this.mAutoLoad;
    }

    public void setAutoLoad(boolean bl) {
        this.mAutoLoad = bl;
    }

    private Integer dbCount() throws CacheException {
        Dataholder[] dataholderArray = new Dataholder[]{};
        Dataholder dataholder = this.mArray.runInstanceMethod("Count", dataholderArray, 0);
        return dataholder.getInteger();
    }

    public int count() throws CacheException {
        if (this.mBufferSize <= 1) {
            return -1;
        }
        if (this.mArraySize >= 0) {
            return this.mArraySize;
        }
        Integer n = this.dbCount();
        if (n == null) {
            throw new CacheException("Can not determine size of array");
        }
        this.mArraySize = n;
        if (!this.mRegistered) {
            this.register();
        }
        return this.mArraySize;
    }

    public Dataholder getAt(String string) throws CacheException {
        if (this.mBufferSize <= 1) {
            return null;
        }
        if (this.mDirBuffer.containsKey(string)) {
            return ((ValueIndexPair)this.mDirBuffer.get((Object)string)).value;
        }
        if (this.mCached && this.mBufferSize >= this.count()) {
            this.load(null, FORWARD);
            return this.getFromDirBuffer(string);
        }
        return null;
    }

    private Boolean dbIsDefined(String string) throws CacheException {
        Dataholder[] dataholderArray = new Dataholder[]{new Dataholder(string)};
        Dataholder dataholder = this.mArray.runInstanceMethod("IsDefined", dataholderArray, 0);
        return dataholder.getBoolean();
    }

    public Boolean _isDefined(String string) throws CacheException {
        if (this.mBufferSize <= 1) {
            return this.dbIsDefined(string);
        }
        if (this.mDirBuffer.containsKey(string)) {
            return new Boolean(true);
        }
        if (this.mCached && this.mBufferSize >= this.count()) {
            this.load(null, FORWARD);
            return new Boolean(this.mDirBuffer.containsKey(string));
        }
        return this.dbIsDefined(string);
    }

    public Dataholder getNext(StringHolder stringHolder) throws CacheException {
        int n;
        if (this.mBufferSize <= 1) {
            return null;
        }
        String string = stringHolder.value;
        if (string != null && !this.mDirBuffer.containsKey(string)) {
            if (this.mAutoLoad) {
                this.load(string, FORWARD);
            } else if (this.mBufferSize >= this.count()) {
                this.load(null, FORWARD);
            } else {
                return null;
            }
        }
        if ((n = this.indexFromKey(string, FORWARD)) <= this.currentSize) {
            return this.getFromBufferAtIndex(n, stringHolder);
        }
        if (n > this.currentSize && this.currentSize >= this.count()) {
            stringHolder.value = null;
            return new Dataholder("");
        }
        this.load(string, FORWARD);
        if (this.currentSize == 0 || this.currentSize == 1 && string != null) {
            stringHolder.value = null;
            return new Dataholder("");
        }
        return this.getNext(stringHolder);
    }

    private String dbNext(String string) throws CacheException {
        Dataholder[] dataholderArray = new Dataholder[]{new Dataholder(string)};
        Dataholder dataholder = this.mArray.runInstanceMethod("Next", dataholderArray, 0);
        return dataholder.getString();
    }

    public String _next(String string) throws CacheException {
        int n;
        if (this.mBufferSize <= 1) {
            return this.dbNext(string);
        }
        if (string != null && !this.mDirBuffer.containsKey(string)) {
            if (this.mAutoLoad) {
                this.load(string, FORWARD);
            } else if (this.mBufferSize >= this.count()) {
                this.load(null, FORWARD);
            } else {
                return this.dbNext(string);
            }
        }
        if ((n = this.indexFromKey(string, FORWARD)) <= this.currentSize) {
            try {
                return SysListProxy.getString(this.mSeqBuffer, 2 * n - 1);
            }
            catch (SQLException sQLException) {
                throw new SystemError(sQLException, "Failed to get data from array buffer");
            }
        }
        if (n > this.currentSize && this.tailLoaded) {
            return null;
        }
        this.load(string, FORWARD);
        if (this.currentSize == 1) {
            return null;
        }
        return this._next(string);
    }

    private String dbPrevious(String string) throws CacheException {
        Dataholder[] dataholderArray = new Dataholder[]{new Dataholder(string)};
        Dataholder dataholder = this.mArray.runInstanceMethod("Previous", dataholderArray, 0);
        return dataholder.getString();
    }

    public String _previous(String string) throws CacheException {
        int n;
        if (this.mBufferSize <= 1) {
            return this.dbPrevious(string);
        }
        if (string != null && !this.mDirBuffer.containsKey(string)) {
            if (this.mAutoLoad) {
                this.load(string, BACKWARD);
            } else if (this.mBufferSize >= this.count()) {
                this.load(null, FORWARD);
            } else {
                return this.dbPrevious(string);
            }
        }
        if (0 < (n = this.indexFromKey(string, BACKWARD)) && n <= this.currentSize) {
            try {
                return SysListProxy.getString(this.mSeqBuffer, 2 * n - 1);
            }
            catch (SQLException sQLException) {
                throw new SystemError(sQLException, "Failed to get data from array buffer");
            }
        }
        if (n == 0 && this.headLoaded) {
            return null;
        }
        this.load(string, BACKWARD);
        if (this.currentSize == 1) {
            return null;
        }
        return this._previous(string);
    }

    public Dataholder getPrevious(StringHolder stringHolder) throws CacheException {
        int n;
        if (this.mBufferSize <= 1) {
            return null;
        }
        String string = stringHolder.value;
        if (string != null && !this.mDirBuffer.containsKey(string)) {
            if (this.mAutoLoad) {
                this.load(string, BACKWARD);
            } else if (this.mBufferSize >= this.count()) {
                this.load(null, FORWARD);
            } else {
                return null;
            }
        }
        if (0 < (n = this.indexFromKey(string, BACKWARD)) && n <= this.currentSize) {
            return this.getFromBufferAtIndex(n, stringHolder);
        }
        if (n == 0 && this.headLoaded) {
            stringHolder.value = null;
            return new Dataholder("");
        }
        this.load(string, BACKWARD);
        if (this.currentSize == 1) {
            stringHolder.value = null;
            return new Dataholder("");
        }
        return this.getPrevious(stringHolder);
    }

    private Dataholder getFromBufferAtIndex(int n, StringHolder stringHolder) throws CacheException {
        int n2 = n * 2 - 1;
        try {
            stringHolder.value = SysListProxy.getString(this.mSeqBuffer, n2);
            Object object = SysListProxy.getWrappedItem(this.mSeqBuffer);
            return new Dataholder(4096, object);
        }
        catch (SQLException sQLException) {
            throw new SystemError(sQLException, "Failed to get data from array buffer");
        }
    }

    private void register() throws CacheException {
        this.mArray.getDatabase().registerSensitiveObject((CacheServerSensitive)this, this.mArray.getOref());
        this.mRegistered = true;
    }

    private void unregister() throws CacheException {
        this.mArray.getDatabase().unRegisterSensitiveObject(this);
        this.mRegistered = false;
    }

    protected void load(String string, int n) throws CacheException {
        if (!this.mRegistered) {
            this.register();
        }
        int n2 = -1;
        if (string != null && (n2 = this.count()) <= this.mBufferSize) {
            string = null;
        }
        this.mSeqBuffer = this.getArrayBuffer(string, n);
        this.headLoaded = false;
        this.tailLoaded = false;
        try {
            this.currentSize = SysListProxy.getInteger(this.mSeqBuffer, 0);
        }
        catch (SQLException sQLException) {
            throw new SystemError(sQLException, "Failed to get data from the buffer received");
        }
        if (string == null && this.currentSize < this.mBufferSize) {
            this.mArraySize = this.currentSize;
            if (n2 >= 0 && n2 != this.mArraySize) {
                throw new SystemError("Array size problem");
            }
        } else if (n2 >= 0) {
            this.mArraySize = n2;
        } else {
            int n3 = this.currentSize;
            this.mArraySize = this.count();
            this.currentSize = n3;
        }
        StringHolder stringHolder = new StringHolder(null);
        this.mDirBuffer.clear();
        for (int i = 1; i <= this.currentSize; ++i) {
            Dataholder dataholder = this.getFromBufferAtIndex(i, stringHolder);
            this.mDirBuffer.put(stringHolder.value, new ValueIndexPair(dataholder, i));
        }
        this.mCached = true;
        if (this.mArraySize <= this.mBufferSize) {
            this.headLoaded = true;
            this.tailLoaded = true;
        } else if (string == null || string.equals("")) {
            if (n > 0) {
                this.headLoaded = true;
            } else {
                this.tailLoaded = true;
            }
        } else if (this.currentSize < this.mBufferSize) {
            if (n > 0) {
                this.tailLoaded = true;
            } else {
                this.headLoaded = true;
            }
        }
    }

    public boolean onServerCall(Set set) throws CacheException {
        if (this.mArray.isClosed()) {
            this.invalidateCache(true);
            this.mRegistered = false;
            return false;
        }
        if (set.size() != 1 || !set.contains(new Integer(this.mArray.getOref()))) {
            throw new SystemError("Wrong change notification");
        }
        this.invalidateCache(true);
        this.mRegistered = false;
        return false;
    }

    public void onDatabaseDestroy() throws CacheException {
        this.mRegistered = false;
    }

    public void close(boolean bl) throws CacheException {
    }

    public void handleEvent(CacheEvent cacheEvent) throws CacheException {
        switch (cacheEvent.getType()) {
            case 100: 
            case 200: {
                this.close(true);
                break;
            }
            case 300: {
                this.close(false);
                break;
            }
        }
    }

    protected Object dbGetAt(String string) throws CacheException {
        Dataholder[] dataholderArray = new Dataholder[]{new Dataholder(string)};
        Dataholder dataholder = this.mArray.runInstanceMethod("GetAt", dataholderArray, 0);
        return dataholder.getString();
    }

    public Object _getAt(String string) throws CacheException {
        Dataholder dataholder = this.getAt(string);
        if (dataholder == null) {
            return this.dbGetAt(string);
        }
        return this.getFromDataholder(dataholder);
    }

    public Object dbGetNext(StringHolder stringHolder) throws CacheException {
        Dataholder[] dataholderArray = new Dataholder[]{new Dataholder(stringHolder.value)};
        int[] nArray = new int[]{1};
        Dataholder[] dataholderArray2 = this.mArray.runInstanceMethod("GetNext", nArray, dataholderArray, 0);
        stringHolder.set(dataholderArray2[1].getString());
        return dataholderArray2[0].getString();
    }

    public Object _getNext(StringHolder stringHolder) throws CacheException {
        Dataholder dataholder = this.getNext(stringHolder);
        if (dataholder == null) {
            return this.dbGetNext(stringHolder);
        }
        return this.getFromDataholder(dataholder);
    }

    public Object dbGetPrevious(StringHolder stringHolder) throws CacheException {
        Dataholder[] dataholderArray = new Dataholder[]{new Dataholder(stringHolder.value)};
        int[] nArray = new int[]{1};
        Dataholder[] dataholderArray2 = this.mArray.runInstanceMethod("GetPrevious", nArray, dataholderArray, 0);
        stringHolder.set(dataholderArray2[1].getString());
        return dataholderArray2[0].getString();
    }

    public Object _getPrevious(StringHolder stringHolder) throws CacheException {
        Dataholder dataholder = this.getPrevious(stringHolder);
        if (dataholder == null) {
            return this.dbGetPrevious(stringHolder);
        }
        return this.getFromDataholder(dataholder);
    }

    protected abstract Object getArrayBuffer(String var1, int var2) throws CacheException;

    protected abstract Object getFromDataholder(Dataholder var1) throws CacheException;

    protected void invalidateCache(boolean bl) throws CacheException {
        this.mCached = false;
        this.mDirBuffer.clear();
        this.mArraySize = -1;
        this.currentSize = 0;
        this.headLoaded = false;
        this.tailLoaded = false;
    }

    protected int indexFromKey(String string, int n) throws CacheException {
        if (string == null || string.equals("")) {
            if (n > 0 && this.headLoaded) {
                return 1;
            }
            if (n <= 0 && this.tailLoaded) {
                return this.currentSize;
            }
            return this.currentSize + 10;
        }
        Object v = this.mDirBuffer.get(string);
        if (v == null) {
            throw new SystemError("Key " + string + " is not found after " + "loading array buffer");
        }
        int n2 = ((ValueIndexPair)v).index + (n > 0 ? 1 : -1);
        return n2;
    }

    protected Dataholder getFromDirBuffer(String string) throws CacheException {
        ValueIndexPair valueIndexPair = (ValueIndexPair)this.mDirBuffer.get(string);
        if (valueIndexPair == null) {
            return new Dataholder(24, null);
        }
        return valueIndexPair.value;
    }

    protected void finalize() throws Throwable {
        if (this.mRegistered) {
            this.unregister();
        }
        super.finalize();
    }

    protected class ValueIndexPair {
        Dataholder value;
        int index;

        public ValueIndexPair(Dataholder dataholder, int n) {
            this.value = dataholder;
            this.index = n;
        }
    }
}

