/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import org.firebirdsql.jdbc.FBEscapedParser;
import org.firebirdsql.jdbc.FBProcedureCall;
import org.firebirdsql.jdbc.FBProcedureParam;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.FBSQLParseException;

public class FBEscapedCallParser {
    private static final int NORMAL_STATE = 1;
    private static final int LITERAL_STATE = 2;
    private static final int BRACE_STATE = 4;
    private static final int CURLY_BRACE_STATE = 8;
    private static final int SPACE_STATE = 16;
    private static final int COMMA_STATE = 32;
    private int state = 1;
    private int paramPosition;
    private int paramCount;
    private boolean isFirstOutParam;
    private boolean isNameProcessed;
    private boolean isExecuteWordProcessed;
    private boolean isProcedureWordProcessed;
    private boolean isCallWordProcessed;
    private int openBraceCount;
    private FBProcedureCall procedureCall;
    private FBEscapedParser escapedParser;

    public FBEscapedCallParser(int mode) {
        this.escapedParser = new FBEscapedParser(mode);
    }

    protected int getState() {
        return this.state;
    }

    protected void setState(int state) {
        this.state = state;
    }

    protected boolean isInState(int state) {
        return this.state == state;
    }

    protected void switchState(char testChar) throws FBSQLParseException {
        switch (testChar) {
            case '\'': {
                if (this.isInState(1)) {
                    this.setState(2);
                    break;
                }
                if (!this.isInState(2)) break;
                this.setState(1);
                break;
            }
            case '\t': 
            case '\n': 
            case '\f': 
            case '\r': 
            case ' ': {
                if (this.isInState(2)) break;
                this.setState(16);
                break;
            }
            case ',': {
                if (this.isInState(2) || this.isInState(4)) break;
                this.setState(32);
                break;
            }
            case '(': 
            case ')': {
                if (this.isInState(2)) break;
                this.setState(4);
                break;
            }
            case '{': 
            case '}': {
                if (this.isInState(2)) break;
                this.setState(8);
                break;
            }
            default: {
                if (this.isInState(2) || this.isInState(4)) break;
                this.setState(1);
            }
        }
    }

    private String cleanUpCall(String sql) throws FBSQLParseException {
        StringBuffer cleanupBuffer = new StringBuffer(sql);
        while (cleanupBuffer.length() > 0 && Character.isSpaceChar(cleanupBuffer.charAt(0))) {
            cleanupBuffer.deleteCharAt(0);
        }
        while (cleanupBuffer.length() > 0 && Character.isSpaceChar(cleanupBuffer.charAt(cleanupBuffer.length() - 1))) {
            cleanupBuffer.deleteCharAt(cleanupBuffer.length() - 1);
        }
        if (cleanupBuffer.length() == 0) {
            throw new FBSQLParseException("Escaped call statement was empty.");
        }
        if (cleanupBuffer.charAt(0) == '{') {
            cleanupBuffer.deleteCharAt(0);
        }
        if (cleanupBuffer.charAt(cleanupBuffer.length() - 1) == '}') {
            cleanupBuffer.deleteCharAt(cleanupBuffer.length() - 1);
        }
        return cleanupBuffer.toString();
    }

    private boolean isCallKeywordProcessed() {
        return this.isCallWordProcessed || this.isExecuteWordProcessed && this.isProcedureWordProcessed;
    }

    public FBProcedureCall parseCall(String sql) throws FBSQLException {
        sql = this.cleanUpCall(sql);
        this.procedureCall = new FBProcedureCall();
        this.isExecuteWordProcessed = false;
        this.isProcedureWordProcessed = false;
        this.isCallWordProcessed = false;
        this.isNameProcessed = false;
        this.isFirstOutParam = false;
        this.paramCount = 0;
        this.paramPosition = 0;
        this.setState(1);
        char[] sqlbuff = sql.toCharArray();
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < sqlbuff.length; ++i) {
            this.switchState(sqlbuff[i]);
            if (this.isInState(1)) {
                String token;
                if (sqlbuff[i] == '=' && this.openBraceCount <= 0 && "?".equals(token = buffer.toString().trim()) && !this.isFirstOutParam && !this.isNameProcessed) {
                    FBProcedureParam param = this.procedureCall.addParam(this.paramPosition, token);
                    ++this.paramCount;
                    param.setIndex(this.paramCount);
                    this.isFirstOutParam = true;
                    ++this.paramPosition;
                    buffer = new StringBuffer();
                    continue;
                }
                buffer.append(sqlbuff[i]);
                continue;
            }
            if (this.isInState(16)) {
                if (buffer.length() == 0) {
                    this.setState(1);
                    continue;
                }
                if (this.openBraceCount > 0) {
                    buffer.append(sqlbuff[i]);
                    this.setState(1);
                    continue;
                }
                String token = buffer.toString().trim();
                if (!this.isNameProcessed) {
                    int j;
                    boolean tokenProcessed = this.processToken(token);
                    if (!tokenProcessed) continue;
                    buffer = new StringBuffer();
                    this.setState(1);
                    if (!this.isNameProcessed) continue;
                    for (j = i; j < sqlbuff.length - 1 && Character.isWhitespace(sqlbuff[j]); ++j) {
                    }
                    if (sqlbuff[j] != '(') continue;
                    i = j;
                    continue;
                }
                buffer.append(sqlbuff[i]);
                this.setState(1);
                continue;
            }
            if (this.isInState(4)) {
                boolean isProcedureName;
                boolean bl = isProcedureName = sqlbuff[i] == '(' && this.isCallKeywordProcessed() && !this.isNameProcessed;
                if (isProcedureName) {
                    String token = buffer.toString().trim();
                    if ("".equals(token)) {
                        throw new FBSQLParseException("Procedure name is empty.");
                    }
                    this.procedureCall.setName(token);
                    this.isNameProcessed = true;
                    buffer = new StringBuffer();
                } else {
                    buffer.append(sqlbuff[i]);
                    this.openBraceCount = sqlbuff[i] == '(' ? ++this.openBraceCount : --this.openBraceCount;
                }
                this.setState(1);
                continue;
            }
            if (this.isInState(8)) {
                buffer.append(sqlbuff[i]);
                this.setState(1);
                continue;
            }
            if (this.isInState(32)) {
                if (this.openBraceCount > 0) {
                    buffer.append(sqlbuff[i]);
                    continue;
                }
                String param = this.processParam(buffer.toString());
                buffer = new StringBuffer();
                FBProcedureParam callParam = this.procedureCall.addParam(this.paramPosition, param);
                if (callParam.isParam()) {
                    ++this.paramCount;
                    callParam.setIndex(this.paramCount);
                }
                ++this.paramPosition;
                this.setState(1);
                continue;
            }
            if (!this.isInState(2)) continue;
            buffer.append(sqlbuff[i]);
        }
        if (buffer.length() == 0) {
            return this.procedureCall;
        }
        while (Character.isSpaceChar(buffer.charAt(0))) {
            buffer.deleteCharAt(0);
        }
        while (Character.isSpaceChar(buffer.charAt(buffer.length() - 1))) {
            buffer.deleteCharAt(buffer.length() - 1);
        }
        if (buffer.charAt(0) == '(') {
            buffer.deleteCharAt(0);
        }
        if (buffer.charAt(buffer.length() - 1) == ')') {
            buffer.deleteCharAt(buffer.length() - 1);
        }
        if (null == this.procedureCall.getName() && !this.isNameProcessed) {
            this.procedureCall.setName(buffer.toString());
        } else {
            FBProcedureParam callParam = this.procedureCall.addParam(this.paramPosition, buffer.toString());
            if (callParam.isParam()) {
                ++this.paramCount;
                callParam.setIndex(this.paramCount);
            }
        }
        return this.procedureCall;
    }

    protected boolean processToken(String token) {
        if ("EXECUTE".equalsIgnoreCase(token) && !this.isExecuteWordProcessed && !this.isProcedureWordProcessed && !this.isNameProcessed) {
            this.isExecuteWordProcessed = true;
            return true;
        }
        if ("PROCEDURE".equalsIgnoreCase(token) && this.isExecuteWordProcessed && !this.isProcedureWordProcessed && !this.isNameProcessed) {
            this.isProcedureWordProcessed = true;
            return true;
        }
        if ("call".equalsIgnoreCase(token) && !this.isCallWordProcessed && !this.isNameProcessed) {
            this.isCallWordProcessed = true;
            return true;
        }
        if ((this.isCallWordProcessed || this.isExecuteWordProcessed && this.isProcedureWordProcessed) && !this.isNameProcessed) {
            this.procedureCall.setName(token);
            this.isNameProcessed = true;
            return true;
        }
        return false;
    }

    protected String processParam(String param) throws FBSQLException {
        return this.escapedParser.parse(param);
    }
}

