/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc;

import com.intersys.VersionInfo;
import com.intersys.jdbc.CacheCallableStatement;
import com.intersys.jdbc.CacheConnection;
import com.intersys.jdbc.CacheResultSet;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;

public class CacheDatabaseMetaData
implements DatabaseMetaData {
    private CacheConnection connection;

    CacheDatabaseMetaData(CacheConnection cacheConnection) {
        this.connection = cacheConnection;
    }

    public boolean allProceduresAreCallable() throws SQLException {
        return true;
    }

    public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    public synchronized String getURL() throws SQLException {
        return this.connection.url;
    }

    public synchronized String getUserName() throws SQLException {
        return this.connection.user;
    }

    public boolean isReadOnly() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedLow() throws SQLException {
        return true;
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    public String getDatabaseProductName() throws SQLException {
        return "Cache";
    }

    public synchronized String getDatabaseProductVersion() throws SQLException {
        return this.connection.serverVersion;
    }

    public String getDriverName() throws SQLException {
        return "InterSystems Cache JDBC";
    }

    public String getDriverVersion() throws SQLException {
        return VersionInfo.getClientVersion();
    }

    public int getDriverMajorVersion() {
        return VersionInfo.getMajorVersion();
    }

    public int getDriverMinorVersion() {
        return VersionInfo.getMinorVersion();
    }

    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return true;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    public synchronized String getIdentifierQuoteString() throws SQLException {
        if (this.connection.delimitedIds == 1) {
            return "\"";
        }
        return " ";
    }

    public String getSQLKeywords() throws SQLException {
        return "%AFTERHAVING,%ALPHAUP,%ALTER,%ALTER_USER,%BEGTRANS,%CHECKPRIV,%CREATE_ROLE,%CREATE_USER,%DBUGFULL,%DELDATA,%DESCRIPTION,%DROP_ANY_ROLE,%DROP_USER,%EXACT,%EXTERNAL,%FILE,%FOREACH,%FULL,%GRANT_ANY_PRIVILEGE,%GRANT_ANY_ROLE,%INORDER,%INTERNAL,%INTEXT,%INTRANS,%INTRANSACTION,%MCODE,%NOCHECK,%NODELDATA,%NOINDEX,%NOLOCK,%NOTRIGGER,%NUMROWS,%ODBCOUT,%ROUTINE,%ROWCOUNT,%STARTSWITH,%STRING,%THRESHOLD,%UPPER,AVG,BETWEEN,BIT_LENGTH,CHARACTER_LENGTH,CHAR_LENGTH,COALESCE,COBOL,CONVERT,COUNT,ENDEXEC,EXISTS,EXTRACT,FILE,FORTRAN,INSENSITIVE,LOWER,MAX,MIN,NULLIF,OCTET_LENGTH,OVERLAPS,PASCAL,PLI,POSITION,SQLCODE,SQLERROR,SUBSTRING,SUM,TRANSLATE,TRIM,UPPER";
    }

    public String getNumericFunctions() throws SQLException {
        return "ABS,ACOS,ASIN,ATAN,CEILING,COS,COT,EXP,FLOOR,LOG,LOG10,MOD,PI,POWER,ROUND,SIGN,SIN,SQRT,TAN,TRUNCATE";
    }

    public String getStringFunctions() throws SQLException {
        return "ASCII,CHAR,CONCAT,LCASE,LEFT,LENGTH,LTRIM,REPEAT,RIGHT,RTRIM,SPACE,SUBSTRING,UCASE";
    }

    public String getSystemFunctions() throws SQLException {
        return "IFNULL";
    }

    public String getTimeDateFunctions() throws SQLException {
        return "CURDATE,CURTIME,DAYNAME,DAYOFMONTH,DAYOFWEEK,DAYOFYEAR,HOUR,MINUTE,MONTH,MONTHNAME,NOW,QUARTER,SECOND,TIMESTAMPADD,TIMESTAMPDIFF,WEEK,YEAR";
    }

    public String getSearchStringEscape() throws SQLException {
        return "\\";
    }

    public String getExtraNameCharacters() throws SQLException {
        return "%";
    }

    public String getSchemaTerm() throws SQLException {
        return "Schema";
    }

    public String getProcedureTerm() throws SQLException {
        return "Stored Procedure";
    }

    public String getCatalogTerm() throws SQLException {
        return "";
    }

    public boolean isCatalogAtStart() throws SQLException {
        return true;
    }

    public String getCatalogSeparator() throws SQLException {
        return ".";
    }

    public synchronized int getDefaultTransactionIsolation() throws SQLException {
        return this.connection.isolationLevel;
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return true;
    }

    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    public boolean supportsConvert() throws SQLException {
        return true;
    }

    public boolean supportsConvert(int n, int n2) throws SQLException {
        switch (n) {
            case -7: 
            case -4: 
            case -3: 
            case -2: 
            case -1: {
                return false;
            }
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return n2 == 4 || n2 == 12;
            }
            case 1: {
                return n2 == 4 || n2 == 12 || n2 == 91 || n2 == 92;
            }
            case 12: {
                return n2 == 4 || n2 == 12 || n2 == 91 || n2 == 92 || n2 == 93;
            }
            case 91: {
                return n2 == 4 || n2 == 12 || n2 == 91 || n2 == 93;
            }
            case 92: {
                return n2 == 4 || n2 == 12 || n2 == 92;
            }
            case 93: {
                return n2 == 12 || n2 == 91 || n2 == 92;
            }
        }
        return false;
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return false;
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        return true;
    }

    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        return true;
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return true;
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        return true;
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        return false;
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return false;
    }

    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        return false;
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return true;
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return true;
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        return false;
    }

    public boolean supportsStoredProcedures() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return true;
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return true;
    }

    public boolean supportsUnion() throws SQLException {
        return true;
    }

    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return true;
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return true;
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return true;
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return true;
    }

    public boolean supportsTransactions() throws SQLException {
        return true;
    }

    public synchronized boolean supportsTransactionIsolationLevel(int n) throws SQLException {
        if (n == 1) {
            return this.connection.supportedIsolationLevels % 2 == 1;
        }
        if (n == 2) {
            return this.connection.supportedIsolationLevels == 3;
        }
        if (n == 4 || n == 8 || n == 0) {
            return false;
        }
        throw new SQLException("Information type out of range", "S1096", 473);
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    public int getMaxCharLiteralLength() throws SQLException {
        return Short.MAX_VALUE;
    }

    public int getMaxColumnNameLength() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInIndex() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInSelect() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInTable() throws SQLException {
        return 0;
    }

    public int getMaxConnections() throws SQLException {
        return 0;
    }

    public int getMaxCursorNameLength() throws SQLException {
        return 0;
    }

    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    public int getMaxSchemaNameLength() throws SQLException {
        return 0;
    }

    public int getMaxProcedureNameLength() throws SQLException {
        return 0;
    }

    public int getMaxCatalogNameLength() throws SQLException {
        return 0;
    }

    public int getMaxRowSize() throws SQLException {
        return 0;
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return false;
    }

    public int getMaxStatementLength() throws SQLException {
        return 0;
    }

    public int getMaxStatements() throws SQLException {
        return 0;
    }

    public int getMaxTableNameLength() throws SQLException {
        return 0;
    }

    public int getMaxTablesInSelect() throws SQLException {
        return 0;
    }

    public int getMaxUserNameLength() throws SQLException {
        return 0;
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return true;
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    public ResultSet getProcedures(String string, String string2, String string3) throws SQLException {
        if (string2 == null) {
            string2 = "%";
        }
        if (string3 == null || string3.length() == 0) {
            string3 = "%";
        }
        return this.executeCatalogQuery(CacheConnection.JDBC_PROCEDURES, string3, string2, null, null);
    }

    public ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        if (string2 == null) {
            string2 = "%";
        }
        if (string3 == null || string3.length() == 0) {
            string3 = "%";
        }
        if (string4 == null || string4.length() == 0) {
            string4 = "%";
        }
        return this.executeCatalogQuery(CacheConnection.JDBC_PROCEDURECOL, string3, string4, string2, null);
    }

    public ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLException {
        String string4;
        if (stringArray == null || stringArray.length == 0) {
            string4 = "TABLE,VIEW";
        } else {
            string4 = stringArray[0];
            for (int i = 1; i < stringArray.length; ++i) {
                string4 = string4 + "," + stringArray[i];
            }
        }
        if (string2 == null) {
            string2 = "%";
        }
        if (string3 == null || string3.length() == 0) {
            string3 = "%";
        }
        return this.executeCatalogQuery(CacheConnection.JDBC_TABLES, string3, string4, string2, null);
    }

    public ResultSet getSchemas() throws SQLException {
        return this.executeCatalogQuery(CacheConnection.JDBC_SCHEMAS, null, null, null, null);
    }

    public ResultSet getCatalogs() throws SQLException {
        return this.executeCatalogQuery(CacheConnection.JDBC_CATALOGS, null, null, null, null);
    }

    public ResultSet getTableTypes() throws SQLException {
        return this.executeCatalogQuery(CacheConnection.JDBC_TABLETYPES, null, null, null, null);
    }

    public ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        if (string2 == null) {
            string2 = "%";
        }
        if (string3 == null || string3.length() == 0) {
            string3 = "%";
        }
        if (string4 == null || string4.length() == 0) {
            string4 = "%";
        }
        return this.executeCatalogQuery(CacheConnection.JDBC_COLUMNS, string3, string4, string2, null);
    }

    public ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        if (string2 == null) {
            string2 = "%";
        }
        if (string3 == null || string3.length() == 0) {
            string3 = "%";
        }
        if (string4 == null || string4.length() == 0) {
            string4 = "%";
        }
        return this.executeCatalogQuery(CacheConnection.JDBC_COLUMNPRIV, string3, string4, string2, null);
    }

    public ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLException {
        if (string2 == null) {
            string2 = "%";
        }
        if (string3 == null || string3.length() == 0) {
            string3 = "%";
        }
        return this.executeCatalogQuery(CacheConnection.JDBC_TABLEPRIV, string3, string2, null, null);
    }

    public ResultSet getBestRowIdentifier(String string, String string2, String string3, int n, boolean bl) throws SQLException {
        if (string2 == null) {
            string2 = "%";
        }
        if (string3 == null || string3.length() == 0) {
            string3 = "%";
        }
        return this.executeCatalogQuery(CacheConnection.JDBC_BESTROWID, string3, string2, null, null);
    }

    public ResultSet getVersionColumns(String string, String string2, String string3) throws SQLException {
        if (string3 == null || string3.length() == 0) {
            string3 = "%";
        }
        return this.executeCatalogQuery(CacheConnection.JDBC_VERSIONCOL, string3, null, null, null);
    }

    public ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        if (string2 == null) {
            string2 = "%";
        }
        if (string3 == null || string3.length() == 0) {
            string3 = "%";
        }
        return this.executeCatalogQuery(CacheConnection.JDBC_PRIMARYKEYS, string3, string2, null, null);
    }

    public ResultSet getImportedKeys(String string, String string2, String string3) throws SQLException {
        if (string2 == null) {
            string2 = "%";
        }
        if (string3 == null || string3.length() == 0) {
            string3 = "%";
        }
        return this.executeCatalogQuery(CacheConnection.JDBC_IMPORTEDKEYS, string3, string2, null, null);
    }

    public ResultSet getExportedKeys(String string, String string2, String string3) throws SQLException {
        if (string2 == null) {
            string2 = "%";
        }
        if (string3 == null || string3.length() == 0) {
            string3 = "%";
        }
        return this.executeCatalogQuery(CacheConnection.JDBC_EXPORTEDKEYS, string3, string2, null, null);
    }

    public ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        if (string2 == null) {
            string2 = "%";
        }
        if (string5 == null) {
            string5 = "%";
        }
        if (string3 == null || string3.length() == 0) {
            string3 = "%";
        }
        if (string6 == null || string6.length() == 0) {
            string6 = "%";
        }
        return this.executeCatalogQuery(CacheConnection.JDBC_CROSSREFERENCE, string3, string6, string2, string5);
    }

    public ResultSet getTypeInfo() throws SQLException {
        return this.executeCatalogQuery(CacheConnection.JDBC_TYPEINFO, null, null, null, null);
    }

    public ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        if (string2 == null) {
            string2 = "%";
        }
        if (string3 == null || string3.length() == 0) {
            string3 = "%";
        }
        if (bl) {
            return this.executeCatalogQuery(CacheConnection.JDBC_INDEXINFO, string3, string2, "0", null);
        }
        return this.executeCatalogQuery(CacheConnection.JDBC_INDEXINFO, string3, string2, "1", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final synchronized ResultSet executeCatalogQuery(byte[] byArray, String string, String string2, String string3, String string4) throws SQLException {
        if (this.connection == null || this.connection.isClosed()) {
            throw new SQLException("Connection not open", "08003");
        }
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            CacheCallableStatement cacheCallableStatement = new CacheCallableStatement(this.connection);
            cacheCallableStatement.serverCursorNumber = ++this.connection.nextServerCursorNumber;
            this.connection.outMessage.wire.writeHeader(cacheCallableStatement.serverCursorNumber, byArray);
            this.connection.outMessage.wire.set(1);
            if (string4 != null) {
                this.connection.outMessage.wire.set(4);
            } else if (string3 != null) {
                this.connection.outMessage.wire.set(3);
            } else if (string2 != null) {
                this.connection.outMessage.wire.set(2);
            } else if (string != null) {
                this.connection.outMessage.wire.set(1);
            } else {
                this.connection.outMessage.wire.set(0);
            }
            if (string != null) {
                this.connection.outMessage.wire.set(string);
                if (string2 != null) {
                    this.connection.outMessage.wire.set(string2);
                    if (string3 != null) {
                        this.connection.outMessage.wire.set(string3);
                        if (string4 != null) {
                            this.connection.outMessage.wire.set(string4);
                        }
                    }
                }
            }
            this.connection.outMessage.send(this.connection.messageCount.getCount());
            if (cacheCallableStatement.input.readHeader(cacheCallableStatement.serverCursorNumber, 0, 100) == 100) {
                cacheCallableStatement.fetchDone = true;
            }
            cacheCallableStatement.input.wire.getInt();
            cacheCallableStatement.columnInfo(cacheCallableStatement.input.wire);
            if (cacheCallableStatement.input.readHeader(cacheCallableStatement.serverCursorNumber, 0, 100) == 100) {
                cacheCallableStatement.fetchDone = true;
            }
            return new CacheResultSet(cacheCallableStatement);
        }
    }

    public boolean supportsResultSetType(int n) throws SQLException {
        return n != 1005;
    }

    public boolean supportsResultSetConcurrency(int n, int n2) throws SQLException {
        return n != 1005;
    }

    public boolean ownUpdatesAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean ownDeletesAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean ownInsertsAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean othersUpdatesAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean othersDeletesAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean othersInsertsAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean updatesAreDetected(int n) throws SQLException {
        return false;
    }

    public boolean deletesAreDetected(int n) throws SQLException {
        return false;
    }

    public boolean insertsAreDetected(int n) throws SQLException {
        return false;
    }

    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    public ResultSet getUDTs(String string, String string2, String string3, int[] nArray) throws SQLException {
        return this.executeCatalogQuery(CacheConnection.JDBC_UDTS, null, null, null, null);
    }

    public synchronized Connection getConnection() throws SQLException {
        return this.connection;
    }

    public boolean supportsNamedParameters() throws SQLException {
        return true;
    }

    public boolean supportsMultipleOpenResults() throws SQLException {
        return false;
    }

    public boolean supportsSavepoints() throws SQLException {
        return false;
    }

    public boolean supportsGetGeneratedKeys() throws SQLException {
        return true;
    }

    public ResultSet getSuperTypes(String string, String string2, String string3) throws SQLException {
        return this.executeCatalogQuery(CacheConnection.JDBC_SUPER_TYPES, string, string2, string3, null);
    }

    public ResultSet getSuperTables(String string, String string2, String string3) throws SQLException {
        return this.executeCatalogQuery(CacheConnection.JDBC_SUPER_TABLES, string, string2, string3, null);
    }

    public ResultSet getAttributes(String string, String string2, String string3, String string4) throws SQLException {
        return this.executeCatalogQuery(CacheConnection.JDBC_GET_ATTRIBUTES, string, string2, string3, string4);
    }

    public boolean supportsResultSetHoldability(int n) throws SQLException {
        return n == 1;
    }

    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    public int getDatabaseMajorVersion() throws SQLException {
        return VersionInfo.getMajorVersion();
    }

    public int getDatabaseMinorVersion() throws SQLException {
        return VersionInfo.getMinorVersion();
    }

    public int getJDBCMajorVersion() throws SQLException {
        return VersionInfo.getMajorVersion();
    }

    public int getJDBCMinorVersion() throws SQLException {
        return VersionInfo.getMinorVersion();
    }

    public int getSQLStateType() throws SQLException {
        return 1;
    }

    public boolean locatorsUpdateCopy() throws SQLException {
        return false;
    }

    public boolean supportsStatementPooling() throws SQLException {
        return true;
    }
}

