/*
 * JBoss, Home of Professional Open Source
 *
 * Copyright 2015 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.keycloak.authorization.client.representation;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.Set;

/**
 * @author <a href="mailto:psilva@redhat.com">Pedro Igor</a>
 */
public class PermissionRequest {

    @JsonProperty("resource_set_id")
    private String resourceSetId;

    @JsonProperty("resource_set_name")
    private String resourceSetName;

    private Set<String> scopes;

    public PermissionRequest() {

    }

    public PermissionRequest(String resourceSetId, String resourceSetName, Set<String> scopes) {
        this.resourceSetId = resourceSetId;
        this.resourceSetName = resourceSetName;
        this.scopes = scopes;
    }

    public PermissionRequest(String resourceSetName) {
        this.resourceSetName = resourceSetName;
    }

    public PermissionRequest(String resourceSetName, Set<String> scopes) {
        this.resourceSetName = resourceSetName;
        this.scopes = scopes;
    }

    public String getResourceSetId() {
        return this.resourceSetId;
    }

    public void setResourceSetId(String resourceSetId) {
        this.resourceSetId = resourceSetId;
    }

    public Set<String> getScopes() {
        return this.scopes;
    }

    public void setScopes(Set<String> scopes) {
        this.scopes = scopes;
    }

    public String getResourceSetName() {
        return this.resourceSetName;
    }

    public void setResourceSetName(String resourceSetName) {
        this.resourceSetName = resourceSetName;
    }
}
