/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.dictionary.AliasDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.PermissionsDescriptor;
import org.apache.derby.iapi.sql.dictionary.RoutinePermsDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.StatementPermission;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.execute.ExecPreparedStatement;
import org.apache.derby.iapi.store.access.TransactionController;

public final class StatementRoutinePermission
extends StatementPermission {
    private UUID routineUUID;

    public StatementRoutinePermission(UUID uUID) {
        this.routineUUID = uUID;
    }

    public UUID getRoutineUUID() {
        return this.routineUUID;
    }

    public void check(LanguageConnectionContext languageConnectionContext, String string, boolean bl, Activation activation) throws StandardException {
        TupleDescriptor tupleDescriptor;
        Object object;
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        ExecPreparedStatement execPreparedStatement = activation.getPreparedStatement();
        RoutinePermsDescriptor routinePermsDescriptor = dataDictionary.getRoutinePermissions(this.routineUUID, string);
        if (routinePermsDescriptor == null || !routinePermsDescriptor.getHasExecutePermission()) {
            routinePermsDescriptor = dataDictionary.getRoutinePermissions(this.routineUUID, "PUBLIC");
        }
        if (routinePermsDescriptor != null && routinePermsDescriptor.getHasExecutePermission()) {
            return;
        }
        boolean bl2 = false;
        String string2 = languageConnectionContext.getCurrentRoleId(activation);
        if (string2 != null) {
            Object object2;
            Object object3;
            object = dataDictionary.getAuthorizationDatabaseOwner();
            tupleDescriptor = dataDictionary.getRoleGrantDescriptor(string2, string, (String)object);
            if (tupleDescriptor == null) {
                tupleDescriptor = dataDictionary.getRoleGrantDescriptor(string2, "PUBLIC", (String)object);
            }
            if (tupleDescriptor == null) {
                languageConnectionContext.setCurrentRole(activation, null);
            } else {
                object3 = dataDictionary.createRoleClosureIterator(activation.getTransactionController(), string2, true);
                while (!bl2 && (object2 = object3.next()) != null) {
                    routinePermsDescriptor = dataDictionary.getRoutinePermissions(this.routineUUID, (String)object2);
                    if (routinePermsDescriptor == null || !routinePermsDescriptor.getHasExecutePermission()) continue;
                    bl2 = true;
                }
            }
            if (bl2) {
                object3 = dataDictionary.getDependencyManager();
                object2 = dataDictionary.getRoleDefinitionDescriptor(string2);
                ContextManager contextManager = languageConnectionContext.getContextManager();
                object3.addDependency(execPreparedStatement, (Provider)object2, contextManager);
                object3.addDependency(activation, (Provider)object2, contextManager);
            }
        }
        if (!bl2) {
            object = dataDictionary.getAliasDescriptor(this.routineUUID);
            if (object == null) {
                throw StandardException.newException("4250E", "routine");
            }
            tupleDescriptor = dataDictionary.getSchemaDescriptor(((AliasDescriptor)object).getSchemaUUID(), transactionController);
            if (tupleDescriptor == null) {
                throw StandardException.newException("4250E", "schema");
            }
            throw StandardException.newException(bl ? "42505" : "42504", string, (Object)((AliasDescriptor)object).getDescriptorType(), (Object)((SchemaDescriptor)tupleDescriptor).getSchemaName(), (Object)((AliasDescriptor)object).getDescriptorName());
        }
    }

    public PermissionsDescriptor getPermissionDescriptor(String string, DataDictionary dataDictionary) throws StandardException {
        return dataDictionary.getRoutinePermissions(this.routineUUID, string);
    }

    public String toString() {
        return "StatementRoutinePermission: " + this.routineUUID;
    }
}

