/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.metadata;

import com.intersys.classes.Compiler.LG.JavaIndexDef;
import com.intersys.objects.CacheException;
import com.intersys.objects.reflect.CacheClass;
import com.intersys.objects.reflect.CacheIndexInfo;
import com.intersys.objects.reflect.SQLColumn;
import java.util.List;
import java.util.StringTokenizer;

public class CacheIndexMetadataImpl
implements CacheIndexInfo {
    private String mCondition;
    private String mData;
    private String mDescription;
    private boolean mIsExtent;
    private boolean mIsIdKey;
    private String mName;
    private Object[] mParameters;
    private boolean mIsPrimaryKey;
    private String mProperties;
    private int mSequenceNumber;
    private String mSqlName;
    private String mType;
    private boolean mIsUnique;
    private String mObjectName;
    private boolean mIsRunnable;
    private int[] mColumnNumbers;

    CacheIndexMetadataImpl(CacheClass cacheClass, JavaIndexDef javaIndexDef) throws CacheException {
        this.mCondition = javaIndexDef.getCondition();
        this.mData = javaIndexDef.getData();
        this.mDescription = javaIndexDef.getDescription();
        this.mIsExtent = javaIndexDef.getExtent();
        this.mIsIdKey = javaIndexDef.getIdKey();
        this.mName = javaIndexDef.getName();
        this.mParameters = javaIndexDef.getParameters().values().toArray();
        this.mIsPrimaryKey = javaIndexDef.getPrimaryKey();
        this.mProperties = javaIndexDef.getProperties();
        this.mSequenceNumber = javaIndexDef.getSequenceNumber();
        this.mSqlName = javaIndexDef.getSqlName();
        this.mType = javaIndexDef.getType();
        this.mIsUnique = javaIndexDef.getUnique();
        this.mObjectName = javaIndexDef.getObjectName();
        this.mIsRunnable = javaIndexDef.getRunnable();
        if (this.mIsRunnable) {
            List list = javaIndexDef.getColumnNumberList();
            int n = list.size();
            if (n > 0) {
                this.mColumnNumbers = new int[n];
                for (int i = 0; i < list.size(); ++i) {
                    this.mColumnNumbers[i] = Integer.parseInt((String)list.get(i));
                }
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(this.mProperties, ",");
                this.mColumnNumbers = new int[stringTokenizer.countTokens()];
                int n2 = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    String string = stringTokenizer.nextToken();
                    SQLColumn sQLColumn = cacheClass.getSQLTableMetadata().getColumn(string);
                    this.mColumnNumbers[n2] = sQLColumn.getNumber();
                    ++n2;
                }
            }
        } else {
            this.mColumnNumbers = new int[0];
        }
    }

    public String getCondition() {
        return this.mCondition;
    }

    public String getData() {
        return this.mData;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public boolean isExtent() {
        return this.mIsExtent;
    }

    public boolean isIdKey() {
        return this.mIsIdKey;
    }

    public String getName() {
        return this.mName;
    }

    public Object[] getParameters() {
        return this.mParameters;
    }

    public boolean isPrimaryKey() {
        return this.mIsPrimaryKey;
    }

    public String getProperties() {
        return this.mProperties;
    }

    public int getSequenceNumber() {
        return this.mSequenceNumber;
    }

    public String getSQLName() {
        return this.mSqlName;
    }

    public String getType() {
        return this.mType;
    }

    public boolean isUnique() {
        return this.mIsUnique;
    }

    public String getObjectName() {
        return this.mObjectName;
    }

    public boolean isRunnable() {
        return this.mIsRunnable;
    }

    public int[] getColumnNumbers() {
        return this.mColumnNumbers;
    }
}

