/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc;

import com.intersys.jdbc.CacheConnection;
import com.intersys.jdbc.LogFileStream;
import com.intersys.jdbc.SysList;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;

public final class OutStream {
    protected LogFileStream logFile;
    public SysList wire;
    private int protocolVersion = 42;
    protected OutputStream outputStream;
    private CacheConnection connection;

    public OutStream(OutputStream outputStream, LogFileStream logFileStream) {
        this.outputStream = outputStream;
        this.logFile = logFileStream;
        this.wire = new SysList();
    }

    OutStream(CacheConnection cacheConnection) throws IOException {
        this.outputStream = cacheConnection.outputStream;
        this.wire = new SysList();
        this.connection = cacheConnection;
        this.protocolVersion = this.connection.protocolVersion;
        this.logFile = this.connection.logFile;
    }

    public void setConnection(CacheConnection cacheConnection) {
        this.connection = cacheConnection;
        this.wire.setConnectionInfo(cacheConnection.connectionInfo);
        this.protocolVersion = this.connection.protocolVersion;
    }

    public final synchronized void send(int n) throws SQLException {
        try {
            this.wire.dumpData(this.outputStream, n, this.logFile);
            this.outputStream.flush();
        }
        catch (IOException iOException) {
            throw new SQLException("Communication link failure: " + iOException.getMessage(), "08S01", 461);
        }
    }

    protected final synchronized SysList setWire(SysList sysList) {
        SysList sysList2 = this.wire;
        this.wire = sysList;
        return sysList2;
    }
}

