/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.translators.BinaryDataTranslator;
import com.sap.dbtech.jdbc.translators.GetvalCharByte;
import com.sap.dbtech.jdbc.translators.SQLParamController;
import com.sap.dbtech.util.StructuredMem;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.SQLException;

class BytesTranslator
extends BinaryDataTranslator {
    BytesTranslator(int n, int n2, int n3, int n4, int n5, int n6, boolean bl, boolean bl2) {
        super(n, n2, n3, n4, n5, n6, bl, bl2);
    }

    public byte getByte(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        byte[] byArray = null;
        if (this.isNull(sQLParamController, structuredMem)) {
            return 0;
        }
        byArray = structuredMem.getBytes(this.bufpos, 1);
        return byArray[0];
    }

    public Blob getBlob(SQLParamController sQLParamController, StructuredMem structuredMem, StructuredMem structuredMem2) throws SQLException {
        GetvalCharByte getvalCharByte = null;
        if (!this.isNull(sQLParamController, structuredMem)) {
            getvalCharByte = new GetvalCharByte(structuredMem.getBytes(this.bufpos, this.logicalLength));
        }
        return getvalCharByte;
    }

    public byte[] getBytes(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        byte[] byArray = null;
        if (!this.isNull(sQLParamController, structuredMem)) {
            byArray = structuredMem.getBytes(this.bufpos, this.logicalLength);
        }
        return byArray;
    }

    public Object getObject(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        return this.getBytes(sQLParamController, structuredMem);
    }

    public String getString(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        byte[] byArray = this.getBytes(sQLParamController, structuredMem);
        String string = byArray == null ? null : new String(byArray);
        return string;
    }

    public Object transByteForInput(byte by) throws SQLException {
        byte[] byArray = new byte[]{by};
        return this.transBytesForInput(byArray);
    }

    public Object transBytesForInput(byte[] byArray) throws SQLException {
        if (byArray == null) {
            return byArray;
        }
        this.checkFieldLimits(byArray.length);
        return byArray;
    }

    public Object transSpecificForInput(Object object) throws SQLException {
        String string;
        Object object2 = null;
        Class<?> clazz = object.getClass();
        if (clazz.isArray() && (string = clazz.getName()).equals("[B")) {
            object2 = this.transBytesForInput((byte[])object);
        }
        return object2;
    }

    public Object transStringForInput(String string) throws SQLException {
        if (string == null) {
            return null;
        }
        return this.transBytesForInput(string.getBytes());
    }

    public Object transCharacterStreamForInput(Reader reader, int n) throws SQLException {
        if (n <= 0) {
            return null;
        }
        try {
            char[] cArray = new char[n];
            int n2 = reader.read(cArray);
            if (n2 != n) {
                if (n2 == -1) {
                    n2 = 0;
                }
                char[] cArray2 = cArray;
                cArray = new char[n2];
                System.arraycopy(cArray2, 0, cArray, 0, n2);
            }
            return this.transStringForInput(new String(cArray));
        }
        catch (IOException iOException) {
            throw new SQLExceptionSapDB(iOException.getMessage());
        }
    }

    public Object transBinaryStreamForInput(InputStream inputStream, int n) throws SQLException {
        if (n <= 0) {
            return null;
        }
        try {
            byte[] byArray = new byte[n];
            int n2 = inputStream.read(byArray);
            if (n2 != n) {
                if (n2 == -1) {
                    n2 = 0;
                }
                byte[] byArray2 = byArray;
                byArray = new byte[n2];
                System.arraycopy(byArray2, 0, byArray, 0, n2);
            }
            return this.transBytesForInput(byArray);
        }
        catch (IOException iOException) {
            throw new SQLExceptionSapDB(iOException.getMessage());
        }
    }

    public InputStream getBinaryStream(SQLParamController sQLParamController, StructuredMem structuredMem, StructuredMem structuredMem2) throws SQLException {
        byte[] byArray = this.getBytes(sQLParamController, structuredMem);
        if (byArray == null) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        return byteArrayInputStream;
    }
}

