/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.htmlparser.impl;

import nu.validator.htmlparser.annotation.Auto;
import nu.validator.htmlparser.annotation.Const;
import nu.validator.htmlparser.annotation.Inline;
import nu.validator.htmlparser.annotation.Local;
import nu.validator.htmlparser.annotation.NoLength;
import nu.validator.htmlparser.common.EncodingDeclarationHandler;
import nu.validator.htmlparser.common.Interner;
import nu.validator.htmlparser.common.TokenHandler;
import nu.validator.htmlparser.common.XmlViolationPolicy;
import nu.validator.htmlparser.impl.AttributeName;
import nu.validator.htmlparser.impl.ElementName;
import nu.validator.htmlparser.impl.HtmlAttributes;
import nu.validator.htmlparser.impl.LocatorImpl;
import nu.validator.htmlparser.impl.NamedCharacters;
import nu.validator.htmlparser.impl.Portability;
import nu.validator.htmlparser.impl.TreeBuilder;
import nu.validator.htmlparser.impl.UTF16Buffer;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Tokenizer
implements Locator {
    private static final int DATA_AND_RCDATA_MASK = -2;
    public static final int DATA = 0;
    public static final int RCDATA = 1;
    public static final int SCRIPT_DATA = 2;
    public static final int RAWTEXT = 3;
    public static final int SCRIPT_DATA_ESCAPED = 4;
    public static final int ATTRIBUTE_VALUE_DOUBLE_QUOTED = 5;
    public static final int ATTRIBUTE_VALUE_SINGLE_QUOTED = 6;
    public static final int ATTRIBUTE_VALUE_UNQUOTED = 7;
    public static final int PLAINTEXT = 8;
    public static final int TAG_OPEN = 9;
    public static final int CLOSE_TAG_OPEN = 10;
    public static final int TAG_NAME = 11;
    public static final int BEFORE_ATTRIBUTE_NAME = 12;
    public static final int ATTRIBUTE_NAME = 13;
    public static final int AFTER_ATTRIBUTE_NAME = 14;
    public static final int BEFORE_ATTRIBUTE_VALUE = 15;
    public static final int AFTER_ATTRIBUTE_VALUE_QUOTED = 16;
    public static final int BOGUS_COMMENT = 17;
    public static final int MARKUP_DECLARATION_OPEN = 18;
    public static final int DOCTYPE = 19;
    public static final int BEFORE_DOCTYPE_NAME = 20;
    public static final int DOCTYPE_NAME = 21;
    public static final int AFTER_DOCTYPE_NAME = 22;
    public static final int BEFORE_DOCTYPE_PUBLIC_IDENTIFIER = 23;
    public static final int DOCTYPE_PUBLIC_IDENTIFIER_DOUBLE_QUOTED = 24;
    public static final int DOCTYPE_PUBLIC_IDENTIFIER_SINGLE_QUOTED = 25;
    public static final int AFTER_DOCTYPE_PUBLIC_IDENTIFIER = 26;
    public static final int BEFORE_DOCTYPE_SYSTEM_IDENTIFIER = 27;
    public static final int DOCTYPE_SYSTEM_IDENTIFIER_DOUBLE_QUOTED = 28;
    public static final int DOCTYPE_SYSTEM_IDENTIFIER_SINGLE_QUOTED = 29;
    public static final int AFTER_DOCTYPE_SYSTEM_IDENTIFIER = 30;
    public static final int BOGUS_DOCTYPE = 31;
    public static final int COMMENT_START = 32;
    public static final int COMMENT_START_DASH = 33;
    public static final int COMMENT = 34;
    public static final int COMMENT_END_DASH = 35;
    public static final int COMMENT_END = 36;
    public static final int COMMENT_END_BANG = 37;
    public static final int NON_DATA_END_TAG_NAME = 38;
    public static final int MARKUP_DECLARATION_HYPHEN = 39;
    public static final int MARKUP_DECLARATION_OCTYPE = 40;
    public static final int DOCTYPE_UBLIC = 41;
    public static final int DOCTYPE_YSTEM = 42;
    public static final int AFTER_DOCTYPE_PUBLIC_KEYWORD = 43;
    public static final int BETWEEN_DOCTYPE_PUBLIC_AND_SYSTEM_IDENTIFIERS = 44;
    public static final int AFTER_DOCTYPE_SYSTEM_KEYWORD = 45;
    public static final int CONSUME_CHARACTER_REFERENCE = 46;
    public static final int CONSUME_NCR = 47;
    public static final int CHARACTER_REFERENCE_TAIL = 48;
    public static final int HEX_NCR_LOOP = 49;
    public static final int DECIMAL_NRC_LOOP = 50;
    public static final int HANDLE_NCR_VALUE = 51;
    public static final int HANDLE_NCR_VALUE_RECONSUME = 52;
    public static final int CHARACTER_REFERENCE_HILO_LOOKUP = 53;
    public static final int SELF_CLOSING_START_TAG = 54;
    public static final int CDATA_START = 55;
    public static final int CDATA_SECTION = 56;
    public static final int CDATA_RSQB = 57;
    public static final int CDATA_RSQB_RSQB = 58;
    public static final int SCRIPT_DATA_LESS_THAN_SIGN = 59;
    public static final int SCRIPT_DATA_ESCAPE_START = 60;
    public static final int SCRIPT_DATA_ESCAPE_START_DASH = 61;
    public static final int SCRIPT_DATA_ESCAPED_DASH = 62;
    public static final int SCRIPT_DATA_ESCAPED_DASH_DASH = 63;
    public static final int BOGUS_COMMENT_HYPHEN = 64;
    public static final int RAWTEXT_RCDATA_LESS_THAN_SIGN = 65;
    public static final int SCRIPT_DATA_ESCAPED_LESS_THAN_SIGN = 66;
    public static final int SCRIPT_DATA_DOUBLE_ESCAPE_START = 67;
    public static final int SCRIPT_DATA_DOUBLE_ESCAPED = 68;
    public static final int SCRIPT_DATA_DOUBLE_ESCAPED_LESS_THAN_SIGN = 69;
    public static final int SCRIPT_DATA_DOUBLE_ESCAPED_DASH = 70;
    public static final int SCRIPT_DATA_DOUBLE_ESCAPED_DASH_DASH = 71;
    public static final int SCRIPT_DATA_DOUBLE_ESCAPE_END = 72;
    private static final int LEAD_OFFSET = 55232;
    @NoLength
    private static final char[] LT_GT = new char[]{'<', '>'};
    @NoLength
    private static final char[] LT_SOLIDUS = new char[]{'<', '/'};
    @NoLength
    private static final char[] RSQB_RSQB = new char[]{']', ']'};
    @NoLength
    private static final char[] REPLACEMENT_CHARACTER = new char[]{'\ufffd'};
    @NoLength
    private static final char[] SPACE = new char[]{' '};
    @NoLength
    private static final char[] LF = new char[]{'\n'};
    private static final int BUFFER_GROW_BY = 1024;
    @NoLength
    private static final char[] CDATA_LSQB = "CDATA[".toCharArray();
    @NoLength
    private static final char[] OCTYPE = "octype".toCharArray();
    @NoLength
    private static final char[] UBLIC = "ublic".toCharArray();
    @NoLength
    private static final char[] YSTEM = "ystem".toCharArray();
    private static final char[] TITLE_ARR = new char[]{'t', 'i', 't', 'l', 'e'};
    private static final char[] SCRIPT_ARR = new char[]{'s', 'c', 'r', 'i', 'p', 't'};
    private static final char[] STYLE_ARR = new char[]{'s', 't', 'y', 'l', 'e'};
    private static final char[] PLAINTEXT_ARR = new char[]{'p', 'l', 'a', 'i', 'n', 't', 'e', 'x', 't'};
    private static final char[] XMP_ARR = new char[]{'x', 'm', 'p'};
    private static final char[] TEXTAREA_ARR = new char[]{'t', 'e', 'x', 't', 'a', 'r', 'e', 'a'};
    private static final char[] IFRAME_ARR = new char[]{'i', 'f', 'r', 'a', 'm', 'e'};
    private static final char[] NOEMBED_ARR = new char[]{'n', 'o', 'e', 'm', 'b', 'e', 'd'};
    private static final char[] NOSCRIPT_ARR = new char[]{'n', 'o', 's', 'c', 'r', 'i', 'p', 't'};
    private static final char[] NOFRAMES_ARR = new char[]{'n', 'o', 'f', 'r', 'a', 'm', 'e', 's'};
    protected final TokenHandler tokenHandler;
    protected EncodingDeclarationHandler encodingDeclarationHandler;
    protected ErrorHandler errorHandler;
    protected boolean lastCR;
    protected int stateSave;
    private int returnStateSave;
    protected int index;
    private boolean forceQuirks;
    private char additional;
    private int entCol;
    private int firstCharKey;
    private int lo;
    private int hi;
    private int candidate;
    private int strBufMark;
    private int prevValue;
    protected int value;
    private boolean seenDigits;
    protected int cstart;
    private String publicId;
    private String systemId;
    @Auto
    private char[] strBuf;
    private int strBufLen;
    @Auto
    private char[] longStrBuf;
    private int longStrBufLen;
    @Auto
    private final char[] bmpChar;
    @Auto
    private final char[] astralChar;
    protected ElementName endTagExpectation = null;
    private char[] endTagExpectationAsArray;
    protected boolean endTag;
    private ElementName tagName = null;
    protected AttributeName attributeName = null;
    private boolean wantsComments = false;
    protected boolean html4;
    private boolean metaBoundaryPassed;
    @Local
    private String doctypeName;
    private String publicIdentifier;
    private String systemIdentifier;
    private HtmlAttributes attributes;
    private XmlViolationPolicy contentSpacePolicy = XmlViolationPolicy.ALTER_INFOSET;
    private XmlViolationPolicy commentPolicy = XmlViolationPolicy.ALTER_INFOSET;
    private XmlViolationPolicy xmlnsPolicy = XmlViolationPolicy.ALTER_INFOSET;
    private XmlViolationPolicy namePolicy = XmlViolationPolicy.ALTER_INFOSET;
    private boolean html4ModeCompatibleWithXhtml1Schemata;
    private final boolean newAttributesEachTime;
    private int mappingLangToXmlLang;
    private boolean shouldSuspend;
    protected boolean confident;
    private int line;
    private Interner interner;
    protected LocatorImpl ampersandLocation;

    public Tokenizer(TokenHandler tokenHandler, boolean newAttributesEachTime) {
        this.tokenHandler = tokenHandler;
        this.encodingDeclarationHandler = null;
        this.newAttributesEachTime = newAttributesEachTime;
        this.bmpChar = new char[1];
        this.astralChar = new char[2];
        this.tagName = null;
        this.attributeName = null;
        this.doctypeName = null;
        this.publicIdentifier = null;
        this.systemIdentifier = null;
        this.attributes = null;
    }

    public Tokenizer(TokenHandler tokenHandler) {
        this.tokenHandler = tokenHandler;
        this.encodingDeclarationHandler = null;
        this.newAttributesEachTime = false;
        this.bmpChar = new char[1];
        this.astralChar = new char[2];
        this.tagName = null;
        this.attributeName = null;
        this.doctypeName = null;
        this.publicIdentifier = null;
        this.systemIdentifier = null;
        this.attributes = null;
    }

    public void setInterner(Interner interner) {
        this.interner = interner;
    }

    public void initLocation(String newPublicId, String newSystemId) {
        this.systemId = newSystemId;
        this.publicId = newPublicId;
    }

    public boolean isMappingLangToXmlLang() {
        return this.mappingLangToXmlLang == 3;
    }

    public void setMappingLangToXmlLang(boolean mappingLangToXmlLang) {
        this.mappingLangToXmlLang = mappingLangToXmlLang ? 3 : 0;
    }

    public void setErrorHandler(ErrorHandler eh) {
        this.errorHandler = eh;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setCommentPolicy(XmlViolationPolicy commentPolicy) {
        this.commentPolicy = commentPolicy;
    }

    public void setContentNonXmlCharPolicy(XmlViolationPolicy contentNonXmlCharPolicy) {
        if (contentNonXmlCharPolicy != XmlViolationPolicy.ALLOW) {
            throw new IllegalArgumentException("Must use ErrorReportingTokenizer to set contentNonXmlCharPolicy to non-ALLOW.");
        }
    }

    public void setContentSpacePolicy(XmlViolationPolicy contentSpacePolicy) {
        this.contentSpacePolicy = contentSpacePolicy;
    }

    public void setXmlnsPolicy(XmlViolationPolicy xmlnsPolicy) {
        if (xmlnsPolicy == XmlViolationPolicy.FATAL) {
            throw new IllegalArgumentException("Can't use FATAL here.");
        }
        this.xmlnsPolicy = xmlnsPolicy;
    }

    public void setNamePolicy(XmlViolationPolicy namePolicy) {
        this.namePolicy = namePolicy;
    }

    public void setHtml4ModeCompatibleWithXhtml1Schemata(boolean html4ModeCompatibleWithXhtml1Schemata) {
        this.html4ModeCompatibleWithXhtml1Schemata = html4ModeCompatibleWithXhtml1Schemata;
    }

    public void setStateAndEndTagExpectation(int specialTokenizerState, @Local String endTagExpectation) {
        this.stateSave = specialTokenizerState;
        if (specialTokenizerState == 0) {
            return;
        }
        char[] asArray = Portability.newCharArrayFromLocal(endTagExpectation);
        this.endTagExpectation = ElementName.elementNameByBuffer(asArray, 0, asArray.length, this.interner);
        this.endTagExpectationToArray();
    }

    public void setStateAndEndTagExpectation(int specialTokenizerState, ElementName endTagExpectation) {
        this.stateSave = specialTokenizerState;
        this.endTagExpectation = endTagExpectation;
        this.endTagExpectationToArray();
    }

    private void endTagExpectationToArray() {
        switch (this.endTagExpectation.getGroup()) {
            case 36: {
                this.endTagExpectationAsArray = TITLE_ARR;
                return;
            }
            case 31: {
                this.endTagExpectationAsArray = SCRIPT_ARR;
                return;
            }
            case 33: {
                this.endTagExpectationAsArray = STYLE_ARR;
                return;
            }
            case 30: {
                this.endTagExpectationAsArray = PLAINTEXT_ARR;
                return;
            }
            case 38: {
                this.endTagExpectationAsArray = XMP_ARR;
                return;
            }
            case 35: {
                this.endTagExpectationAsArray = TEXTAREA_ARR;
                return;
            }
            case 47: {
                this.endTagExpectationAsArray = IFRAME_ARR;
                return;
            }
            case 60: {
                this.endTagExpectationAsArray = NOEMBED_ARR;
                return;
            }
            case 26: {
                this.endTagExpectationAsArray = NOSCRIPT_ARR;
                return;
            }
            case 25: {
                this.endTagExpectationAsArray = NOFRAMES_ARR;
                return;
            }
        }
        assert (false) : "Bad end tag expectation.";
    }

    public void setLineNumber(int line) {
        this.line = line;
    }

    @Override
    @Inline
    public int getLineNumber() {
        return this.line;
    }

    @Override
    @Inline
    public int getColumnNumber() {
        return -1;
    }

    @Override
    public String getPublicId() {
        return this.publicId;
    }

    @Override
    public String getSystemId() {
        return this.systemId;
    }

    public void notifyAboutMetaBoundary() {
        this.metaBoundaryPassed = true;
    }

    void turnOnAdditionalHtml4Errors() {
        this.html4 = true;
    }

    HtmlAttributes emptyAttributes() {
        if (this.newAttributesEachTime) {
            return new HtmlAttributes(this.mappingLangToXmlLang);
        }
        return HtmlAttributes.EMPTY_ATTRIBUTES;
    }

    @Inline
    private void clearStrBufAndAppend(char c) {
        this.strBuf[0] = c;
        this.strBufLen = 1;
    }

    @Inline
    private void clearStrBuf() {
        this.strBufLen = 0;
    }

    private void appendStrBuf(char c) {
        if (this.strBufLen == this.strBuf.length) {
            char[] newBuf = new char[this.strBuf.length + 1024];
            System.arraycopy(this.strBuf, 0, newBuf, 0, this.strBuf.length);
            this.strBuf = newBuf;
        }
        this.strBuf[this.strBufLen++] = c;
    }

    protected String strBufToString() {
        return Portability.newStringFromBuffer(this.strBuf, 0, this.strBufLen);
    }

    private void strBufToDoctypeName() {
        this.doctypeName = Portability.newLocalNameFromBuffer(this.strBuf, 0, this.strBufLen, this.interner);
    }

    private void emitStrBuf() throws SAXException {
        if (this.strBufLen > 0) {
            this.tokenHandler.characters(this.strBuf, 0, this.strBufLen);
        }
    }

    @Inline
    private void clearLongStrBuf() {
        this.longStrBufLen = 0;
    }

    @Inline
    private void clearLongStrBufAndAppend(char c) {
        this.longStrBuf[0] = c;
        this.longStrBufLen = 1;
    }

    private void appendLongStrBuf(char c) {
        if (this.longStrBufLen == this.longStrBuf.length) {
            char[] newBuf = new char[this.longStrBufLen + (this.longStrBufLen >> 1)];
            System.arraycopy(this.longStrBuf, 0, newBuf, 0, this.longStrBuf.length);
            this.longStrBuf = newBuf;
        }
        this.longStrBuf[this.longStrBufLen++] = c;
    }

    @Inline
    private void appendSecondHyphenToBogusComment() throws SAXException {
        switch (this.commentPolicy) {
            case ALTER_INFOSET: {
                this.appendLongStrBuf(' ');
            }
            case ALLOW: {
                this.warn("The document is not mappable to XML 1.0 due to two consecutive hyphens in a comment.");
                this.appendLongStrBuf('-');
                break;
            }
            case FATAL: {
                this.fatal("The document is not mappable to XML 1.0 due to two consecutive hyphens in a comment.");
            }
        }
    }

    private void maybeAppendSpaceToBogusComment() throws SAXException {
        switch (this.commentPolicy) {
            case ALTER_INFOSET: {
                this.appendLongStrBuf(' ');
            }
            case ALLOW: {
                this.warn("The document is not mappable to XML 1.0 due to a trailing hyphen in a comment.");
                break;
            }
            case FATAL: {
                this.fatal("The document is not mappable to XML 1.0 due to a trailing hyphen in a comment.");
            }
        }
    }

    @Inline
    private void adjustDoubleHyphenAndAppendToLongStrBufAndErr(char c) throws SAXException {
        this.errConsecutiveHyphens();
        switch (this.commentPolicy) {
            case ALTER_INFOSET: {
                --this.longStrBufLen;
                this.appendLongStrBuf(' ');
                this.appendLongStrBuf('-');
            }
            case ALLOW: {
                this.warn("The document is not mappable to XML 1.0 due to two consecutive hyphens in a comment.");
                this.appendLongStrBuf(c);
                break;
            }
            case FATAL: {
                this.fatal("The document is not mappable to XML 1.0 due to two consecutive hyphens in a comment.");
            }
        }
    }

    private void appendLongStrBuf(@NoLength char[] buffer, int offset, int length) {
        int reqLen = this.longStrBufLen + length;
        if (this.longStrBuf.length < reqLen) {
            char[] newBuf = new char[reqLen + (reqLen >> 1)];
            System.arraycopy(this.longStrBuf, 0, newBuf, 0, this.longStrBuf.length);
            this.longStrBuf = newBuf;
        }
        System.arraycopy(buffer, offset, this.longStrBuf, this.longStrBufLen, length);
        this.longStrBufLen = reqLen;
    }

    @Inline
    private void appendStrBufToLongStrBuf() {
        this.appendLongStrBuf(this.strBuf, 0, this.strBufLen);
    }

    private String longStrBufToString() {
        return Portability.newStringFromBuffer(this.longStrBuf, 0, this.longStrBufLen);
    }

    private void emitComment(int provisionalHyphens, int pos) throws SAXException {
        if (this.wantsComments) {
            this.tokenHandler.comment(this.longStrBuf, 0, this.longStrBufLen - provisionalHyphens);
        }
        this.cstart = pos + 1;
    }

    protected void flushChars(@NoLength char[] buf, int pos) throws SAXException {
        if (pos > this.cstart) {
            this.tokenHandler.characters(buf, this.cstart, pos - this.cstart);
        }
        this.cstart = Integer.MAX_VALUE;
    }

    public void fatal(String message) throws SAXException {
        SAXParseException spe = new SAXParseException(message, this);
        if (this.errorHandler != null) {
            this.errorHandler.fatalError(spe);
        }
        throw spe;
    }

    public void err(String message) throws SAXException {
        if (this.errorHandler == null) {
            return;
        }
        SAXParseException spe = new SAXParseException(message, this);
        this.errorHandler.error(spe);
    }

    public void errTreeBuilder(String message) throws SAXException {
        ErrorHandler eh = null;
        if (this.tokenHandler instanceof TreeBuilder) {
            TreeBuilder treeBuilder = (TreeBuilder)this.tokenHandler;
            eh = treeBuilder.getErrorHandler();
        }
        if (eh == null) {
            eh = this.errorHandler;
        }
        if (eh == null) {
            return;
        }
        SAXParseException spe = new SAXParseException(message, this);
        eh.error(spe);
    }

    public void warn(String message) throws SAXException {
        if (this.errorHandler == null) {
            return;
        }
        SAXParseException spe = new SAXParseException(message, this);
        this.errorHandler.warning(spe);
    }

    private void resetAttributes() {
        if (this.newAttributesEachTime) {
            this.attributes = null;
        } else {
            this.attributes.clear(this.mappingLangToXmlLang);
        }
    }

    private void strBufToElementNameString() {
        this.tagName = ElementName.elementNameByBuffer(this.strBuf, 0, this.strBufLen, this.interner);
    }

    private int emitCurrentTagToken(boolean selfClosing, int pos) throws SAXException {
        HtmlAttributes attrs;
        this.cstart = pos + 1;
        this.maybeErrSlashInEndTag(selfClosing);
        this.stateSave = 0;
        HtmlAttributes htmlAttributes = attrs = this.attributes == null ? HtmlAttributes.EMPTY_ATTRIBUTES : this.attributes;
        if (this.endTag) {
            this.maybeErrAttributesOnEndTag(attrs);
            this.tokenHandler.endTag(this.tagName);
            Portability.delete(this.attributes);
        } else {
            this.tokenHandler.startTag(this.tagName, attrs, selfClosing);
        }
        this.tagName.release();
        this.tagName = null;
        this.resetAttributes();
        return this.stateSave;
    }

    private void attributeNameComplete() throws SAXException {
        this.attributeName = AttributeName.nameByBuffer(this.strBuf, 0, this.strBufLen, this.namePolicy != XmlViolationPolicy.ALLOW, this.interner);
        if (this.attributes == null) {
            this.attributes = new HtmlAttributes(this.mappingLangToXmlLang);
        }
        if (this.attributes.contains(this.attributeName)) {
            this.errDuplicateAttribute();
            this.attributeName.release();
            this.attributeName = null;
        }
    }

    private void addAttributeWithoutValue() throws SAXException {
        this.noteAttributeWithoutValue();
        if (this.metaBoundaryPassed && AttributeName.CHARSET == this.attributeName && ElementName.META == this.tagName) {
            this.err("A \u201ccharset\u201d attribute on a \u201cmeta\u201d element found after the first 512 bytes.");
        }
        if (this.attributeName != null) {
            if (this.html4) {
                if (this.attributeName.isBoolean()) {
                    if (this.html4ModeCompatibleWithXhtml1Schemata) {
                        this.attributes.addAttribute(this.attributeName, this.attributeName.getLocal(0), this.xmlnsPolicy);
                    } else {
                        this.attributes.addAttribute(this.attributeName, "", this.xmlnsPolicy);
                    }
                } else {
                    this.err("Attribute value omitted for a non-boolean attribute. (HTML4-only error.)");
                    this.attributes.addAttribute(this.attributeName, "", this.xmlnsPolicy);
                }
            } else {
                if (AttributeName.SRC == this.attributeName || AttributeName.HREF == this.attributeName) {
                    this.warn("Attribute \u201c" + this.attributeName.getLocal(0) + "\u201d without an explicit value seen. The attribute may be dropped by IE7.");
                }
                this.attributes.addAttribute(this.attributeName, Portability.newEmptyString(), this.xmlnsPolicy);
            }
            this.attributeName = null;
        }
    }

    private void addAttributeWithValue() throws SAXException {
        if (this.metaBoundaryPassed && ElementName.META == this.tagName && AttributeName.CHARSET == this.attributeName) {
            this.err("A \u201ccharset\u201d attribute on a \u201cmeta\u201d element found after the first 512 bytes.");
        }
        if (this.attributeName != null) {
            String val = this.longStrBufToString();
            if (!this.endTag && this.html4 && this.html4ModeCompatibleWithXhtml1Schemata && this.attributeName.isCaseFolded()) {
                val = Tokenizer.newAsciiLowerCaseStringFromString(val);
            }
            this.attributes.addAttribute(this.attributeName, val, this.xmlnsPolicy);
            this.attributeName = null;
        }
    }

    private static String newAsciiLowerCaseStringFromString(String str) {
        if (str == null) {
            return null;
        }
        char[] buf = new char[str.length()];
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (c >= 'A' && c <= 'Z') {
                c = (char)(c + 32);
            }
            buf[i] = c;
            ++i;
        }
        return new String(buf);
    }

    protected void startErrorReporting() throws SAXException {
    }

    public void start() throws SAXException {
        this.initializeWithoutStarting();
        this.tokenHandler.startTokenization(this);
        this.startErrorReporting();
    }

    public boolean tokenizeBuffer(UTF16Buffer buffer) throws SAXException {
        int state = this.stateSave;
        int returnState = this.returnStateSave;
        char c = '\u0000';
        this.shouldSuspend = false;
        this.lastCR = false;
        int start = buffer.getStart();
        int pos = start - 1;
        switch (state) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 56: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: {
                this.cstart = start;
                break;
            }
            default: {
                this.cstart = Integer.MAX_VALUE;
            }
        }
        pos = this.stateLoop(state, c, pos, buffer.getBuffer(), false, returnState, buffer.getEnd());
        if (pos == buffer.getEnd()) {
            buffer.setStart(pos);
        } else {
            buffer.setStart(pos + 1);
        }
        return this.lastCR;
    }

    /*
     * Exception decompiling
     */
    private int stateLoop(int state, char c, int pos, @NoLength char[] buf, boolean reconsume, int returnState, int endPos) throws SAXException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [481[WHILELOOP]], but top level block is 9[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected int transition(int from, int to, boolean reconsume, int pos) throws SAXException {
        return to;
    }

    private void initDoctypeFields() {
        this.doctypeName = "";
        if (this.systemIdentifier != null) {
            Portability.releaseString(this.systemIdentifier);
            this.systemIdentifier = null;
        }
        if (this.publicIdentifier != null) {
            Portability.releaseString(this.publicIdentifier);
            this.publicIdentifier = null;
        }
        this.forceQuirks = false;
    }

    @Inline
    private void adjustDoubleHyphenAndAppendToLongStrBufCarriageReturn() throws SAXException {
        this.silentCarriageReturn();
        this.adjustDoubleHyphenAndAppendToLongStrBufAndErr('\n');
    }

    @Inline
    private void adjustDoubleHyphenAndAppendToLongStrBufLineFeed() throws SAXException {
        this.silentLineFeed();
        this.adjustDoubleHyphenAndAppendToLongStrBufAndErr('\n');
    }

    @Inline
    private void appendLongStrBufLineFeed() {
        this.silentLineFeed();
        this.appendLongStrBuf('\n');
    }

    @Inline
    private void appendLongStrBufCarriageReturn() {
        this.silentCarriageReturn();
        this.appendLongStrBuf('\n');
    }

    @Inline
    protected void silentCarriageReturn() {
        ++this.line;
        this.lastCR = true;
    }

    @Inline
    protected void silentLineFeed() {
        ++this.line;
    }

    private void emitCarriageReturn(@NoLength char[] buf, int pos) throws SAXException {
        this.silentCarriageReturn();
        this.flushChars(buf, pos);
        this.tokenHandler.characters(LF, 0, 1);
        this.cstart = Integer.MAX_VALUE;
    }

    private void emitReplacementCharacter(@NoLength char[] buf, int pos) throws SAXException {
        this.flushChars(buf, pos);
        this.tokenHandler.zeroOriginatingReplacementCharacter();
        this.cstart = pos + 1;
    }

    private void emitPlaintextReplacementCharacter(@NoLength char[] buf, int pos) throws SAXException {
        this.flushChars(buf, pos);
        this.tokenHandler.characters(REPLACEMENT_CHARACTER, 0, 1);
        this.cstart = pos + 1;
    }

    private void setAdditionalAndRememberAmpersandLocation(char add) {
        this.additional = add;
        this.ampersandLocation = new LocatorImpl(this);
    }

    private void bogusDoctype() throws SAXException {
        this.errBogusDoctype();
        this.forceQuirks = true;
    }

    private void bogusDoctypeWithoutQuirks() throws SAXException {
        this.errBogusDoctype();
        this.forceQuirks = false;
    }

    private void emitOrAppendStrBuf(int returnState) throws SAXException {
        if ((returnState & 0xFFFFFFFE) != 0) {
            this.appendStrBufToLongStrBuf();
        } else {
            this.emitStrBuf();
        }
    }

    private void handleNcrValue(int returnState) throws SAXException {
        if (this.value <= 65535) {
            if (this.value >= 128 && this.value <= 159) {
                this.errNcrInC1Range();
                char[] val = NamedCharacters.WINDOWS_1252[this.value - 128];
                this.emitOrAppendOne(val, returnState);
            } else if (this.value == 12 && this.contentSpacePolicy != XmlViolationPolicy.ALLOW) {
                if (this.contentSpacePolicy == XmlViolationPolicy.ALTER_INFOSET) {
                    this.emitOrAppendOne(SPACE, returnState);
                } else if (this.contentSpacePolicy == XmlViolationPolicy.FATAL) {
                    this.fatal("A character reference expanded to a form feed which is not legal XML 1.0 white space.");
                }
            } else if (this.value == 0) {
                this.errNcrZero();
                this.emitOrAppendOne(REPLACEMENT_CHARACTER, returnState);
            } else if ((this.value & 0xF800) == 55296) {
                this.errNcrSurrogate();
                this.emitOrAppendOne(REPLACEMENT_CHARACTER, returnState);
            } else {
                char ch = (char)this.value;
                if (this.value == 13) {
                    this.errNcrCr();
                } else if (this.value <= 8 || this.value == 11 || this.value >= 14 && this.value <= 31) {
                    ch = this.errNcrControlChar(ch);
                } else if (this.value >= 64976 && this.value <= 65007) {
                    this.errNcrUnassigned();
                } else if ((this.value & 0xFFFE) == 65534) {
                    ch = this.errNcrNonCharacter(ch);
                } else if (this.value >= 127 && this.value <= 159) {
                    this.errNcrControlChar();
                } else {
                    this.maybeWarnPrivateUse(ch);
                }
                this.bmpChar[0] = ch;
                this.emitOrAppendOne(this.bmpChar, returnState);
            }
        } else if (this.value <= 0x10FFFF) {
            this.maybeWarnPrivateUseAstral();
            if ((this.value & 0xFFFE) == 65534) {
                this.errAstralNonCharacter(this.value);
            }
            this.astralChar[0] = (char)(55232 + (this.value >> 10));
            this.astralChar[1] = (char)(56320 + (this.value & 0x3FF));
            this.emitOrAppendTwo(this.astralChar, returnState);
        } else {
            this.errNcrOutOfRange();
            this.emitOrAppendOne(REPLACEMENT_CHARACTER, returnState);
        }
    }

    public void eof() throws SAXException {
        int state = this.stateSave;
        int returnState = this.returnStateSave;
        block35: while (true) {
            switch (state) {
                case 59: 
                case 66: {
                    this.tokenHandler.characters(LT_GT, 0, 1);
                    break block35;
                }
                case 9: {
                    this.errEofAfterLt();
                    this.tokenHandler.characters(LT_GT, 0, 1);
                    break block35;
                }
                case 65: {
                    this.tokenHandler.characters(LT_GT, 0, 1);
                    break block35;
                }
                case 38: {
                    this.tokenHandler.characters(LT_SOLIDUS, 0, 2);
                    this.emitStrBuf();
                    break block35;
                }
                case 10: {
                    this.errEofAfterLt();
                    this.tokenHandler.characters(LT_SOLIDUS, 0, 2);
                    break block35;
                }
                case 11: {
                    this.errEofInTagName();
                    break block35;
                }
                case 12: 
                case 16: 
                case 54: {
                    this.errEofWithoutGt();
                    break block35;
                }
                case 13: {
                    this.errEofInAttributeName();
                    break block35;
                }
                case 14: 
                case 15: {
                    this.errEofWithoutGt();
                    break block35;
                }
                case 5: 
                case 6: 
                case 7: {
                    this.errEofInAttributeValue();
                    break block35;
                }
                case 17: {
                    this.emitComment(0, 0);
                    break block35;
                }
                case 64: {
                    this.maybeAppendSpaceToBogusComment();
                    this.emitComment(0, 0);
                    break block35;
                }
                case 18: {
                    this.errBogusComment();
                    this.clearLongStrBuf();
                    this.emitComment(0, 0);
                    break block35;
                }
                case 39: {
                    this.errBogusComment();
                    this.emitComment(0, 0);
                    break block35;
                }
                case 40: {
                    if (this.index < 6) {
                        this.errBogusComment();
                        this.emitComment(0, 0);
                        break block35;
                    }
                    this.errEofInDoctype();
                    this.doctypeName = "";
                    if (this.systemIdentifier != null) {
                        Portability.releaseString(this.systemIdentifier);
                        this.systemIdentifier = null;
                    }
                    if (this.publicIdentifier != null) {
                        Portability.releaseString(this.publicIdentifier);
                        this.publicIdentifier = null;
                    }
                    this.forceQuirks = true;
                    this.emitDoctypeToken(0);
                    break block35;
                }
                case 32: 
                case 34: {
                    this.errEofInComment();
                    this.emitComment(0, 0);
                    break block35;
                }
                case 36: {
                    this.errEofInComment();
                    this.emitComment(2, 0);
                    break block35;
                }
                case 33: 
                case 35: {
                    this.errEofInComment();
                    this.emitComment(1, 0);
                    break block35;
                }
                case 37: {
                    this.errEofInComment();
                    this.emitComment(3, 0);
                    break block35;
                }
                case 19: 
                case 20: {
                    this.errEofInDoctype();
                    this.forceQuirks = true;
                    this.emitDoctypeToken(0);
                    break block35;
                }
                case 21: {
                    this.errEofInDoctype();
                    this.strBufToDoctypeName();
                    this.forceQuirks = true;
                    this.emitDoctypeToken(0);
                    break block35;
                }
                case 22: 
                case 23: 
                case 41: 
                case 42: 
                case 43: 
                case 45: {
                    this.errEofInDoctype();
                    this.forceQuirks = true;
                    this.emitDoctypeToken(0);
                    break block35;
                }
                case 24: 
                case 25: {
                    this.errEofInPublicId();
                    this.forceQuirks = true;
                    this.publicIdentifier = this.longStrBufToString();
                    this.emitDoctypeToken(0);
                    break block35;
                }
                case 26: 
                case 27: 
                case 44: {
                    this.errEofInDoctype();
                    this.forceQuirks = true;
                    this.emitDoctypeToken(0);
                    break block35;
                }
                case 28: 
                case 29: {
                    this.errEofInSystemId();
                    this.forceQuirks = true;
                    this.systemIdentifier = this.longStrBufToString();
                    this.emitDoctypeToken(0);
                    break block35;
                }
                case 30: {
                    this.errEofInDoctype();
                    this.forceQuirks = true;
                    this.emitDoctypeToken(0);
                    break block35;
                }
                case 31: {
                    this.emitDoctypeToken(0);
                    break block35;
                }
                case 46: {
                    this.emitOrAppendStrBuf(returnState);
                    state = returnState;
                    continue block35;
                }
                case 53: {
                    this.errNoNamedCharacterMatch();
                    this.emitOrAppendStrBuf(returnState);
                    state = returnState;
                    continue block35;
                }
                case 48: {
                    char[] val;
                    block36: while (true) {
                        char c = '\u0000';
                        ++this.entCol;
                        while (this.hi != -1 && this.entCol != NamedCharacters.NAMES[this.hi].length()) {
                            if (this.entCol > NamedCharacters.NAMES[this.hi].length()) break block36;
                            if (c >= NamedCharacters.NAMES[this.hi].charAt(this.entCol)) break;
                            --this.hi;
                        }
                        while (this.hi >= this.lo) {
                            if (this.entCol == NamedCharacters.NAMES[this.lo].length()) {
                                this.candidate = this.lo++;
                                this.strBufMark = this.strBufLen;
                                continue;
                            }
                            if (this.entCol > NamedCharacters.NAMES[this.lo].length()) break block36;
                            if (c <= NamedCharacters.NAMES[this.lo].charAt(this.entCol)) continue block36;
                            ++this.lo;
                            continue;
                            if (this.hi >= this.lo) continue block36;
                        }
                        break;
                    }
                    if (this.candidate == -1) {
                        this.errNoNamedCharacterMatch();
                        this.emitOrAppendStrBuf(returnState);
                        state = returnState;
                        continue block35;
                    }
                    String candidateName = NamedCharacters.NAMES[this.candidate];
                    if (candidateName.length() == 0 || candidateName.charAt(candidateName.length() - 1) != ';') {
                        int ch;
                        if ((returnState & 0xFFFFFFFE) != 0 && ((ch = this.strBufMark == this.strBufLen ? 0 : this.strBuf[this.strBufMark]) >= 48 && ch <= 57 || ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122)) {
                            this.errNoNamedCharacterMatch();
                            this.appendStrBufToLongStrBuf();
                            state = returnState;
                            continue block35;
                        }
                        if ((returnState & 0xFFFFFFFE) != 0) {
                            this.errUnescapedAmpersandInterpretedAsCharacterReference();
                        } else {
                            this.errNotSemicolonTerminated();
                        }
                    }
                    if ((val = NamedCharacters.VALUES[this.candidate]).length == 1) {
                        this.emitOrAppendOne(val, returnState);
                    } else {
                        this.emitOrAppendTwo(val, returnState);
                    }
                    if (this.strBufMark < this.strBufLen) {
                        if ((returnState & 0xFFFFFFFE) != 0) {
                            int i = this.strBufMark;
                            while (i < this.strBufLen) {
                                this.appendLongStrBuf(this.strBuf[i]);
                                ++i;
                            }
                        } else {
                            this.tokenHandler.characters(this.strBuf, this.strBufMark, this.strBufLen - this.strBufMark);
                        }
                    }
                    state = returnState;
                    continue block35;
                }
                case 47: 
                case 49: 
                case 50: {
                    if (!this.seenDigits) {
                        this.errNoDigitsInNCR();
                        this.emitOrAppendStrBuf(returnState);
                        state = returnState;
                        continue block35;
                    }
                    this.errCharRefLacksSemicolon();
                    this.handleNcrValue(returnState);
                    state = returnState;
                    continue block35;
                }
                case 57: {
                    this.tokenHandler.characters(RSQB_RSQB, 0, 1);
                    break block35;
                }
                case 58: {
                    this.tokenHandler.characters(RSQB_RSQB, 0, 2);
                    break block35;
                }
            }
            break;
        }
        this.tokenHandler.eof();
    }

    private void emitDoctypeToken(int pos) throws SAXException {
        this.cstart = pos + 1;
        this.tokenHandler.doctype(this.doctypeName, this.publicIdentifier, this.systemIdentifier, this.forceQuirks);
        this.doctypeName = null;
        Portability.releaseString(this.publicIdentifier);
        this.publicIdentifier = null;
        Portability.releaseString(this.systemIdentifier);
        this.systemIdentifier = null;
    }

    @Inline
    protected char checkChar(@NoLength char[] buf, int pos) throws SAXException {
        return buf[pos];
    }

    public boolean isAlreadyComplainedAboutNonAscii() {
        return true;
    }

    public boolean internalEncodingDeclaration(String internalCharset) throws SAXException {
        if (this.encodingDeclarationHandler != null) {
            return this.encodingDeclarationHandler.internalEncodingDeclaration(internalCharset);
        }
        return false;
    }

    private void emitOrAppendTwo(@Const @NoLength char[] val, int returnState) throws SAXException {
        if ((returnState & 0xFFFFFFFE) != 0) {
            this.appendLongStrBuf(val[0]);
            this.appendLongStrBuf(val[1]);
        } else {
            this.tokenHandler.characters(val, 0, 2);
        }
    }

    private void emitOrAppendOne(@Const @NoLength char[] val, int returnState) throws SAXException {
        if ((returnState & 0xFFFFFFFE) != 0) {
            this.appendLongStrBuf(val[0]);
        } else {
            this.tokenHandler.characters(val, 0, 1);
        }
    }

    public void end() throws SAXException {
        this.strBuf = null;
        this.longStrBuf = null;
        this.doctypeName = null;
        if (this.systemIdentifier != null) {
            Portability.releaseString(this.systemIdentifier);
            this.systemIdentifier = null;
        }
        if (this.publicIdentifier != null) {
            Portability.releaseString(this.publicIdentifier);
            this.publicIdentifier = null;
        }
        if (this.tagName != null) {
            this.tagName.release();
            this.tagName = null;
        }
        if (this.attributeName != null) {
            this.attributeName.release();
            this.attributeName = null;
        }
        this.tokenHandler.endTokenization();
        if (this.attributes != null) {
            this.attributes.clear(this.mappingLangToXmlLang);
            Portability.delete(this.attributes);
            this.attributes = null;
        }
    }

    public void requestSuspension() {
        this.shouldSuspend = true;
    }

    public void becomeConfident() {
        this.confident = true;
    }

    public boolean isNextCharOnNewLine() {
        return false;
    }

    public boolean isPrevCR() {
        return this.lastCR;
    }

    public int getLine() {
        return -1;
    }

    public int getCol() {
        return -1;
    }

    public boolean isInDataState() {
        return this.stateSave == 0;
    }

    public void resetToDataState() {
        this.strBufLen = 0;
        this.longStrBufLen = 0;
        this.stateSave = 0;
        this.lastCR = false;
        this.index = 0;
        this.forceQuirks = false;
        this.additional = '\u0000';
        this.entCol = -1;
        this.firstCharKey = -1;
        this.lo = 0;
        this.hi = 0;
        this.candidate = -1;
        this.strBufMark = 0;
        this.prevValue = -1;
        this.value = 0;
        this.seenDigits = false;
        this.endTag = false;
        this.shouldSuspend = false;
        this.initDoctypeFields();
        if (this.tagName != null) {
            this.tagName.release();
            this.tagName = null;
        }
        if (this.attributeName != null) {
            this.attributeName.release();
            this.attributeName = null;
        }
        if (this.newAttributesEachTime && this.attributes != null) {
            Portability.delete(this.attributes);
            this.attributes = null;
        }
    }

    public void loadState(Tokenizer other) throws SAXException {
        this.strBufLen = other.strBufLen;
        if (this.strBufLen > this.strBuf.length) {
            this.strBuf = new char[this.strBufLen];
        }
        System.arraycopy(other.strBuf, 0, this.strBuf, 0, this.strBufLen);
        this.longStrBufLen = other.longStrBufLen;
        if (this.longStrBufLen > this.longStrBuf.length) {
            this.longStrBuf = new char[this.longStrBufLen];
        }
        System.arraycopy(other.longStrBuf, 0, this.longStrBuf, 0, this.longStrBufLen);
        this.stateSave = other.stateSave;
        this.returnStateSave = other.returnStateSave;
        this.endTagExpectation = other.endTagExpectation;
        this.endTagExpectationAsArray = other.endTagExpectationAsArray;
        this.lastCR = other.lastCR;
        this.index = other.index;
        this.forceQuirks = other.forceQuirks;
        this.additional = other.additional;
        this.entCol = other.entCol;
        this.firstCharKey = other.firstCharKey;
        this.lo = other.lo;
        this.hi = other.hi;
        this.candidate = other.candidate;
        this.strBufMark = other.strBufMark;
        this.prevValue = other.prevValue;
        this.value = other.value;
        this.seenDigits = other.seenDigits;
        this.endTag = other.endTag;
        this.shouldSuspend = false;
        this.doctypeName = other.doctypeName == null ? null : Portability.newLocalFromLocal(other.doctypeName, this.interner);
        Portability.releaseString(this.systemIdentifier);
        this.systemIdentifier = other.systemIdentifier == null ? null : Portability.newStringFromString(other.systemIdentifier);
        Portability.releaseString(this.publicIdentifier);
        this.publicIdentifier = other.publicIdentifier == null ? null : Portability.newStringFromString(other.publicIdentifier);
        if (this.tagName != null) {
            this.tagName.release();
        }
        this.tagName = other.tagName == null ? null : other.tagName.cloneElementName(this.interner);
        if (this.attributeName != null) {
            this.attributeName.release();
        }
        this.attributeName = other.attributeName == null ? null : other.attributeName.cloneAttributeName(this.interner);
        if (this.attributes != null) {
            Portability.delete(this.attributes);
        }
        this.attributes = other.attributes == null ? null : other.attributes.cloneAttributes(this.interner);
    }

    public void initializeWithoutStarting() throws SAXException {
        this.confident = false;
        this.strBuf = new char[64];
        this.longStrBuf = new char[1024];
        this.line = 1;
        this.html4 = false;
        this.metaBoundaryPassed = false;
        this.wantsComments = this.tokenHandler.wantsComments();
        if (!this.newAttributesEachTime) {
            this.attributes = new HtmlAttributes(this.mappingLangToXmlLang);
        }
        this.resetToDataState();
    }

    protected void errGarbageAfterLtSlash() throws SAXException {
    }

    protected void errLtSlashGt() throws SAXException {
    }

    protected void errWarnLtSlashInRcdata() throws SAXException {
    }

    protected void errHtml4LtSlashInRcdata(char folded) throws SAXException {
    }

    protected void errCharRefLacksSemicolon() throws SAXException {
    }

    protected void errNoDigitsInNCR() throws SAXException {
    }

    protected void errGtInSystemId() throws SAXException {
    }

    protected void errGtInPublicId() throws SAXException {
    }

    protected void errNamelessDoctype() throws SAXException {
    }

    protected void errConsecutiveHyphens() throws SAXException {
    }

    protected void errPrematureEndOfComment() throws SAXException {
    }

    protected void errBogusComment() throws SAXException {
    }

    protected void errUnquotedAttributeValOrNull(char c) throws SAXException {
    }

    protected void errSlashNotFollowedByGt() throws SAXException {
    }

    protected void errHtml4XmlVoidSyntax() throws SAXException {
    }

    protected void errNoSpaceBetweenAttributes() throws SAXException {
    }

    protected void errHtml4NonNameInUnquotedAttribute(char c) throws SAXException {
    }

    protected void errLtOrEqualsOrGraveInUnquotedAttributeOrNull(char c) throws SAXException {
    }

    protected void errAttributeValueMissing() throws SAXException {
    }

    protected void errBadCharBeforeAttributeNameOrNull(char c) throws SAXException {
    }

    protected void errEqualsSignBeforeAttributeName() throws SAXException {
    }

    protected void errBadCharAfterLt(char c) throws SAXException {
    }

    protected void errLtGt() throws SAXException {
    }

    protected void errProcessingInstruction() throws SAXException {
    }

    protected void errUnescapedAmpersandInterpretedAsCharacterReference() throws SAXException {
    }

    protected void errNotSemicolonTerminated() throws SAXException {
    }

    protected void errNoNamedCharacterMatch() throws SAXException {
    }

    protected void errQuoteBeforeAttributeName(char c) throws SAXException {
    }

    protected void errQuoteOrLtInAttributeNameOrNull(char c) throws SAXException {
    }

    protected void errExpectedPublicId() throws SAXException {
    }

    protected void errBogusDoctype() throws SAXException {
    }

    protected void maybeWarnPrivateUseAstral() throws SAXException {
    }

    protected void maybeWarnPrivateUse(char ch) throws SAXException {
    }

    protected void maybeErrAttributesOnEndTag(HtmlAttributes attrs) throws SAXException {
    }

    protected void maybeErrSlashInEndTag(boolean selfClosing) throws SAXException {
    }

    protected char errNcrNonCharacter(char ch) throws SAXException {
        return ch;
    }

    protected void errAstralNonCharacter(int ch) throws SAXException {
    }

    protected void errNcrSurrogate() throws SAXException {
    }

    protected char errNcrControlChar(char ch) throws SAXException {
        return ch;
    }

    protected void errNcrCr() throws SAXException {
    }

    protected void errNcrInC1Range() throws SAXException {
    }

    protected void errEofInPublicId() throws SAXException {
    }

    protected void errEofInComment() throws SAXException {
    }

    protected void errEofInDoctype() throws SAXException {
    }

    protected void errEofInAttributeValue() throws SAXException {
    }

    protected void errEofInAttributeName() throws SAXException {
    }

    protected void errEofWithoutGt() throws SAXException {
    }

    protected void errEofInTagName() throws SAXException {
    }

    protected void errEofInEndTag() throws SAXException {
    }

    protected void errEofAfterLt() throws SAXException {
    }

    protected void errNcrOutOfRange() throws SAXException {
    }

    protected void errNcrUnassigned() throws SAXException {
    }

    protected void errDuplicateAttribute() throws SAXException {
    }

    protected void errEofInSystemId() throws SAXException {
    }

    protected void errExpectedSystemId() throws SAXException {
    }

    protected void errMissingSpaceBeforeDoctypeName() throws SAXException {
    }

    protected void errHyphenHyphenBang() throws SAXException {
    }

    protected void errNcrControlChar() throws SAXException {
    }

    protected void errNcrZero() throws SAXException {
    }

    protected void errNoSpaceBetweenDoctypeSystemKeywordAndQuote() throws SAXException {
    }

    protected void errNoSpaceBetweenPublicAndSystemIds() throws SAXException {
    }

    protected void errNoSpaceBetweenDoctypePublicKeywordAndQuote() throws SAXException {
    }

    protected void noteAttributeWithoutValue() throws SAXException {
    }

    protected void noteUnquotedAttributeValue() throws SAXException {
    }

    public void setEncodingDeclarationHandler(EncodingDeclarationHandler encodingDeclarationHandler) {
        this.encodingDeclarationHandler = encodingDeclarationHandler;
    }

    void destructor() {
    }

    public void setTransitionBaseOffset(int offset) {
    }
}

