/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.metadata;

import com.intersys.cache.Dataholder;
import com.intersys.cache.SysDatabase;
import com.intersys.cache.metadata.CacheClassMetadataImpl;
import com.intersys.cache.metadata.QueryParameter;
import com.intersys.classes.Compiler.LG.MetaQueryDef;
import com.intersys.jdbc.ConnectionInfo;
import com.intersys.jdbc.SysListProxy;
import com.intersys.objects.CacheException;
import com.intersys.objects.SList;
import com.intersys.objects.reflect.CacheArgumentInfo;
import com.intersys.objects.reflect.CacheClass;
import com.intersys.objects.reflect.CacheQueryDefinition;
import com.intersys.objects.reflect.CacheQueryMetadata;
import java.sql.SQLException;

abstract class CacheQueryMetadataImpl
implements Comparable,
CacheQueryDefinition {
    private MetaQueryDef mClientQueryDef;
    protected CacheClassMetadataImpl mClass;
    private String mStatement = null;
    private Object[] mDefArgs;
    private SList mColNames;
    private CacheArgumentInfo[] mParameters;
    private String mProcName;
    private String mName;
    private int mNumParam;

    public CacheQueryMetadataImpl(CacheClass cacheClass, MetaQueryDef metaQueryDef) throws CacheException {
        this.mClass = (CacheClassMetadataImpl)cacheClass;
        this.mClientQueryDef = metaQueryDef;
        SList sList = metaQueryDef.getdefaultArgs();
        if (sList != null) {
            this.mDefArgs = sList.toArray();
        }
        this.mProcName = metaQueryDef.getstoredProcName();
        this.mName = this.mClientQueryDef.getqueryName();
        this.mNumParam = -1;
    }

    public final String getName() {
        return this.mName;
    }

    public final CacheClass getDeclaringClass() {
        return this.mClass;
    }

    public final int getNumberOfParameters() throws CacheException {
        if (this.mNumParam < 0) {
            this.mNumParam = this.mClientQueryDef.getnumParams();
        }
        return this.mNumParam;
    }

    public String getStatement(int n) throws CacheException {
        if (n > this.getNumberOfParameters()) {
            throw new CacheException("Invalid number of parameters (" + n + ") for query " + this.getName() + ": maximum allowed are " + this.getNumberOfParameters());
        }
        return this.makeStatement(n);
    }

    public String getStatement() throws CacheException {
        if (this.mStatement == null) {
            this.mStatement = this.makeStatement(this.getNumberOfParameters());
        }
        return this.mStatement;
    }

    protected abstract SysDatabase getDatabase();

    private String makeStatement(int n) {
        return Dataholder.makeQueryStatement(this.mProcName, n);
    }

    public int compareTo(Object object) {
        try {
            if (object instanceof String) {
                return this.getName().compareTo((String)object);
            }
            CacheQueryMetadata cacheQueryMetadata = (CacheQueryMetadata)object;
            return this.getName().compareTo(cacheQueryMetadata.getName());
        }
        catch (CacheException cacheException) {
            throw new ClassCastException("Query definition is invalid.");
        }
    }

    public String[] getDefaultArgs() {
        String[] stringArray = new String[this.mDefArgs.length];
        System.arraycopy(this.mDefArgs, 0, stringArray, 0, this.mDefArgs.length);
        return stringArray;
    }

    public String getProcName() {
        return this.mProcName;
    }

    public String[] getResultSetColumnNames() throws CacheException {
        if (this.mColNames == null) {
            this.mColNames = this.mClientQueryDef.getcolNames();
        }
        if (this.mColNames == null) {
            throw new CacheException("No column names information is available for query " + this.mClass.getName() + ":" + this.mName);
        }
        String[] stringArray = new String[this.mColNames.size()];
        return this.mColNames.toArray(stringArray);
    }

    public CacheArgumentInfo[] getParameters() throws CacheException {
        if (this.mParameters == null) {
            try {
                this.initParameterArray();
            }
            catch (SQLException sQLException) {
                throw new CacheException(sQLException, "Failed to get parameters information for query " + this.mClass.getName() + ":" + this.mName);
            }
        }
        CacheArgumentInfo[] cacheArgumentInfoArray = new CacheArgumentInfo[this.mParameters.length];
        System.arraycopy(this.mParameters, 0, cacheArgumentInfoArray, 0, this.mParameters.length);
        return cacheArgumentInfoArray;
    }

    private synchronized void initParameterArray() throws CacheException, SQLException {
        if (this.mParameters != null) {
            return;
        }
        byte[] byArray = this.mClientQueryDef.getformalSpecParsed();
        Object object = SysListProxy.createSysList(byArray, false, new ConnectionInfo());
        this.mParameters = new CacheArgumentInfo[this.getNumberOfParameters()];
        for (int i = 0; i < this.mParameters.length; ++i) {
            Object object2 = SysListProxy.getSysList(object);
            String string = SysListProxy.getString(object2);
            String string2 = SysListProxy.getString(object2);
            SysListProxy.skip(object2, 1);
            String string3 = SysListProxy.getString(object2);
            int n = 16;
            if (string3 != null) {
                n |= 4;
            }
            CacheClass cacheClass = this.mClass.getDatabase().getCacheClass(string2);
            this.mParameters[i] = new QueryParameter(string, cacheClass, string2, string3, 0, n);
        }
    }
}

