/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.io.vfmem;

import java.io.OutputStream;
import org.apache.derby.impl.io.vfmem.BlockedByteArray;

public class BlockedByteArrayOutputStream
extends OutputStream {
    private BlockedByteArray src;
    private long pos;

    public BlockedByteArrayOutputStream(BlockedByteArray blockedByteArray, long l) {
        if (blockedByteArray == null) {
            throw new IllegalArgumentException("BlockedByteArray cannot be null");
        }
        this.src = blockedByteArray;
        this.pos = l;
    }

    void setPosition(long l) {
        this.pos = l;
    }

    long getPosition() {
        return this.pos;
    }

    public void write(int n) {
        this.pos += (long)this.src.writeByte(this.pos, (byte)n);
    }

    public void write(byte[] byArray, int n, int n2) {
        this.pos += (long)this.src.writeBytes(this.pos, byArray, n, n2);
    }

    public void close() {
        this.src = null;
    }
}

