/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.rte.comm;

import com.sap.dbtech.jdbc.exceptions.TimeoutException;
import com.sap.dbtech.rte.comm.CommunicationException;
import com.sap.dbtech.rte.comm.ConnectPacket;
import com.sap.dbtech.rte.comm.CserverPacketLayout;
import com.sap.dbtech.rte.comm.DbPacketLayout;
import com.sap.dbtech.rte.comm.JdbcCommunication;
import com.sap.dbtech.rte.comm.PacketLayout;
import com.sap.dbtech.rte.comm.RTEException;
import com.sap.dbtech.rte.comm.RteC;
import com.sap.dbtech.rte.comm.RteSocketPacket;
import com.sap.dbtech.util.FullswapMem;
import com.sap.dbtech.util.MessageTranslator;
import com.sap.dbtech.util.StructuredBytes;
import com.sap.dbtech.util.StructuredMem;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.sql.SQLException;
import java.util.Properties;

public abstract class BasicSocketComm
extends JdbcCommunication {
    protected String dbname;
    protected int port;
    protected String host;
    protected int maxSendLen;
    protected int receiverRef;
    protected int senderRef;
    protected OutputStream outstream;
    protected InputStream instream;
    protected static int DEFAULT_TIMEOUT = 0;
    protected int socketTimeOut;
    protected boolean dbSession;
    protected PacketLayout packetLayout;
    protected int remoteSwapping;
    public static final int controlPacketSize_C = 16384;
    protected Socket socket;
    protected int serviceType = 0;

    protected BasicSocketComm(String string, Properties properties) throws RTEException {
        int n;
        if (string == null || string.length() == 0) {
            string = "localhost";
        }
        if ((n = string.indexOf(":")) == -1) {
            this.host = string;
            this.port = this.getDefaultPort();
        } else {
            this.host = string.substring(0, n);
            try {
                this.port = Integer.parseInt(string.substring(n + 1));
            }
            catch (NumberFormatException numberFormatException) {
                throw new RTEException(MessageTranslator.translate("error.unknown.host", string, numberFormatException.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[13])));
            }
        }
        String string2 = null;
        if (properties != null) {
            string2 = properties.getProperty("communicationtimeout");
            String string3 = properties.getProperty("connecttype", "");
            if (string3.equalsIgnoreCase("OLTP")) {
                this.serviceType = 9;
            } else if (string3.equalsIgnoreCase("LIVECACHE")) {
                this.serviceType = 8;
            }
        }
        if (string2 == null) {
            this.socketTimeOut = DEFAULT_TIMEOUT;
        } else {
            try {
                this.socketTimeOut = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.socketTimeOut = DEFAULT_TIMEOUT;
            }
        }
    }

    protected abstract int getDefaultPort();

    protected abstract void openSocket() throws RTEException;

    protected abstract BasicSocketComm getNewCommunication() throws RTEException;

    private static void dumpRteHeader(StructuredMem structuredMem, PrintStream printStream) {
        printStream.println("RTE Header");
        printStream.print("ActSendLen: ");
        printStream.println(structuredMem.getInt4(0));
        printStream.print("ProtocolID: ");
        printStream.println(structuredMem.getInt1(4));
        printStream.print("MessClass: ");
        printStream.println(structuredMem.getInt1(5));
        printStream.print("RTEFlags: ");
        printStream.println(structuredMem.getInt1(6));
        printStream.print("ResidualPackets: ");
        printStream.println(structuredMem.getInt1(7));
        printStream.print("SenderRef: ");
        printStream.println(structuredMem.getInt4(8));
        printStream.print("ReceiverRef: ");
        printStream.println(structuredMem.getInt4(12));
        printStream.print("RTEReturnCode: ");
        printStream.println(structuredMem.getInt2(16));
        printStream.print("Filler: ");
        printStream.println(structuredMem.getInt2(18));
        printStream.print("MaxSendLen: ");
        printStream.println(structuredMem.getInt4(20));
    }

    protected DbPacketLayout doInfoRequest(String string) throws RTEException {
        StructuredBytes structuredBytes;
        DbPacketLayout dbPacketLayout = new DbPacketLayout();
        StructuredBytes structuredBytes2 = BasicSocketComm.createRawPacket(296);
        this.buildRTEHeader(structuredBytes2, 49);
        ConnectPacket connectPacket = new ConnectPacket(structuredBytes2.bytes(), string, dbPacketLayout, this.port, this.serviceType);
        connectPacket.close();
        this.sendData(structuredBytes2, connectPacket.length());
        try {
            structuredBytes = this.receiveConnect();
        }
        catch (RTEException rTEException) {
            this.release();
            this.openSocket();
            this.buildRTEHeader(structuredBytes2, 51);
            this.sendData(structuredBytes2, connectPacket.length());
            structuredBytes = this.receiveConnect();
            this.release();
            this.openSocket();
        }
        DbPacketLayout dbPacketLayout2 = new DbPacketLayout(structuredBytes, false, true);
        return dbPacketLayout2;
    }

    protected static StructuredBytes createRawPacket(int n) {
        return new StructuredBytes(n + 24);
    }

    protected static void sleep() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void connectDB(String string) throws RTEException {
        DbPacketLayout dbPacketLayout = null;
        dbPacketLayout = this.doInfoRequest(string);
        this.dbSession = true;
        this.dbname = string;
        this.packetLayout = this.dbConnectExchange(string, dbPacketLayout);
    }

    public void connectAdmin(String string, String string2, String string3) throws RTEException {
        CserverPacketLayout cserverPacketLayout = new CserverPacketLayout();
        this.sendAdminConnect(string, string2, string3, cserverPacketLayout);
        this.receiveConnect();
        this.packetLayout = cserverPacketLayout;
    }

    public String toString() {
        String string = super.toString() + " on " + this.socket;
        return string;
    }

    public boolean isConnected() {
        return this.socket != null;
    }

    protected void finalize() throws Throwable {
        if (this.socket != null) {
            this.release();
        }
        super.finalize();
    }

    protected void buildRTEHeader(StructuredBytes structuredBytes, int n) {
        structuredBytes.putInt4(0, 0);
        structuredBytes.putInt1(3, 4);
        structuredBytes.putInt1(n, 5);
        structuredBytes.putInt1(0, 6);
        structuredBytes.putInt1(0, 7);
        structuredBytes.putInt4(this.senderRef, 8);
        structuredBytes.putInt4(this.receiverRef, 12);
        structuredBytes.putInt2(0, 16);
        structuredBytes.putInt2(0, 18);
        structuredBytes.putInt4(this.maxSendLen, 20);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSocket() {
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
        }
        finally {
            this.socket = null;
        }
    }

    public void sqlarequest(StructuredMem structuredMem, int n) throws RTEException {
        this.request(structuredMem, n);
    }

    public void sqlarelease() throws RTEException {
        this.release();
    }

    public StructuredMem sqlareceive() throws RTEException {
        return this.receive();
    }

    public void cancel() throws SQLException {
        try {
            DbPacketLayout dbPacketLayout = new DbPacketLayout();
            BasicSocketComm basicSocketComm = this.getNewCommunication();
            StructuredBytes structuredBytes = BasicSocketComm.createRawPacket(296);
            this.buildRTEHeader(structuredBytes, 65);
            structuredBytes.putInt4(this.senderRef, 12);
            ConnectPacket connectPacket = new ConnectPacket(structuredBytes.bytes(), this.dbname, dbPacketLayout, this.port, this.serviceType);
            connectPacket.close();
            basicSocketComm.sendData(structuredBytes, connectPacket.length());
            basicSocketComm.closeSocket();
        }
        catch (RTEException rTEException) {
            throw new SQLException(rTEException.getMessage());
        }
    }

    protected void sendData(StructuredBytes structuredBytes, int n) throws RTEException {
        OutputStream outputStream;
        this.setActSendLen(structuredBytes, n);
        try {
            if (this.outstream == null) {
                this.outstream = this.socket.getOutputStream();
            }
            outputStream = this.outstream;
        }
        catch (IOException iOException) {
            throw new RTEException("sendData: getOutputStream failed", RteC.CommunicationErrorCodeMap_C[7]);
        }
        try {
            outputStream.write(structuredBytes.bytes(), 0, n + 24);
        }
        catch (IOException iOException) {
            TimeoutException.println(MessageTranslator.translate("error.send.write", String.valueOf(this.senderRef), iOException.getMessage()));
            throw new RTEException(MessageTranslator.translate("error.send.write", String.valueOf(this.senderRef), iOException.getMessage()), RteC.CommunicationErrorCodeMap_C[7]);
        }
    }

    private void sendDbConnect(String string, PacketLayout packetLayout, int n) throws RTEException {
        StructuredBytes structuredBytes = BasicSocketComm.createRawPacket(packetLayout.maxDataLength());
        this.buildRTEHeader(structuredBytes, 61);
        ConnectPacket connectPacket = new ConnectPacket(structuredBytes.bytes(), string, packetLayout, n, this.serviceType);
        connectPacket.close();
        this.sendData(structuredBytes, connectPacket.length());
    }

    private void sendAdminConnect(String string, String string2, String string3, PacketLayout packetLayout) throws RTEException {
        StructuredBytes structuredBytes = BasicSocketComm.createRawPacket(packetLayout.maxDataLength());
        this.buildRTEHeader(structuredBytes, 91);
        ConnectPacket connectPacket = new ConnectPacket(structuredBytes.bytes(), string, packetLayout, this.port, this.serviceType);
        connectPacket.addConnectString(string2, 100);
        connectPacket.addConnectString(string3, 112);
        connectPacket.close();
        this.sendData(structuredBytes, connectPacket.length());
    }

    public void request(StructuredMem structuredMem, int n) throws RTEException {
        StructuredBytes structuredBytes = ((RteSocketPacket)structuredMem).rteHeader;
        this.buildRTEHeader(structuredBytes, 63);
        this.sendData(structuredBytes, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        try {
            StructuredBytes structuredBytes = BasicSocketComm.createRawPacket(0);
            this.buildRTEHeader(structuredBytes, 66);
            this.sendData(structuredBytes, 0);
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.socket.close();
        }
        catch (IOException iOException) {
        }
        catch (RTEException rTEException) {
        }
        finally {
            this.socket = null;
        }
    }

    public void reconnect() throws RTEException {
        try {
            this.socket.close();
            this.socket = null;
        }
        catch (Exception exception) {
            this.socket = null;
        }
        this.openSocket();
        if (!this.dbSession) {
            throw new RTEException(MessageTranslator.translate("error.admin.reconnect"), RteC.CommunicationErrorCodeMap_C[3]);
        }
        this.connectDB(this.dbname);
    }

    protected StructuredMem receiveData() throws RTEException {
        boolean bl = true;
        byte[] byArray = new byte[24];
        int n = 0;
        int n2 = 0;
        byte[] byArray2 = null;
        StructuredBytes structuredBytes = null;
        StructuredBytes structuredBytes2 = null;
        try {
            InputStream inputStream = this.instream;
            while (bl || n2 < n) {
                int n3;
                int n4 = inputStream.read(byArray, 0, 24);
                if (n4 != 24) {
                    RTEException rTEException = new RTEException(MessageTranslator.translate("error.data.receivefailed"), RteC.CommunicationErrorCodeMap_C[8]);
                    throw rTEException;
                }
                if (bl) {
                    structuredBytes = this.replyMem(byArray);
                    bl = false;
                    int n5 = structuredBytes.getInt2(16);
                    if (n5 != 0) {
                        throw new CommunicationException(n5);
                    }
                    n = structuredBytes.getInt4(20) - n4;
                    byArray2 = new byte[n];
                    structuredBytes2 = new StructuredBytes(byArray2);
                }
                if ((n3 = structuredBytes.getInt4(0) - n4) < 0 || n2 + n3 > byArray2.length) {
                    // empty if block
                }
                while (n3 > 0) {
                    int n6;
                    try {
                        n6 = inputStream.read(byArray2, n2, n3);
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        throw new ArrayIndexOutOfBoundsException(MessageTranslator.translate("error.chunkoverflow", Integer.toString(n3), Integer.toString(n2), Integer.toString(byArray2.length)));
                    }
                    if (n6 < 0) {
                        throw new RTEException(MessageTranslator.translate("error.data.receivefailed"), RteC.CommunicationErrorCodeMap_C[8]);
                    }
                    n2 += n6;
                    n3 -= n6;
                }
            }
        }
        catch (IOException iOException) {
            throw new RTEException(MessageTranslator.translate("error.data.receivefailed.reason", iOException.getMessage()), RteC.CommunicationErrorCodeMap_C[8]);
        }
        return structuredBytes2;
    }

    public StructuredMem receive() throws RTEException {
        return this.receiveData();
    }

    protected int lookupPort() {
        return this.port;
    }

    public boolean isChallengeResponseSupported() throws SQLException {
        return this.packetLayout.isChallengeResponseSupported();
    }

    public StructuredMem getRequestPacket() {
        RteSocketPacket rteSocketPacket = new RteSocketPacket(this.packetLayout.maxCmdDataLength());
        return rteSocketPacket;
    }

    protected StructuredBytes receiveConnect() throws RTEException {
        int n;
        StructuredBytes structuredBytes;
        int n2 = 320;
        byte[] byArray = new byte[n2];
        try {
            int n3;
            int n4;
            if (n4 < 25) {
                throw new RTEException(MessageTranslator.translate("error.recv.connect"), RteC.CommunicationErrorCodeMap_C[8]);
            }
            this.remoteSwapping = byArray[25];
            structuredBytes = this.replyMem(byArray);
            n = structuredBytes.getInt4(0);
            if (n < 0 || n > 512000) {
                throw new RTEException(MessageTranslator.translate("error.connectreply.garbled"), RteC.CommunicationErrorCodeMap_C[8]);
            }
            for (n4 = this.instream.read(byArray, 0, n2); n4 < n; n4 += n3) {
                n3 = this.instream.read(byArray, n4, n - n4);
                if (n3 == -1) {
                    throw new RTEException(MessageTranslator.translate("error.connect.receivefailed", "End of file before packet was read."), RteC.CommunicationErrorCodeMap_C[1]);
                }
                try {
                    Thread.sleep(1L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        catch (IOException iOException) {
            throw new RTEException(MessageTranslator.translate("error.connect.receivefailed", iOException.getMessage()), RteC.CommunicationErrorCodeMap_C[1]);
        }
        this.senderRef = structuredBytes.getInt4(8);
        n = structuredBytes.getInt2(16);
        if (n != 0) {
            throw new RTEException(RteC.getCommunicationError(n), RteC.getCommunicationErrorMapCode(n));
        }
        return structuredBytes;
    }

    private PacketLayout dbConnectExchange(String string, PacketLayout packetLayout) throws RTEException {
        this.sendDbConnect(string, packetLayout, this.port);
        StructuredBytes structuredBytes = this.receiveConnect();
        packetLayout = new DbPacketLayout(structuredBytes, true, true);
        return packetLayout;
    }

    protected void setActSendLen(StructuredBytes structuredBytes, int n) {
        structuredBytes.putInt4(n += 24, 0);
        structuredBytes.putInt4(n, 20);
    }

    protected StructuredBytes replyMem(byte[] byArray) throws RTEException {
        StructuredBytes structuredBytes;
        switch (this.remoteSwapping) {
            case 1: {
                structuredBytes = new StructuredBytes(byArray);
                break;
            }
            case 2: {
                structuredBytes = new FullswapMem(byArray);
                break;
            }
            default: {
                throw new RTEException(MessageTranslator.translate("error.invalid.swapping"), -708);
            }
        }
        return structuredBytes;
    }

    public int getKernelTaskID() {
        return this.senderRef;
    }
}

