/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.metadata;

import com.intersys.classes.Compiler.LG.JavaClassDef;
import com.intersys.objects.CacheException;
import com.intersys.objects.SList;
import com.intersys.objects.reflect.CacheSerialStorageMetadata;
import java.util.Iterator;

class CacheSerialStorageMetadataImpl
implements CacheSerialStorageMetadata {
    private SerialStorageElementImpl[] mElements;

    CacheSerialStorageMetadataImpl(JavaClassDef javaClassDef) throws CacheException {
        SList sList = javaClassDef.getserialState();
        if (sList == null) {
            this.mElements = null;
            return;
        }
        Iterator iterator = sList.iterator();
        Object var4_4 = null;
        Object var5_5 = null;
        this.mElements = new SerialStorageElementImpl[sList.size() / 2];
        int n = 0;
        while (iterator.hasNext()) {
            var4_4 = iterator.next();
            if (!iterator.hasNext()) {
                throw new CacheException("bad serial storage");
            }
            var5_5 = iterator.next();
            this.mElements[n++] = new SerialStorageElementImpl(var4_4, var5_5, new Integer(n));
        }
    }

    public CacheSerialStorageMetadata.SerialStorageElement[] getStorageElements() {
        return this.mElements;
    }

    public static class SerialStorageElementImpl
    implements CacheSerialStorageMetadata.SerialStorageElement {
        private int mCollectionModifier;
        private String mFieldName;
        private int mIndex;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        SerialStorageElementImpl(Object object, Object object2, Object object3) throws CacheException {
            String string = (String)object2;
            if (string != null) {
                if (string.equals("array")) {
                    this.mCollectionModifier = 1;
                } else {
                    if (!string.equals("list")) throw new CacheException("unknown collection modifier in serial storage=" + string);
                    this.mCollectionModifier = 8;
                }
            } else {
                this.mCollectionModifier = 0;
            }
            this.mFieldName = (String)object;
            Integer n = (Integer)object3;
            this.mIndex = n != null ? n : 0;
        }

        public int getCollectionModifier() {
            return this.mCollectionModifier;
        }

        public String getFieldName() {
            return this.mFieldName;
        }

        public int getIndex() {
            return this.mIndex;
        }
    }
}

