/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.quick;

import com.intersys.cache.quick.LightDatabase;
import com.intersys.cache.quick.QuickCacheClassNew;
import com.intersys.objects.CacheException;
import com.intersys.objects.SystemError;
import com.intersys.objects.reflect.SQLColumn;
import com.intersys.objects.reflect.TableMetadata;
import com.intersys.objects.reflect.TypeModifierHelper;

public class ChidTableClass
extends QuickCacheClassNew {
    int mKeyColumn;
    private int mCollectionType;

    public ChidTableClass(LightDatabase lightDatabase, QuickCacheClassNew quickCacheClassNew, TableMetadata tableMetadata, int n) throws CacheException {
        super(quickCacheClassNew);
        this.setSQLTableMetadata(tableMetadata);
        this.addClassModifier(16);
        this.initChild(lightDatabase);
        this.mKeyColumn = -1;
        SQLColumn[] sQLColumnArray = tableMetadata.getColumns();
        for (int i = 0; i < sQLColumnArray.length; ++i) {
            if (!"element_key".equals(sQLColumnArray[i].getName())) continue;
            this.mKeyColumn = sQLColumnArray[i].getNumber() - 2;
            break;
        }
        if (this.mKeyColumn < 0) {
            throw new SystemError("Key column is not found in child table " + tableMetadata.getName());
        }
        this.mCollectionType = n;
    }

    public boolean isList() {
        return TypeModifierHelper.isList(this.mCollectionType);
    }

    public boolean isArray() {
        return TypeModifierHelper.isArray(this.mCollectionType);
    }

    public int getKeyColumn() throws CacheException {
        return this.mKeyColumn;
    }
}

