/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine;

import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.Term;
import org.hibernate.Hibernate;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XAnnotatedElement;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XMember;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.annotations.common.util.ReflectHelper;
import org.hibernate.search.SearchException;
import org.hibernate.search.SearchFactory;
import org.hibernate.search.annotations.Boost;
import org.hibernate.search.annotations.ContainedIn;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.Keyword;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.annotations.Text;
import org.hibernate.search.annotations.Unstored;
import org.hibernate.search.backend.AddLuceneWork;
import org.hibernate.search.backend.DeleteLuceneWork;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.WorkType;
import org.hibernate.search.bridge.BridgeFactory;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.util.BinderHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentBuilder<T> {
    private static final Log log = LogFactory.getLog(DocumentBuilder.class);
    private final PropertiesMetadata rootPropertiesMetadata = new PropertiesMetadata();
    private final XClass beanClass;
    private final DirectoryProvider directoryProvider;
    private String idKeywordName;
    private XMember idGetter;
    private final Analyzer analyzer;
    private Float idBoost;
    public static final String CLASS_FIELDNAME = "_hibernate_class";
    private TwoWayFieldBridge idBridge;
    private Set<Class> mappedSubclasses = new HashSet<Class>();
    private ReflectionManager reflectionManager;
    private int level = 0;
    private int maxLevel = Integer.MAX_VALUE;

    public DocumentBuilder(XClass clazz, Analyzer analyzer, DirectoryProvider directory, ReflectionManager reflectionManager) {
        this.beanClass = clazz;
        this.analyzer = analyzer;
        this.directoryProvider = directory;
        this.reflectionManager = reflectionManager;
        if (clazz == null) {
            throw new AssertionFailure("Unable to build a DocumemntBuilder with a null class");
        }
        this.rootPropertiesMetadata.boost = this.getBoost((XAnnotatedElement)clazz);
        HashSet<XClass> processedClasses = new HashSet<XClass>();
        processedClasses.add(clazz);
        this.initializeMembers(clazz, this.rootPropertiesMetadata, true, "", processedClasses);
        if (this.idKeywordName == null) {
            throw new SearchException("No document id for: " + clazz.getName());
        }
    }

    private void initializeMembers(XClass clazz, PropertiesMetadata propertiesMetadata, boolean isRoot, String prefix, Set<XClass> processedClasses) {
        for (XClass currClass = clazz; currClass != null; currClass = currClass.getSuperclass()) {
            List methods = currClass.getDeclaredProperties("property");
            for (XProperty method : methods) {
                this.initializeMember(method, propertiesMetadata, isRoot, prefix, processedClasses);
            }
            List fields = currClass.getDeclaredProperties("field");
            for (XProperty field : fields) {
                this.initializeMember(field, propertiesMetadata, isRoot, prefix, processedClasses);
            }
        }
    }

    private void initializeMember(XProperty member, PropertiesMetadata propertiesMetadata, boolean isRoot, String prefix, Set<XClass> processedClasses) {
        ContainedIn containedAnn;
        IndexedEmbedded embeddedAnn;
        org.hibernate.search.annotations.Field fieldAnn;
        Text textAnn;
        Unstored unstoredAnn;
        Keyword keywordAnn = (Keyword)member.getAnnotation(Keyword.class);
        if (keywordAnn != null) {
            String name = prefix + BinderHelper.getAttributeName((XMember)member, keywordAnn.name());
            if (isRoot && keywordAnn.id()) {
                this.idKeywordName = name;
                this.idBoost = this.getBoost((XAnnotatedElement)member);
                FieldBridge fieldBridge = BridgeFactory.guessType((XMember)member);
                if (!(fieldBridge instanceof TwoWayFieldBridge)) {
                    throw new SearchException("Bridge for document id does not implement IdFieldBridge: " + member.getName());
                }
                this.idBridge = (TwoWayFieldBridge)fieldBridge;
                DocumentBuilder.setAccessible((XMember)member);
                this.idGetter = member;
            } else {
                DocumentBuilder.setAccessible((XMember)member);
                propertiesMetadata.keywordGetters.add((XMember)member);
                propertiesMetadata.keywordNames.add(name);
                propertiesMetadata.keywordBridges.add(BridgeFactory.guessType((XMember)member));
            }
        }
        if ((unstoredAnn = (Unstored)member.getAnnotation(Unstored.class)) != null) {
            DocumentBuilder.setAccessible((XMember)member);
            propertiesMetadata.unstoredGetters.add((XMember)member);
            propertiesMetadata.unstoredNames.add(prefix + BinderHelper.getAttributeName((XMember)member, unstoredAnn.name()));
            propertiesMetadata.unstoredBridges.add(BridgeFactory.guessType((XMember)member));
        }
        if ((textAnn = (Text)member.getAnnotation(Text.class)) != null) {
            DocumentBuilder.setAccessible((XMember)member);
            propertiesMetadata.textGetters.add((XMember)member);
            propertiesMetadata.textNames.add(prefix + BinderHelper.getAttributeName((XMember)member, textAnn.name()));
            propertiesMetadata.textBridges.add(BridgeFactory.guessType((XMember)member));
        }
        DocumentId documentIdAnn = (DocumentId)member.getAnnotation(DocumentId.class);
        if (isRoot && documentIdAnn != null) {
            if (this.idKeywordName != null) {
                throw new AssertionFailure("Two document id assigned: " + this.idKeywordName + " and " + BinderHelper.getAttributeName((XMember)member, documentIdAnn.name()));
            }
            this.idKeywordName = prefix + BinderHelper.getAttributeName((XMember)member, documentIdAnn.name());
            FieldBridge fieldBridge = BridgeFactory.guessType((XMember)member);
            if (!(fieldBridge instanceof TwoWayFieldBridge)) {
                throw new SearchException("Bridge for document id does not implement IdFieldBridge: " + member.getName());
            }
            this.idBridge = (TwoWayFieldBridge)fieldBridge;
            this.idBoost = this.getBoost((XAnnotatedElement)member);
            DocumentBuilder.setAccessible((XMember)member);
            this.idGetter = member;
        }
        if ((fieldAnn = (org.hibernate.search.annotations.Field)member.getAnnotation(org.hibernate.search.annotations.Field.class)) != null) {
            DocumentBuilder.setAccessible((XMember)member);
            propertiesMetadata.fieldGetters.add((XMember)member);
            propertiesMetadata.fieldNames.add(prefix + BinderHelper.getAttributeName((XMember)member, fieldAnn.name()));
            propertiesMetadata.fieldStore.add(this.getStore(fieldAnn.store()));
            propertiesMetadata.fieldIndex.add(this.getIndex(fieldAnn.index()));
            propertiesMetadata.fieldBridges.add(BridgeFactory.guessType((XMember)member));
        }
        if ((embeddedAnn = (IndexedEmbedded)member.getAnnotation(IndexedEmbedded.class)) != null) {
            int oldMaxLevel = this.maxLevel;
            this.maxLevel = embeddedAnn.depth() + this.level > this.maxLevel ? this.maxLevel : embeddedAnn.depth() + this.level;
            ++this.level;
            if (this.maxLevel == Integer.MAX_VALUE && processedClasses.contains(member.getClassOrElementClass())) {
                throw new SearchException("Circular reference. Duplicate use of " + member.getClassOrElementClass().getName() + " in root entity " + this.beanClass.getName() + "#" + this.buildEmbeddedPrefix(prefix, embeddedAnn, member));
            }
            if (this.level <= this.maxLevel) {
                processedClasses.add(member.getClassOrElementClass());
                DocumentBuilder.setAccessible((XMember)member);
                propertiesMetadata.embeddedGetters.add((XMember)member);
                PropertiesMetadata metadata = new PropertiesMetadata();
                propertiesMetadata.embeddedPropertiesMetadata.add(metadata);
                metadata.boost = this.getBoost((XAnnotatedElement)member);
                String localPrefix = this.buildEmbeddedPrefix(prefix, embeddedAnn, member);
                this.initializeMembers(member.getClassOrElementClass(), metadata, false, localPrefix, processedClasses);
                processedClasses.remove(member.getClassOrElementClass());
            } else if (log.isTraceEnabled()) {
                String localPrefix = this.buildEmbeddedPrefix(prefix, embeddedAnn, member);
                log.trace((Object)("depth reached, ignoring " + localPrefix));
            }
            --this.level;
            this.maxLevel = oldMaxLevel;
        }
        if ((containedAnn = (ContainedIn)member.getAnnotation(ContainedIn.class)) != null) {
            DocumentBuilder.setAccessible((XMember)member);
            propertiesMetadata.containedInGetters.add((XMember)member);
        }
    }

    private String buildEmbeddedPrefix(String prefix, IndexedEmbedded embeddedAnn, XProperty member) {
        String localPrefix = prefix;
        localPrefix = ".".equals(embeddedAnn.prefix()) ? localPrefix + member.getName() + '.' : localPrefix + embeddedAnn.prefix();
        return localPrefix;
    }

    private Field.Store getStore(Store store) {
        switch (store) {
            case NO: {
                return Field.Store.NO;
            }
            case YES: {
                return Field.Store.YES;
            }
            case COMPRESS: {
                return Field.Store.COMPRESS;
            }
        }
        throw new AssertionFailure("Unexpected Store: " + (Object)((Object)store));
    }

    private Field.Index getIndex(Index index) {
        switch (index) {
            case NO: {
                return Field.Index.NO;
            }
            case NO_NORMS: {
                return Field.Index.NO_NORMS;
            }
            case TOKENIZED: {
                return Field.Index.TOKENIZED;
            }
            case UN_TOKENIZED: {
                return Field.Index.UN_TOKENIZED;
            }
        }
        throw new AssertionFailure("Unexpected Index: " + (Object)((Object)index));
    }

    private Float getBoost(XAnnotatedElement element) {
        if (element == null) {
            return null;
        }
        Boost boost = (Boost)element.getAnnotation(Boost.class);
        return boost != null ? Float.valueOf(boost.value()) : null;
    }

    private Object getMemberValue(Object bean, XMember getter) {
        Object value;
        try {
            value = getter.invoke(bean, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not get property value", e);
        }
        return value;
    }

    public void addWorkToQueue(T entity, Serializable id, WorkType workType, List<LuceneWork> queue, SearchFactory searchFactory) {
        Document doc;
        Class entityClass = Hibernate.getClass(entity);
        for (LuceneWork luceneWork : queue) {
            if (luceneWork.getEntityClass() != entityClass || !luceneWork.getId().equals(id)) continue;
            return;
        }
        boolean searchForContainers = false;
        if (workType == WorkType.ADD) {
            doc = this.getDocument(entity, id);
            queue.add(new AddLuceneWork(id, entityClass, doc));
            searchForContainers = true;
        } else if (workType == WorkType.DELETE) {
            queue.add(new DeleteLuceneWork(id, entityClass));
        } else if (workType == WorkType.UPDATE) {
            doc = this.getDocument(entity, id);
            queue.add(new DeleteLuceneWork(id, entityClass));
            queue.add(new AddLuceneWork(id, entityClass, doc));
            searchForContainers = true;
        } else {
            throw new AssertionFailure("Unknown WorkType: " + (Object)((Object)workType));
        }
        if (searchForContainers) {
            this.processContainedIn(entity, queue, this.rootPropertiesMetadata, searchFactory);
        }
    }

    private void processContainedIn(Object instance, List<LuceneWork> queue, PropertiesMetadata metadata, SearchFactory searchFactory) {
        for (int i = 0; i < metadata.containedInGetters.size(); ++i) {
            XMember member = metadata.containedInGetters.get(i);
            Object value = this.getMemberValue(instance, member);
            if (value == null) continue;
            if (member.isArray()) {
                for (Object arrayValue : (Object[])value) {
                    Class valueClass = Hibernate.getClass((Object)arrayValue);
                    DocumentBuilder<Object> builder = searchFactory.getDocumentBuilders().get(valueClass);
                    if (builder == null) continue;
                    this.processContainedInValue(arrayValue, queue, valueClass, builder, searchFactory);
                }
                continue;
            }
            if (member.isCollection()) {
                Collection collection = Map.class.equals((Object)member.getCollectionClass()) ? ((Map)value).values() : (Collection)value;
                for (Object collectionValue : collection) {
                    Class valueClass = Hibernate.getClass(collectionValue);
                    DocumentBuilder<Object> builder = searchFactory.getDocumentBuilders().get(valueClass);
                    if (builder == null) continue;
                    this.processContainedInValue(collectionValue, queue, valueClass, builder, searchFactory);
                }
                continue;
            }
            Class valueClass = Hibernate.getClass((Object)value);
            DocumentBuilder<Object> builder = searchFactory.getDocumentBuilders().get(valueClass);
            if (builder == null) continue;
            this.processContainedInValue(value, queue, valueClass, builder, searchFactory);
        }
    }

    private void processContainedInValue(Object value, List<LuceneWork> queue, Class valueClass, DocumentBuilder builder, SearchFactory searchFactory) {
        Serializable id = (Serializable)builder.getMemberValue(value, builder.idGetter);
        builder.addWorkToQueue(value, id, WorkType.UPDATE, queue, searchFactory);
    }

    public Document getDocument(T instance, Serializable id) {
        Document doc = new Document();
        XClass instanceClass = this.reflectionManager.toXClass(instance.getClass());
        if (this.rootPropertiesMetadata.boost != null) {
            doc.setBoost(this.rootPropertiesMetadata.boost.floatValue());
        }
        Field classField = new Field(CLASS_FIELDNAME, instanceClass.getName(), Field.Store.YES, Field.Index.UN_TOKENIZED);
        doc.add((Fieldable)classField);
        this.idBridge.set(this.idKeywordName, id, doc, Field.Store.YES, Field.Index.UN_TOKENIZED, this.idBoost);
        this.buildDocumentFields(instance, doc, this.rootPropertiesMetadata);
        return doc;
    }

    private void buildDocumentFields(Object instance, Document doc, PropertiesMetadata propertiesMetadata) {
        Object value;
        XMember member;
        int i;
        if (instance == null) {
            return;
        }
        for (i = 0; i < propertiesMetadata.keywordNames.size(); ++i) {
            member = propertiesMetadata.keywordGetters.get(i);
            value = this.getMemberValue(instance, member);
            propertiesMetadata.keywordBridges.get(i).set(propertiesMetadata.keywordNames.get(i), value, doc, Field.Store.YES, Field.Index.UN_TOKENIZED, this.getBoost((XAnnotatedElement)member));
        }
        for (i = 0; i < propertiesMetadata.textNames.size(); ++i) {
            member = propertiesMetadata.textGetters.get(i);
            value = this.getMemberValue(instance, member);
            propertiesMetadata.textBridges.get(i).set(propertiesMetadata.textNames.get(i), value, doc, Field.Store.YES, Field.Index.TOKENIZED, this.getBoost((XAnnotatedElement)member));
        }
        for (i = 0; i < propertiesMetadata.unstoredNames.size(); ++i) {
            member = propertiesMetadata.unstoredGetters.get(i);
            value = this.getMemberValue(instance, member);
            propertiesMetadata.unstoredBridges.get(i).set(propertiesMetadata.unstoredNames.get(i), value, doc, Field.Store.NO, Field.Index.TOKENIZED, this.getBoost((XAnnotatedElement)member));
        }
        for (i = 0; i < propertiesMetadata.fieldNames.size(); ++i) {
            member = propertiesMetadata.fieldGetters.get(i);
            value = this.getMemberValue(instance, member);
            propertiesMetadata.fieldBridges.get(i).set(propertiesMetadata.fieldNames.get(i), value, doc, propertiesMetadata.fieldStore.get(i), propertiesMetadata.fieldIndex.get(i), this.getBoost((XAnnotatedElement)member));
        }
        for (i = 0; i < propertiesMetadata.embeddedGetters.size(); ++i) {
            member = propertiesMetadata.embeddedGetters.get(i);
            value = this.getMemberValue(instance, member);
            this.buildDocumentFields(value, doc, propertiesMetadata.embeddedPropertiesMetadata.get(i));
        }
    }

    public Term getTerm(Serializable id) {
        return new Term(this.idKeywordName, this.idBridge.objectToString(id));
    }

    public DirectoryProvider getDirectoryProvider() {
        return this.directoryProvider;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    private static void setAccessible(XMember member) {
        if (!Modifier.isPublic(member.getModifiers())) {
            member.setAccessible(true);
        }
    }

    public TwoWayFieldBridge getIdBridge() {
        return this.idBridge;
    }

    public String getIdKeywordName() {
        return this.idKeywordName;
    }

    public static Class getDocumentClass(Document document) {
        String className = document.get(CLASS_FIELDNAME);
        try {
            return ReflectHelper.classForName((String)className);
        }
        catch (ClassNotFoundException e) {
            throw new SearchException("Unable to load indexed class: " + className, e);
        }
    }

    public static Serializable getDocumentId(SearchFactory searchFactory, Class clazz, Document document) {
        DocumentBuilder<Object> builder = searchFactory.getDocumentBuilders().get(clazz);
        if (builder == null) {
            throw new SearchException("No Lucene configuration set up for: " + clazz.getName());
        }
        return (Serializable)builder.getIdBridge().get(builder.getIdKeywordName(), document);
    }

    public void postInitialize(Set<Class> indexedClasses) {
        Class plainClass = this.reflectionManager.toClass(this.beanClass);
        HashSet<Class> tempMappedSubclasses = new HashSet<Class>();
        for (Class currentClass : indexedClasses) {
            if (!plainClass.isAssignableFrom(currentClass)) continue;
            tempMappedSubclasses.add(currentClass);
        }
        this.mappedSubclasses = Collections.unmodifiableSet(tempMappedSubclasses);
    }

    public Set<Class> getMappedSubclasses() {
        return this.mappedSubclasses;
    }

    private static class PropertiesMetadata {
        public Float boost = null;
        public final List<XMember> keywordGetters = new ArrayList<XMember>();
        public final List<String> keywordNames = new ArrayList<String>();
        public final List<FieldBridge> keywordBridges = new ArrayList<FieldBridge>();
        public final List<XMember> unstoredGetters = new ArrayList<XMember>();
        public final List<String> unstoredNames = new ArrayList<String>();
        public final List<FieldBridge> unstoredBridges = new ArrayList<FieldBridge>();
        public final List<XMember> textGetters = new ArrayList<XMember>();
        public final List<String> textNames = new ArrayList<String>();
        public final List<FieldBridge> textBridges = new ArrayList<FieldBridge>();
        public final List<String> fieldNames = new ArrayList<String>();
        public final List<XMember> fieldGetters = new ArrayList<XMember>();
        public final List<FieldBridge> fieldBridges = new ArrayList<FieldBridge>();
        public final List<Field.Store> fieldStore = new ArrayList<Field.Store>();
        public final List<Field.Index> fieldIndex = new ArrayList<Field.Index>();
        public final List<XMember> embeddedGetters = new ArrayList<XMember>();
        public final List<PropertiesMetadata> embeddedPropertiesMetadata = new ArrayList<PropertiesMetadata>();
        public final List<XMember> containedInGetters = new ArrayList<XMember>();

        private PropertiesMetadata() {
        }
    }
}

