/*
 * Decompiled with CFR 0.152.
 */
package javax.management.modelmbean;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import javax.management.Descriptor;
import javax.management.DescriptorAccess;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.DescriptorSupport;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;

public class ModelMBeanInfoSupport
extends MBeanInfo
implements ModelMBeanInfo,
Serializable {
    private static final MBeanAttributeInfo[] EMPTY_ATTRS = new MBeanAttributeInfo[0];
    private static final MBeanConstructorInfo[] EMPTY_CTRS = new MBeanConstructorInfo[0];
    private static final MBeanNotificationInfo[] EMPTY_NOTIFICATIONS = new MBeanNotificationInfo[0];
    private static final MBeanOperationInfo[] EMPTY_OPS = new MBeanOperationInfo[0];
    private static final long serialVersionUID = -1935722590756516193L;
    private Descriptor modelMBeanDescriptor;
    private MBeanAttributeInfo[] modelMBeanAttributes;
    private MBeanConstructorInfo[] modelMBeanConstructors;
    private MBeanNotificationInfo[] modelMBeanNotifications;
    private MBeanOperationInfo[] modelMBeanOperations;

    public ModelMBeanInfoSupport(String className, String description, ModelMBeanAttributeInfo[] attributes, ModelMBeanConstructorInfo[] constructors, ModelMBeanOperationInfo[] operations, ModelMBeanNotificationInfo[] notifications) {
        this(className, description, attributes, constructors, operations, notifications, null);
    }

    public ModelMBeanInfoSupport(String className, String description, ModelMBeanAttributeInfo[] attributes, ModelMBeanConstructorInfo[] constructors, ModelMBeanOperationInfo[] operations, ModelMBeanNotificationInfo[] notifications, Descriptor mbeanDescriptor) {
        super(className, description, attributes, constructors, operations, notifications);
        this.modelMBeanAttributes = attributes != null ? attributes : EMPTY_ATTRS;
        this.modelMBeanConstructors = constructors != null ? constructors : EMPTY_CTRS;
        this.modelMBeanNotifications = notifications != null ? notifications : EMPTY_NOTIFICATIONS;
        this.modelMBeanOperations = operations != null ? operations : EMPTY_OPS;
        this.checkAndSetDescriptor(mbeanDescriptor);
    }

    public ModelMBeanInfoSupport(ModelMBeanInfo model) {
        super(model.getClassName(), model.getDescription(), model.getAttributes(), model.getConstructors(), model.getOperations(), model.getNotifications());
        int i;
        if (model.getAttributes() != null) {
            MBeanAttributeInfo[] attributes = model.getAttributes();
            this.modelMBeanAttributes = new ModelMBeanAttributeInfo[attributes.length];
            for (i = 0; i < attributes.length; ++i) {
                MBeanAttributeInfo attribute = attributes[i];
                this.modelMBeanAttributes[i] = attribute instanceof ModelMBeanAttributeInfo ? new ModelMBeanAttributeInfo((ModelMBeanAttributeInfo)attribute) : new ModelMBeanAttributeInfo(attribute.getName(), attribute.getType(), attribute.getDescription(), attribute.isReadable(), attribute.isWritable(), attribute.isIs());
            }
        }
        if (model.getConstructors() != null) {
            MBeanConstructorInfo[] constructors = model.getConstructors();
            this.modelMBeanConstructors = new ModelMBeanConstructorInfo[constructors.length];
            for (i = 0; i < constructors.length; ++i) {
                MBeanConstructorInfo constructor = constructors[i];
                this.modelMBeanConstructors[i] = constructor instanceof ModelMBeanConstructorInfo ? new ModelMBeanConstructorInfo((ModelMBeanConstructorInfo)constructor) : new ModelMBeanConstructorInfo(constructor.getName(), constructor.getDescription(), constructor.getSignature());
            }
        }
        if (model.getOperations() != null) {
            MBeanOperationInfo[] operations = model.getOperations();
            this.modelMBeanOperations = new ModelMBeanOperationInfo[operations.length];
            for (i = 0; i < operations.length; ++i) {
                MBeanOperationInfo operation = operations[i];
                this.modelMBeanOperations[i] = operation instanceof ModelMBeanOperationInfo ? new ModelMBeanOperationInfo((ModelMBeanOperationInfo)operation) : new ModelMBeanOperationInfo(operation.getName(), operation.getDescription(), operation.getSignature(), operation.getReturnType(), operation.getImpact());
            }
        }
        if (model.getNotifications() != null) {
            MBeanNotificationInfo[] notifications = model.getNotifications();
            this.modelMBeanNotifications = new ModelMBeanNotificationInfo[notifications.length];
            for (i = 0; i < notifications.length; ++i) {
                MBeanNotificationInfo notification = notifications[i];
                this.modelMBeanNotifications[i] = notification instanceof ModelMBeanNotificationInfo ? new ModelMBeanNotificationInfo((ModelMBeanNotificationInfo)notification) : new ModelMBeanNotificationInfo(notification.getNotifTypes(), notification.getName(), notification.getDescription());
            }
        }
        Descriptor mBeanDescriptor = null;
        try {
            mBeanDescriptor = model.getMBeanDescriptor();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.checkAndSetDescriptor(mBeanDescriptor);
    }

    public Object clone() {
        return new ModelMBeanInfoSupport(this);
    }

    public Descriptor[] getDescriptors(String type) throws MBeanException, RuntimeOperationsException {
        if (type == null) {
            Descriptor[] attrs = this.getDescriptors("attribute");
            Descriptor[] opers = this.getDescriptors("operation");
            Descriptor[] ctors = this.getDescriptors("constructor");
            Descriptor[] notifs = this.getDescriptors("notification");
            Descriptor[] all = new Descriptor[attrs.length + opers.length + ctors.length + notifs.length + 1];
            int i = 0;
            all[i] = this.getMBeanDescriptor();
            System.arraycopy(attrs, 0, all, ++i, attrs.length);
            System.arraycopy(opers, 0, all, i += attrs.length, opers.length);
            System.arraycopy(ctors, 0, all, i += opers.length, ctors.length);
            System.arraycopy(notifs, 0, all, i += ctors.length, notifs.length);
            return all;
        }
        if (type.equals("mbean")) {
            return new Descriptor[]{this.getMBeanDescriptor()};
        }
        if (type.equals("attribute")) {
            MBeanAttributeInfo[] attrs = this.modelMBeanAttributes;
            if (attrs == null) {
                return new Descriptor[0];
            }
            Descriptor[] attributes = new Descriptor[attrs.length];
            for (int i = 0; i < attrs.length; ++i) {
                ModelMBeanAttributeInfo attr = (ModelMBeanAttributeInfo)attrs[i];
                attributes[i] = attr.getDescriptor();
            }
            return attributes;
        }
        if (type.equals("operation")) {
            MBeanOperationInfo[] opers = this.modelMBeanOperations;
            if (opers == null) {
                return new Descriptor[0];
            }
            Descriptor[] operations = new Descriptor[opers.length];
            for (int i = 0; i < opers.length; ++i) {
                ModelMBeanOperationInfo oper = (ModelMBeanOperationInfo)opers[i];
                operations[i] = oper.getDescriptor();
            }
            return operations;
        }
        if (type.equals("constructor")) {
            MBeanConstructorInfo[] ctors = this.modelMBeanConstructors;
            if (ctors == null) {
                return new Descriptor[0];
            }
            Descriptor[] constructors = new Descriptor[ctors.length];
            for (int i = 0; i < ctors.length; ++i) {
                ModelMBeanConstructorInfo ctor = (ModelMBeanConstructorInfo)ctors[i];
                constructors[i] = ctor.getDescriptor();
            }
            return constructors;
        }
        if (type.equals("notification")) {
            MBeanNotificationInfo[] notifs = this.modelMBeanNotifications;
            if (notifs == null) {
                return new Descriptor[0];
            }
            Descriptor[] notifications = new Descriptor[notifs.length];
            for (int i = 0; i < notifs.length; ++i) {
                ModelMBeanNotificationInfo notif = (ModelMBeanNotificationInfo)notifs[i];
                notifications[i] = notif.getDescriptor();
            }
            return notifications;
        }
        throw new RuntimeOperationsException(new IllegalArgumentException("Invalid descriptor type"));
    }

    public void setDescriptors(Descriptor[] descriptors) throws MBeanException, RuntimeOperationsException {
        if (descriptors == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Descriptors cannot be null"));
        }
        RuntimeOperationsException x = null;
        for (int i = 0; i < descriptors.length; ++i) {
            try {
                this.setDescriptor(descriptors[i], null);
                continue;
            }
            catch (RuntimeOperationsException ignored) {
                x = ignored;
            }
        }
        if (x != null) {
            throw x;
        }
    }

    public Descriptor getDescriptor(String name) throws MBeanException, RuntimeOperationsException {
        return this.getDescriptor(name, null);
    }

    public Descriptor getDescriptor(String name, String type) throws MBeanException, RuntimeOperationsException {
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Descriptor name cannot be null"));
        }
        if ("MBean".equals(type)) {
            return this.getMBeanDescriptor();
        }
        if (type != null) {
            Descriptor[] descrs = this.getDescriptors(type);
            for (int i = 0; i < descrs.length; ++i) {
                Descriptor descr = descrs[i];
                if (!name.equals(descr.getFieldValue("name"))) continue;
                return descr;
            }
        } else {
            Descriptor result = this.findDescriptorByName(this.modelMBeanAttributes, name);
            if (result != null) {
                return result;
            }
            result = this.findDescriptorByName(this.modelMBeanConstructors, name);
            if (result != null) {
                return result;
            }
            result = this.findDescriptorByName(this.modelMBeanNotifications, name);
            if (result != null) {
                return result;
            }
            result = this.findDescriptorByName(this.modelMBeanOperations, name);
            if (result != null) {
                return result;
            }
        }
        return null;
    }

    public void setDescriptor(Descriptor descriptor, String descriptorType) throws MBeanException, RuntimeOperationsException {
        block11: {
            MBeanOperationInfo[] opers;
            String name;
            block15: {
                block14: {
                    block13: {
                        block12: {
                            if (descriptor == null) {
                                return;
                            }
                            if (descriptorType == null) {
                                descriptorType = (String)descriptor.getFieldValue("descriptorType");
                                if (descriptorType == null) {
                                    throw new RuntimeOperationsException(new IllegalArgumentException("Field descriptorType in the given descriptor is not valid"));
                                }
                                if (descriptorType.equals("operation")) {
                                    String role = (String)descriptor.getFieldValue("role");
                                    if (role == null) {
                                        throw new RuntimeOperationsException(new IllegalArgumentException("Field role in the given descriptor is not valid"));
                                    }
                                    descriptorType = role;
                                }
                            }
                            if ((name = (String)descriptor.getFieldValue("name")) == null) {
                                throw new RuntimeOperationsException(new IllegalArgumentException("Field name in the given descriptor is not valid"));
                            }
                            if (!descriptorType.equals("MBean")) break block12;
                            this.setMBeanDescriptor(descriptor);
                            break block11;
                        }
                        if (!descriptorType.equals("attribute")) break block13;
                        MBeanAttributeInfo[] attrs = this.modelMBeanAttributes;
                        if (attrs == null) break block11;
                        for (int i = 0; i < attrs.length; ++i) {
                            ModelMBeanAttributeInfo attr = (ModelMBeanAttributeInfo)attrs[i];
                            if (!name.equals(attr.getName())) continue;
                            attr.setDescriptor(descriptor);
                            break block11;
                        }
                        break block11;
                    }
                    if (!descriptorType.equals("notification")) break block14;
                    MBeanNotificationInfo[] notifs = this.modelMBeanNotifications;
                    if (notifs == null) break block11;
                    for (int i = 0; i < notifs.length; ++i) {
                        ModelMBeanNotificationInfo notif = (ModelMBeanNotificationInfo)notifs[i];
                        if (!name.equals(notif.getName())) continue;
                        notif.setDescriptor(descriptor);
                        break block11;
                    }
                    break block11;
                }
                if (!descriptorType.equals("constructor")) break block15;
                MBeanConstructorInfo[] ctors = this.modelMBeanConstructors;
                if (ctors == null) break block11;
                for (int i = 0; i < ctors.length; ++i) {
                    ModelMBeanConstructorInfo ctor = (ModelMBeanConstructorInfo)ctors[i];
                    if (!name.equals(ctor.getName())) continue;
                    ctor.setDescriptor(descriptor);
                    break block11;
                }
                break block11;
            }
            if (descriptorType.equals("operation") && (opers = this.modelMBeanOperations) != null) {
                for (int i = 0; i < opers.length; ++i) {
                    ModelMBeanOperationInfo oper = (ModelMBeanOperationInfo)opers[i];
                    if (!name.equals(oper.getName())) continue;
                    oper.setDescriptor(descriptor);
                    break;
                }
            }
        }
    }

    public ModelMBeanAttributeInfo getAttribute(String name) throws MBeanException, RuntimeOperationsException {
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Name argument cannot be null"));
        }
        MBeanAttributeInfo[] attrs = this.modelMBeanAttributes;
        if (attrs != null) {
            for (int i = 0; i < attrs.length; ++i) {
                ModelMBeanAttributeInfo attr = (ModelMBeanAttributeInfo)attrs[i];
                if (!name.equals(attr.getName())) continue;
                return (ModelMBeanAttributeInfo)attr.clone();
            }
        }
        return null;
    }

    public ModelMBeanOperationInfo getOperation(String name) throws MBeanException, RuntimeOperationsException {
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Name argument cannot be null"));
        }
        MBeanOperationInfo[] opers = this.modelMBeanOperations;
        if (opers != null) {
            for (int i = 0; i < opers.length; ++i) {
                ModelMBeanOperationInfo oper = (ModelMBeanOperationInfo)opers[i];
                if (!name.equals(oper.getName())) continue;
                return (ModelMBeanOperationInfo)oper.clone();
            }
        }
        return null;
    }

    public ModelMBeanConstructorInfo getConstructor(String name) throws MBeanException, RuntimeOperationsException {
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Name argument cannot be null"));
        }
        MBeanConstructorInfo[] ctors = this.modelMBeanConstructors;
        if (ctors != null) {
            for (int i = 0; i < ctors.length; ++i) {
                ModelMBeanConstructorInfo ctor = (ModelMBeanConstructorInfo)ctors[i];
                if (!name.equals(ctor.getName())) continue;
                return (ModelMBeanConstructorInfo)ctor.clone();
            }
        }
        return null;
    }

    public ModelMBeanNotificationInfo getNotification(String name) throws MBeanException, RuntimeOperationsException {
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Name argument cannot be null"));
        }
        MBeanNotificationInfo[] notifs = this.modelMBeanNotifications;
        if (notifs != null) {
            for (int i = 0; i < notifs.length; ++i) {
                ModelMBeanNotificationInfo notif = (ModelMBeanNotificationInfo)notifs[i];
                if (!name.equals(notif.getName())) continue;
                return (ModelMBeanNotificationInfo)notif.clone();
            }
        }
        return null;
    }

    public Descriptor getMBeanDescriptor() throws MBeanException, RuntimeOperationsException {
        return (Descriptor)this.modelMBeanDescriptor.clone();
    }

    public void setMBeanDescriptor(Descriptor descriptor) throws MBeanException, RuntimeOperationsException {
        if (descriptor == null) {
            this.modelMBeanDescriptor = this.createDefaultMBeanDescriptor();
        } else if (this.isDescriptorValid(descriptor)) {
            this.modelMBeanDescriptor = (Descriptor)descriptor.clone();
        } else {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid descriptor"));
        }
    }

    public MBeanConstructorInfo[] getConstructors() {
        MBeanConstructorInfo[] ctors = this.modelMBeanConstructors;
        if (ctors == null) {
            return null;
        }
        MBeanConstructorInfo[] constructors = new ModelMBeanConstructorInfo[ctors.length];
        for (int i = 0; i < ctors.length; ++i) {
            ModelMBeanConstructorInfo ctor = (ModelMBeanConstructorInfo)ctors[i];
            constructors[i] = (ModelMBeanConstructorInfo)ctor.clone();
        }
        return constructors;
    }

    public MBeanAttributeInfo[] getAttributes() {
        MBeanAttributeInfo[] attrs = this.modelMBeanAttributes;
        if (attrs == null) {
            return null;
        }
        MBeanAttributeInfo[] attributes = new ModelMBeanAttributeInfo[attrs.length];
        for (int i = 0; i < attrs.length; ++i) {
            ModelMBeanAttributeInfo attr = (ModelMBeanAttributeInfo)attrs[i];
            attributes[i] = (ModelMBeanAttributeInfo)attr.clone();
        }
        return attributes;
    }

    public MBeanOperationInfo[] getOperations() {
        MBeanOperationInfo[] opers = this.modelMBeanOperations;
        if (opers == null) {
            return null;
        }
        MBeanOperationInfo[] operations = new ModelMBeanOperationInfo[opers.length];
        for (int i = 0; i < opers.length; ++i) {
            ModelMBeanOperationInfo oper = (ModelMBeanOperationInfo)opers[i];
            operations[i] = (ModelMBeanOperationInfo)oper.clone();
        }
        return operations;
    }

    public MBeanNotificationInfo[] getNotifications() {
        MBeanNotificationInfo[] notifs = this.modelMBeanNotifications;
        if (notifs == null) {
            return null;
        }
        MBeanNotificationInfo[] notifications = new ModelMBeanNotificationInfo[notifs.length];
        for (int i = 0; i < notifs.length; ++i) {
            ModelMBeanNotificationInfo notif = (ModelMBeanNotificationInfo)notifs[i];
            notifications[i] = (ModelMBeanNotificationInfo)notif.clone();
        }
        return notifications;
    }

    private void checkAndSetDescriptor(Descriptor descriptor) {
        if (descriptor == null) {
            this.modelMBeanDescriptor = this.createDefaultMBeanDescriptor();
        } else if (this.isDescriptorValid(descriptor)) {
            this.modelMBeanDescriptor = this.addRequiredFields(descriptor);
        } else {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid Descriptor"));
        }
    }

    private boolean isDescriptorValid(Descriptor descriptor) {
        if (!descriptor.isValid()) {
            return false;
        }
        String[] names = descriptor.getFieldNames();
        if (!ModelMBeanInfoSupport.containsIgnoreCase(names, "name") || !ModelMBeanInfoSupport.containsIgnoreCase(names, "descriptortype")) {
            return false;
        }
        String desctype = (String)descriptor.getFieldValue("descriptortype");
        return desctype.compareToIgnoreCase("mbean") == 0;
    }

    private Descriptor createDefaultMBeanDescriptor() {
        String[] names = new String[]{"name", "descriptorType", "displayName", "persistPolicy", "log", "export", "visibility"};
        int index = this.getClassName().lastIndexOf(46) + 1;
        Object[] values = new Object[]{this.getClassName().substring(index), "MBean", this.getClassName(), "Never", "F", "F", "1"};
        return new DescriptorSupport(names, values);
    }

    private Descriptor findDescriptorByName(MBeanFeatureInfo[] features, String name) {
        if (features != null) {
            for (int i = 0; i < features.length; ++i) {
                MBeanFeatureInfo feature = features[i];
                if (feature == null || !feature.getName().equals(name) || !(feature instanceof DescriptorAccess)) continue;
                return ((DescriptorAccess)((Object)feature)).getDescriptor();
            }
        }
        return null;
    }

    private Descriptor addRequiredFields(Descriptor d) {
        Descriptor result = (Descriptor)d.clone();
        String[] reqfields = new String[]{"displayname", "persistpolicy", "log", "export", "visibility"};
        String[] defvalues = new String[]{(String)d.getFieldValue("name"), "never", "F", "F", "1"};
        List<String> fields = Arrays.asList(d.getFieldNames());
        for (int i = 0; i < reqfields.length; ++i) {
            if (fields.contains(reqfields[i])) continue;
            result.setField(reqfields[i], defvalues[i]);
        }
        return result;
    }

    static boolean containsIgnoreCase(String[] fields, String field) {
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].equalsIgnoreCase(field)) continue;
            return true;
        }
        return false;
    }
}

