/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.HashSet;
import java.util.Vector;
import javax.management.AttributeChangeNotification;
import javax.management.Notification;
import javax.management.NotificationFilter;

public class AttributeChangeNotificationFilter
implements NotificationFilter,
Serializable {
    private static final long serialVersionUID = -6347317584796410029L;
    private static final String serialName = "enabledAttributes";
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("enabledAttributes", Vector.class)};
    private HashSet enabledAttributes = new HashSet();

    public int hashCode() {
        return this.enabledAttributes.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        try {
            AttributeChangeNotificationFilter other = (AttributeChangeNotificationFilter)obj;
            return this.getEnabledAttributes().equals(other.getEnabledAttributes());
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableAttribute(String name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        HashSet hashSet = this.enabledAttributes;
        synchronized (hashSet) {
            this.enabledAttributes.add(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableAttribute(String name) {
        if (name != null) {
            HashSet hashSet = this.enabledAttributes;
            synchronized (hashSet) {
                this.enabledAttributes.remove(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableAllAttributes() {
        HashSet hashSet = this.enabledAttributes;
        synchronized (hashSet) {
            this.enabledAttributes.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getEnabledAttributes() {
        HashSet hashSet = this.enabledAttributes;
        synchronized (hashSet) {
            return new Vector(this.enabledAttributes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNotificationEnabled(Notification notification) {
        if (!(notification instanceof AttributeChangeNotification)) {
            return false;
        }
        AttributeChangeNotification n = (AttributeChangeNotification)notification;
        if (!"jmx.attribute.change".equals(n.getType())) {
            return false;
        }
        String attributeName = n.getAttributeName();
        if (attributeName != null) {
            HashSet hashSet = this.enabledAttributes;
            synchronized (hashSet) {
                if (this.enabledAttributes.contains(attributeName)) {
                    return true;
                }
            }
        }
        return false;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = in.readFields();
        Vector vector = (Vector)fields.get(serialName, null);
        if (fields.defaulted(serialName)) {
            throw new StreamCorruptedException("Serialized stream corrupted: expecting a non-null Vector");
        }
        if (this.enabledAttributes == null) {
            this.enabledAttributes = new HashSet();
        }
        this.enabledAttributes.clear();
        this.enabledAttributes.addAll(vector);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        ObjectOutputStream.PutField fields = out.putFields();
        Vector vector = this.getEnabledAttributes();
        fields.put(serialName, vector);
        out.writeFields();
    }
}

