/*
 * Decompiled with CFR 0.152.
 */
package mx4j.server.interceptor;

import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ReflectionException;
import mx4j.server.MBeanMetaData;
import mx4j.server.interceptor.DefaultMBeanServerInterceptor;

public class ContextClassLoaderMBeanServerInterceptor
extends DefaultMBeanServerInterceptor {
    public ContextClassLoaderMBeanServerInterceptor() {
        this.setEnabled(false);
    }

    @Override
    public String getType() {
        return "contextclassloader";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNotificationListener(MBeanMetaData metadata, NotificationListener listener, NotificationFilter filter, Object handback) {
        if (this.isEnabled()) {
            ClassLoader context = this.getContextClassLoader();
            if (metadata.getClassLoader() != context) {
                try {
                    this.setContextClassLoader(metadata.getClassLoader());
                    super.addNotificationListener(metadata, listener, filter, handback);
                    return;
                }
                finally {
                    this.setContextClassLoader(context);
                }
            }
        }
        super.addNotificationListener(metadata, listener, filter, handback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNotificationListener(MBeanMetaData metadata, NotificationListener listener) throws ListenerNotFoundException {
        if (this.isEnabled()) {
            ClassLoader context = this.getContextClassLoader();
            if (metadata.getClassLoader() != context) {
                try {
                    this.setContextClassLoader(metadata.getClassLoader());
                    super.removeNotificationListener(metadata, listener);
                    return;
                }
                finally {
                    this.setContextClassLoader(context);
                }
            }
        }
        super.removeNotificationListener(metadata, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNotificationListener(MBeanMetaData metadata, NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        if (this.isEnabled()) {
            ClassLoader context = this.getContextClassLoader();
            if (metadata.getClassLoader() != context) {
                try {
                    this.setContextClassLoader(metadata.getClassLoader());
                    super.removeNotificationListener(metadata, listener, filter, handback);
                    return;
                }
                finally {
                    this.setContextClassLoader(context);
                }
            }
        }
        super.removeNotificationListener(metadata, listener, filter, handback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void instantiate(MBeanMetaData metadata, String className, String[] params, Object[] args) throws ReflectionException, MBeanException {
        if (this.isEnabled()) {
            ClassLoader context = this.getContextClassLoader();
            if (metadata.getClassLoader() != context) {
                try {
                    this.setContextClassLoader(metadata.getClassLoader());
                    super.instantiate(metadata, className, params, args);
                    return;
                }
                finally {
                    this.setContextClassLoader(context);
                }
            }
        }
        super.instantiate(metadata, className, params, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registration(MBeanMetaData metadata, int operation) throws MBeanRegistrationException {
        if (this.isEnabled()) {
            ClassLoader context = this.getContextClassLoader();
            if (metadata.getClassLoader() != context) {
                try {
                    this.setContextClassLoader(metadata.getClassLoader());
                    super.registration(metadata, operation);
                    return;
                }
                finally {
                    this.setContextClassLoader(context);
                }
            }
        }
        super.registration(metadata, operation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MBeanInfo getMBeanInfo(MBeanMetaData metadata) {
        if (this.isEnabled()) {
            ClassLoader context = this.getContextClassLoader();
            if (metadata.getClassLoader() != context) {
                try {
                    this.setContextClassLoader(metadata.getClassLoader());
                    MBeanInfo mBeanInfo = super.getMBeanInfo(metadata);
                    return mBeanInfo;
                }
                finally {
                    this.setContextClassLoader(context);
                }
            }
        }
        return super.getMBeanInfo(metadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(MBeanMetaData metadata, String method, String[] params, Object[] args) throws MBeanException, ReflectionException {
        if (this.isEnabled()) {
            ClassLoader context = this.getContextClassLoader();
            if (metadata.getClassLoader() != context) {
                try {
                    this.setContextClassLoader(metadata.getClassLoader());
                    Object object = super.invoke(metadata, method, params, args);
                    return object;
                }
                finally {
                    this.setContextClassLoader(context);
                }
            }
        }
        return super.invoke(metadata, method, params, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AttributeList getAttributes(MBeanMetaData metadata, String[] attributes) {
        if (this.isEnabled()) {
            ClassLoader context = this.getContextClassLoader();
            if (metadata.getClassLoader() != context) {
                try {
                    this.setContextClassLoader(metadata.getClassLoader());
                    AttributeList attributeList = super.getAttributes(metadata, attributes);
                    return attributeList;
                }
                finally {
                    this.setContextClassLoader(context);
                }
            }
        }
        return super.getAttributes(metadata, attributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AttributeList setAttributes(MBeanMetaData metadata, AttributeList attributes) {
        if (this.isEnabled()) {
            ClassLoader context = this.getContextClassLoader();
            if (metadata.getClassLoader() != context) {
                try {
                    this.setContextClassLoader(metadata.getClassLoader());
                    AttributeList attributeList = super.setAttributes(metadata, attributes);
                    return attributeList;
                }
                finally {
                    this.setContextClassLoader(context);
                }
            }
        }
        return super.setAttributes(metadata, attributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getAttribute(MBeanMetaData metadata, String attribute) throws MBeanException, AttributeNotFoundException, ReflectionException {
        if (this.isEnabled()) {
            ClassLoader context = this.getContextClassLoader();
            if (metadata.getClassLoader() != context) {
                try {
                    this.setContextClassLoader(metadata.getClassLoader());
                    Object object = super.getAttribute(metadata, attribute);
                    return object;
                }
                finally {
                    this.setContextClassLoader(context);
                }
            }
        }
        return super.getAttribute(metadata, attribute);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAttribute(MBeanMetaData metadata, Attribute attribute) throws MBeanException, AttributeNotFoundException, InvalidAttributeValueException, ReflectionException {
        if (this.isEnabled()) {
            ClassLoader context = this.getContextClassLoader();
            if (metadata.getClassLoader() != context) {
                try {
                    this.setContextClassLoader(metadata.getClassLoader());
                    super.setAttribute(metadata, attribute);
                    return;
                }
                finally {
                    this.setContextClassLoader(context);
                }
            }
        }
        super.setAttribute(metadata, attribute);
    }

    private ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    private void setContextClassLoader(final ClassLoader cl) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread.currentThread().setContextClassLoader(cl);
                return null;
            }
        });
    }
}

