/*
 * Decompiled with CFR 0.152.
 */
package mx4j.remote;

import java.io.IOException;
import java.util.Map;
import mx4j.remote.ConnectionNotificationEmitter;
import mx4j.remote.HeartBeat;

public abstract class AbstractHeartBeat
implements HeartBeat,
Runnable {
    private final ConnectionNotificationEmitter emitter;
    private long pulsePeriod;
    private int maxRetries;
    private Thread thread;
    private volatile boolean stopped;

    protected AbstractHeartBeat(ConnectionNotificationEmitter emitter, Map environment) {
        this.emitter = emitter;
        if (environment != null) {
            try {
                this.pulsePeriod = (Long)environment.get("jmx.remote.x.connection.heartbeat.period");
            }
            catch (Exception ignored) {
                // empty catch block
            }
            try {
                this.maxRetries = (Integer)environment.get("jmx.remote.x.connection.heartbeat.retries");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.pulsePeriod <= 0L) {
            this.pulsePeriod = 5000L;
        }
        if (this.maxRetries <= 0) {
            this.maxRetries = 3;
        }
    }

    @Override
    public long getPulsePeriod() {
        return this.pulsePeriod;
    }

    @Override
    public int getMaxRetries() {
        return this.maxRetries;
    }

    protected abstract void pulse() throws IOException;

    @Override
    public void start() throws IOException {
        this.thread = new Thread((Runnable)this, "Connection HeartBeat");
        this.thread.setDaemon(true);
        this.thread.start();
    }

    @Override
    public void stop() throws IOException {
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        this.thread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            int retries = 0;
            while (!this.stopped && !this.thread.isInterrupted()) {
                try {
                    Thread.sleep(this.pulsePeriod);
                    try {
                        this.pulse();
                        retries = 0;
                    }
                    catch (IOException x) {
                        if (retries++ != this.maxRetries) continue;
                        this.sendConnectionNotificationFailed();
                        break;
                    }
                }
                catch (InterruptedException x) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        finally {
            this.stopped = true;
        }
    }

    protected void sendConnectionNotificationFailed() {
        this.emitter.sendConnectionNotificationFailed();
    }
}

