/*
 * Decompiled with CFR 0.152.
 */
package mx4j.tools.mail;

import java.text.DateFormat;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import mx4j.log.Log;
import mx4j.log.Logger;
import mx4j.tools.mail.SMTPMBean;

public class SMTP
implements SMTPMBean,
NotificationListener,
MBeanRegistration {
    private MBeanServer server = null;
    private ObjectName targetMBeanName;
    private ObjectName objectName;
    private String notificationName;
    private Properties sessionProperties = new Properties();
    private Session session;
    private String content = "Empty default mail";
    private String mimeType = "text/plain";
    private String subject = "Empty Subject";
    private String fromAddress = "noreply";
    private String fromName = "MX4J default";
    private String toAddresses = null;
    private String ccAddresses = null;
    private String bccAddresses = null;
    private String serverHost;
    private String serverPassword;
    private String serverUserName;
    private int serverPort = 25;
    private int timeout = 10000;
    private boolean doLogin;
    private Object sessionLock = new Object();

    @Override
    public void handleNotification(Notification notification, Object handback) {
        if (this.notificationName != null && !notification.getType().equals(this.notificationName)) {
            return;
        }
        Logger log = this.getLogger();
        log.debug("Notification " + notification + " hit, sending message");
        this.sendMail();
    }

    private Logger getLogger() {
        return Log.getLogger(this.getClass().getName());
    }

    @Override
    public void sendMail() {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (SMTP.this.validState()) {
                    Logger logger = SMTP.this.getLogger();
                    Object object = SMTP.this.sessionLock;
                    synchronized (object) {
                        SMTP.this.createSession();
                        try {
                            MimeMessage message = new MimeMessage(SMTP.this.session);
                            message.setContent((Object)SMTP.this.doKeywordExpansion(SMTP.this.content), SMTP.this.mimeType);
                            message.setSubject(SMTP.this.doKeywordExpansion(SMTP.this.subject));
                            InternetAddress from = new InternetAddress(SMTP.this.fromAddress, SMTP.this.fromName);
                            message.setFrom((Address)from);
                            message.setReplyTo(new Address[]{from});
                            if (SMTP.this.toAddresses != null) {
                                message.addRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)SMTP.this.toAddresses));
                            }
                            if (SMTP.this.ccAddresses != null) {
                                message.addRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)SMTP.this.ccAddresses));
                            }
                            if (SMTP.this.bccAddresses != null) {
                                message.addRecipients(Message.RecipientType.BCC, (Address[])InternetAddress.parse((String)SMTP.this.bccAddresses));
                            }
                            Transport transport = SMTP.this.session.getTransport("smtp");
                            if (SMTP.this.doLogin) {
                                transport.connect(SMTP.this.serverHost, SMTP.this.serverPort, SMTP.this.serverUserName, SMTP.this.serverPassword);
                            } else {
                                transport.connect();
                            }
                            message.saveChanges();
                            if (logger.isEnabledFor(10)) {
                                logger.debug("Sending message");
                            }
                            transport.sendMessage((Message)message, message.getAllRecipients());
                            transport.close();
                            if (logger.isEnabledFor(10)) {
                                logger.debug("Message sent");
                            }
                        }
                        catch (Exception e) {
                            logger.error("Exception during message sending ", e);
                        }
                    }
                }
            }
        }).start();
    }

    private String doKeywordExpansion(String source) {
        StringBuffer sourceCopy = new StringBuffer();
        int index = -1;
        int lastIndex = 0;
        int length = source.length();
        while ((index = source.indexOf("$", lastIndex)) > 0) {
            sourceCopy.append(source.substring(lastIndex, index));
            if (index >= length - 1) break;
            lastIndex = ++index;
            if (source.charAt(index) == '$') {
                sourceCopy.append('$');
                ++lastIndex;
            }
            if (source.startsWith("date$", index)) {
                sourceCopy.append(DateFormat.getDateInstance().format(new Date()));
                lastIndex += 5;
            }
            if (source.startsWith("time$", index)) {
                sourceCopy.append(DateFormat.getTimeInstance().format(new Date()));
                lastIndex += 5;
            }
            if (source.startsWith("datetime$", index)) {
                sourceCopy.append(DateFormat.getDateTimeInstance().format(new Date()));
                lastIndex += 9;
            }
            if (source.startsWith("observed$", index) && this.targetMBeanName != null) {
                sourceCopy.append(this.targetMBeanName);
                lastIndex += 9;
            }
            if (source.startsWith("objectname$", index) && this.objectName != null) {
                sourceCopy.append(this.objectName);
                lastIndex += 11;
            }
            if (!source.startsWith("notification$", index) || this.notificationName == null) continue;
            sourceCopy.append(this.notificationName);
            lastIndex += 13;
        }
        sourceCopy.append(source.substring(lastIndex, length));
        return sourceCopy.toString();
    }

    private boolean validState() {
        return this.serverHost != null && this.toAddresses != null && (!this.doLogin || this.serverUserName != null || this.serverPassword != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSession() {
        Object object = this.sessionLock;
        synchronized (object) {
            if (this.session == null) {
                this.sessionProperties.setProperty("mail.smtp.host", this.serverHost);
                this.sessionProperties.setProperty("mail.smtp.port", Integer.toString(this.serverPort));
                this.sessionProperties.setProperty("mail.smtp.timeout", Integer.toString(this.timeout));
                this.sessionProperties.setProperty("mail.smtp.connectiontimeout", Integer.toString(this.timeout));
                this.sessionProperties.setProperty("mail.smtp.sendpartial", "true");
                this.session = Session.getInstance((Properties)this.sessionProperties, null);
            }
        }
    }

    @Override
    public String getBCC() {
        return this.bccAddresses;
    }

    @Override
    public void setBCC(String bccAddresses) {
        this.bccAddresses = bccAddresses;
    }

    @Override
    public void setCC(String ccAddresses) {
        this.ccAddresses = ccAddresses;
    }

    @Override
    public String getCC() {
        return this.ccAddresses;
    }

    @Override
    public String getFromAddress() {
        return this.fromAddress;
    }

    @Override
    public void setFromAddress(String fromAddress) {
        this.fromAddress = fromAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setServerHost(String host) {
        Object object = this.sessionLock;
        synchronized (object) {
            this.serverHost = host;
            this.session = null;
        }
    }

    @Override
    public String getServerHost() {
        return this.serverHost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setServerPort(int port) {
        Object object = this.sessionLock;
        synchronized (object) {
            this.serverPort = port;
            this.session = null;
        }
    }

    @Override
    public int getServerPort() {
        return this.serverPort;
    }

    @Override
    public void setServerUsername(String username) {
        this.serverUserName = username;
    }

    @Override
    public String getServerUsername() {
        return this.serverUserName;
    }

    @Override
    public void setServerPassword(String password) {
        this.serverPassword = password;
    }

    @Override
    public void setLoginToServer(boolean login) {
        this.doLogin = login;
    }

    @Override
    public boolean isLoginToServer() {
        return this.doLogin;
    }

    @Override
    public String getFromName() {
        return this.fromName;
    }

    @Override
    public void setFromName(String fromName) {
        this.fromName = fromName;
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    @Override
    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    @Override
    public String getNotificationName() {
        return this.notificationName;
    }

    @Override
    public void setNotificationName(String notificationName) {
        this.notificationName = notificationName;
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    @Override
    public void setSubject(String subject) {
        this.subject = subject;
    }

    @Override
    public String getContent() {
        return this.content;
    }

    @Override
    public void setContent(String content) {
        this.content = content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTimeout(int timeout) {
        Object object = this.sessionLock;
        synchronized (object) {
            this.timeout = timeout;
            this.session = null;
        }
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    @Override
    public void setObservedObject(ObjectName targetMBeanName) {
        this.targetMBeanName = targetMBeanName;
        this.registerListener();
    }

    @Override
    public ObjectName getObservedObject() {
        return this.targetMBeanName;
    }

    @Override
    public String getTo() {
        return this.toAddresses;
    }

    @Override
    public void setTo(String toAddresses) {
        this.toAddresses = toAddresses;
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.server = server;
        this.objectName = name;
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
        this.unregisterListener();
    }

    @Override
    public void postDeregister() {
    }

    protected void registerListener() {
        try {
            if (this.targetMBeanName != null && this.server.isInstanceOf(this.targetMBeanName, "javax.management.NotificationBroadcaster")) {
                this.server.addNotificationListener(this.targetMBeanName, this, (NotificationFilter)new MessageFilter(), null);
            }
        }
        catch (InstanceNotFoundException e) {
            Logger log = this.getLogger();
            log.error("Exception during notification registration", e);
        }
    }

    protected void unregisterListener() {
        try {
            if (this.targetMBeanName != null && this.server.isInstanceOf(this.targetMBeanName, "javax.management.NotificationBroadcaster")) {
                this.server.removeNotificationListener(this.targetMBeanName, this);
            }
        }
        catch (InstanceNotFoundException e) {
            Logger log = this.getLogger();
            log.error("Exception during notification unregistration", e);
        }
        catch (ListenerNotFoundException listenerNotFoundException) {
            // empty catch block
        }
    }

    private class MessageFilter
    implements NotificationFilter {
        private MessageFilter() {
        }

        @Override
        public boolean isNotificationEnabled(Notification notification) {
            return SMTP.this.notificationName == null || notification.getType() != null && notification.getType().equals(SMTP.this.notificationName);
        }
    }
}

